/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util;

import java.lang.reflect.Array;
import java.util.HashSet;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.PrimitiveArrayBuilder;

public final class ArrayBuilders {
    private BooleanBuilder _booleanBuilder = null;
    private ByteBuilder _byteBuilder = null;
    private ShortBuilder _shortBuilder = null;
    private IntBuilder _intBuilder = null;
    private LongBuilder _longBuilder = null;
    private FloatBuilder _floatBuilder = null;
    private DoubleBuilder _doubleBuilder = null;

    public BooleanBuilder getBooleanBuilder() {
        if (this._booleanBuilder == null) {
            this._booleanBuilder = new BooleanBuilder();
        }
        return this._booleanBuilder;
    }

    public ByteBuilder getByteBuilder() {
        if (this._byteBuilder == null) {
            this._byteBuilder = new ByteBuilder();
        }
        return this._byteBuilder;
    }

    public ShortBuilder getShortBuilder() {
        if (this._shortBuilder == null) {
            this._shortBuilder = new ShortBuilder();
        }
        return this._shortBuilder;
    }

    public IntBuilder getIntBuilder() {
        if (this._intBuilder == null) {
            this._intBuilder = new IntBuilder();
        }
        return this._intBuilder;
    }

    public LongBuilder getLongBuilder() {
        if (this._longBuilder == null) {
            this._longBuilder = new LongBuilder();
        }
        return this._longBuilder;
    }

    public FloatBuilder getFloatBuilder() {
        if (this._floatBuilder == null) {
            this._floatBuilder = new FloatBuilder();
        }
        return this._floatBuilder;
    }

    public DoubleBuilder getDoubleBuilder() {
        if (this._doubleBuilder == null) {
            this._doubleBuilder = new DoubleBuilder();
        }
        return this._doubleBuilder;
    }

    public static Object getArrayComparator(final Object object) {
        final int n2 = Array.getLength(object);
        final Class<?> clazz = object.getClass();
        return new Object(){

            public boolean equals(Object object4) {
                if (object4 == this) {
                    return true;
                }
                if (!ClassUtil.hasClass(object4, clazz)) {
                    return false;
                }
                if (Array.getLength(object4) != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object2;
                    Object object3 = Array.get(object, i2);
                    if (object3 == (object2 = Array.get(object4, i2)) || object3 == null || object3.equals(object2)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> HashSet<T> arrayToSet(T[] TArray) {
        if (TArray != null) {
            int n2 = TArray.length;
            HashSet<T> hashSet = new HashSet<T>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                hashSet.add(TArray[i2]);
            }
            return hashSet;
        }
        return new HashSet();
    }

    public static <T> T[] insertInListNoDup(T[] TArray, T t2) {
        int n2 = TArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (TArray[i2] != t2) continue;
            if (i2 == 0) {
                return TArray;
            }
            Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2);
            System.arraycopy(TArray, 0, objectArray, 1, i2);
            objectArray[0] = t2;
            int n3 = n2 - ++i2;
            if (n3 > 0) {
                System.arraycopy(TArray, i2, objectArray, i2, n3);
            }
            return objectArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2 + 1);
        if (n2 > 0) {
            System.arraycopy(TArray, 0, objectArray, 1, n2);
        }
        objectArray[0] = t2;
        return objectArray;
    }

    public static final class DoubleBuilder
    extends PrimitiveArrayBuilder<double[]> {
        @Override
        public final double[] _constructArray(int n2) {
            return new double[n2];
        }
    }

    public static final class FloatBuilder
    extends PrimitiveArrayBuilder<float[]> {
        @Override
        public final float[] _constructArray(int n2) {
            return new float[n2];
        }
    }

    public static final class LongBuilder
    extends PrimitiveArrayBuilder<long[]> {
        @Override
        public final long[] _constructArray(int n2) {
            return new long[n2];
        }
    }

    public static final class IntBuilder
    extends PrimitiveArrayBuilder<int[]> {
        @Override
        public final int[] _constructArray(int n2) {
            return new int[n2];
        }
    }

    public static final class ShortBuilder
    extends PrimitiveArrayBuilder<short[]> {
        @Override
        public final short[] _constructArray(int n2) {
            return new short[n2];
        }
    }

    public static final class ByteBuilder
    extends PrimitiveArrayBuilder<byte[]> {
        @Override
        public final byte[] _constructArray(int n2) {
            return new byte[n2];
        }
    }

    public static final class BooleanBuilder
    extends PrimitiveArrayBuilder<boolean[]> {
        @Override
        public final boolean[] _constructArray(int n2) {
            return new boolean[n2];
        }
    }
}

