/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser;

import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.LRUMap;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.TypeKey;

public final class SerializerCache {
    public static final int DEFAULT_MAX_CACHED = 4000;
    private final LRUMap<TypeKey, JsonSerializer<Object>> _sharedMap;
    private final AtomicReference<ReadOnlyClassToSerializerMap> _readOnlyMap;

    public SerializerCache() {
        this(4000);
    }

    public SerializerCache(int n2) {
        int n3 = Math.min(64, n2 >> 2);
        this._sharedMap = new LRUMap(n3, n2);
        this._readOnlyMap = new AtomicReference();
    }

    public ReadOnlyClassToSerializerMap getReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap readOnlyClassToSerializerMap = this._readOnlyMap.get();
        if (readOnlyClassToSerializerMap != null) {
            return readOnlyClassToSerializerMap;
        }
        return this._makeReadOnlyLookupMap();
    }

    private final synchronized ReadOnlyClassToSerializerMap _makeReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap readOnlyClassToSerializerMap = this._readOnlyMap.get();
        if (readOnlyClassToSerializerMap == null) {
            readOnlyClassToSerializerMap = ReadOnlyClassToSerializerMap.from(this._sharedMap);
            this._readOnlyMap.set(readOnlyClassToSerializerMap);
        }
        return readOnlyClassToSerializerMap;
    }

    public synchronized int size() {
        return this._sharedMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> untypedValueSerializer(Class<?> clazz) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(clazz, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> untypedValueSerializer(JavaType javaType) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(javaType, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> typedValueSerializer(JavaType javaType) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(javaType, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> typedValueSerializer(Class<?> clazz) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(clazz, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypedSerializer(JavaType javaType, JsonSerializer<Object> jsonSerializer) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(javaType, true), jsonSerializer) == null) {
                this._readOnlyMap.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypedSerializer(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(clazz, true), jsonSerializer) == null) {
                this._readOnlyMap.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(Class<?> clazz, JsonSerializer<Object> jsonSerializer, SerializerProvider serializerProvider) throws JsonMappingException {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(clazz, false), jsonSerializer) == null) {
                this._readOnlyMap.set(null);
            }
            if (jsonSerializer instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(JavaType javaType, JsonSerializer<Object> jsonSerializer, SerializerProvider serializerProvider) throws JsonMappingException {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(javaType, false), jsonSerializer) == null) {
                this._readOnlyMap.set(null);
            }
            if (jsonSerializer instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(Class<?> clazz, JavaType javaType, JsonSerializer<Object> jsonSerializer, SerializerProvider serializerProvider) throws JsonMappingException {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            JsonSerializer<Object> jsonSerializer2 = this._sharedMap.put(new TypeKey(clazz, false), jsonSerializer);
            JsonSerializer<Object> jsonSerializer3 = this._sharedMap.put(new TypeKey(javaType, false), jsonSerializer);
            if (jsonSerializer2 == null || jsonSerializer3 == null) {
                this._readOnlyMap.set(null);
            }
            if (jsonSerializer instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
            }
        }
    }

    public synchronized void flush() {
        this._sharedMap.clear();
    }
}

