/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonPointer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.type.WritableTypeId;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ArrayNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.BaseJsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ContainerNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.JsonNodeType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.MissingNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.RawValue;

public class ObjectNode
extends ContainerNode<ObjectNode>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, JsonNode> _children;

    public ObjectNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
        this._children = new LinkedHashMap<String, JsonNode>();
    }

    public ObjectNode(JsonNodeFactory jsonNodeFactory, Map<String, JsonNode> map) {
        super(jsonNodeFactory);
        this._children = map;
    }

    @Override
    protected JsonNode _at(JsonPointer jsonPointer) {
        return this.get(jsonPointer.getMatchingProperty());
    }

    public ObjectNode deepCopy() {
        ObjectNode objectNode = new ObjectNode(this._nodeFactory);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            objectNode._children.put(entry.getKey(), (JsonNode)entry.getValue().deepCopy());
        }
        return objectNode;
    }

    @Deprecated
    public ObjectNode with(String string) {
        JsonPointer jsonPointer = this._jsonPointerIfValid(string);
        if (jsonPointer != null) {
            return this.withObject(jsonPointer);
        }
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            if (jsonNode instanceof ObjectNode) {
                return (ObjectNode)jsonNode;
            }
            throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type `ObjectNode` (but `" + jsonNode.getClass().getName() + "`)");
        }
        ObjectNode objectNode = this.objectNode();
        this._children.put(string, objectNode);
        return objectNode;
    }

    public ArrayNode withArray(String string) {
        JsonPointer jsonPointer = this._jsonPointerIfValid(string);
        if (jsonPointer != null) {
            return this.withArray(jsonPointer);
        }
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            if (jsonNode instanceof ArrayNode) {
                return (ArrayNode)jsonNode;
            }
            throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type `ArrayNode` (but `" + jsonNode.getClass().getName() + "`)");
        }
        ArrayNode arrayNode = this.arrayNode();
        this._children.put(string, arrayNode);
        return arrayNode;
    }

    @Override
    protected ObjectNode _withObject(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl2) {
        if (jsonPointer2.matches()) {
            return this;
        }
        JsonNode jsonNode = this._at(jsonPointer2);
        if (jsonNode != null && jsonNode instanceof BaseJsonNode) {
            ObjectNode objectNode = ((BaseJsonNode)jsonNode)._withObject(jsonPointer, jsonPointer2.tail(), overwriteMode, bl2);
            if (objectNode != null) {
                return objectNode;
            }
            this._withXxxVerifyReplace(jsonPointer, jsonPointer2, overwriteMode, bl2, jsonNode);
        }
        return this._withObjectAddTailProperty(jsonPointer2, bl2);
    }

    @Override
    protected ArrayNode _withArray(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl2) {
        if (jsonPointer2.matches()) {
            return null;
        }
        JsonNode jsonNode = this._at(jsonPointer2);
        if (jsonNode != null && jsonNode instanceof BaseJsonNode) {
            ArrayNode arrayNode = ((BaseJsonNode)jsonNode)._withArray(jsonPointer, jsonPointer2.tail(), overwriteMode, bl2);
            if (arrayNode != null) {
                return arrayNode;
            }
            this._withXxxVerifyReplace(jsonPointer, jsonPointer2, overwriteMode, bl2, jsonNode);
        }
        return this._withArrayAddTailProperty(jsonPointer2, bl2);
    }

    protected ObjectNode _withObjectAddTailProperty(JsonPointer jsonPointer, boolean bl2) {
        String string = jsonPointer.getMatchingProperty();
        if ((jsonPointer = jsonPointer.tail()).matches()) {
            return this.putObject(string);
        }
        if (bl2 && jsonPointer.mayMatchElement()) {
            return this.putArray(string)._withObjectAddTailElement(jsonPointer, bl2);
        }
        return this.putObject(string)._withObjectAddTailProperty(jsonPointer, bl2);
    }

    protected ArrayNode _withArrayAddTailProperty(JsonPointer jsonPointer, boolean bl2) {
        String string = jsonPointer.getMatchingProperty();
        if ((jsonPointer = jsonPointer.tail()).matches()) {
            return this.putArray(string);
        }
        if (bl2 && jsonPointer.mayMatchElement()) {
            return this.putArray(string)._withArrayAddTailElement(jsonPointer, bl2);
        }
        return this.putObject(string)._withArrayAddTailProperty(jsonPointer, bl2);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.OBJECT;
    }

    @Override
    public final boolean isObject() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public boolean isEmpty() {
        return this._children.isEmpty();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.values().iterator();
    }

    @Override
    public JsonNode get(int n2) {
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return this._children.get(string);
    }

    @Override
    public Iterator<String> fieldNames() {
        return this._children.keySet().iterator();
    }

    @Override
    public JsonNode path(int n2) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            return jsonNode;
        }
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode required(String string) {
        JsonNode jsonNode = this._children.get(string);
        if (jsonNode != null) {
            return jsonNode;
        }
        return (JsonNode)this._reportRequiredViolation("No value for property '%s' of `ObjectNode`", string);
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        return this._children.entrySet().iterator();
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator, JsonNode jsonNode) {
        if (!(jsonNode instanceof ObjectNode)) {
            return false;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        Map<String, JsonNode> map = this._children;
        Map<String, JsonNode> map2 = objectNode._children;
        int n2 = map.size();
        if (map2.size() != n2) {
            return false;
        }
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            JsonNode jsonNode2 = map2.get(entry.getKey());
            if (jsonNode2 != null && entry.getValue().equals(comparator, jsonNode2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JsonNode findValue(String string) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                return entry.getValue();
            }
            JsonNode jsonNode = entry.getValue().findValue(string);
            if (jsonNode == null) continue;
            return jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string, List<JsonNode> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<JsonNode>();
                }
                list.add(entry.getValue());
                continue;
            }
            list = entry.getValue().findValues(string, list);
        }
        return list;
    }

    @Override
    public List<String> findValuesAsText(String string, List<String> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(entry.getValue().asText());
                continue;
            }
            list = entry.getValue().findValuesAsText(string, list);
        }
        return list;
    }

    @Override
    public ObjectNode findParent(String string) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                return this;
            }
            JsonNode jsonNode = entry.getValue().findParent(string);
            if (jsonNode == null) continue;
            return (ObjectNode)jsonNode;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string, List<JsonNode> list) {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            if (string.equals(entry.getKey())) {
                if (list == null) {
                    list = new ArrayList<JsonNode>();
                }
                list.add(this);
                continue;
            }
            list = entry.getValue().findParents(string, list);
        }
        return list;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (serializerProvider != null) {
            boolean bl2;
            boolean bl3 = !serializerProvider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
            boolean bl4 = bl2 = !serializerProvider.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES);
            if (bl3 || bl2) {
                jsonGenerator.writeStartObject(this);
                this.serializeFilteredContents(jsonGenerator, serializerProvider, bl3, bl2);
                jsonGenerator.writeEndObject();
                return;
            }
        }
        jsonGenerator.writeStartObject(this);
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            JsonNode jsonNode = entry.getValue();
            jsonGenerator.writeFieldName(entry.getKey());
            jsonNode.serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        boolean bl2 = false;
        boolean bl3 = false;
        if (serializerProvider != null) {
            bl2 = !serializerProvider.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
            bl3 = !serializerProvider.isEnabled(JsonNodeFeature.WRITE_NULL_PROPERTIES);
        }
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(this, JsonToken.START_OBJECT));
        if (bl2 || bl3) {
            this.serializeFilteredContents(jsonGenerator, serializerProvider, bl2, bl3);
        } else {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                JsonNode jsonNode = entry.getValue();
                jsonGenerator.writeFieldName(entry.getKey());
                jsonNode.serialize(jsonGenerator, serializerProvider);
            }
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected void serializeFilteredContents(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean bl2, boolean bl3) throws IOException {
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            BaseJsonNode baseJsonNode = (BaseJsonNode)entry.getValue();
            if (bl2 && baseJsonNode.isArray() && baseJsonNode.isEmpty(serializerProvider) || bl3 && baseJsonNode.isNull()) continue;
            jsonGenerator.writeFieldName(entry.getKey());
            baseJsonNode.serialize(jsonGenerator, serializerProvider);
        }
    }

    public <T extends JsonNode> T set(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._children.put(string, jsonNode);
        return (T)this;
    }

    public <T extends JsonNode> T setAll(Map<String, ? extends JsonNode> map) {
        for (Map.Entry<String, ? extends JsonNode> entry : map.entrySet()) {
            JsonNode jsonNode = entry.getValue();
            if (jsonNode == null) {
                jsonNode = this.nullNode();
            }
            this._children.put(entry.getKey(), jsonNode);
        }
        return (T)this;
    }

    public <T extends JsonNode> T setAll(ObjectNode objectNode) {
        this._children.putAll(objectNode._children);
        return (T)this;
    }

    public JsonNode replace(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string, jsonNode);
    }

    public <T extends JsonNode> T without(String string) {
        this._children.remove(string);
        return (T)this;
    }

    public <T extends JsonNode> T without(Collection<String> collection) {
        this._children.keySet().removeAll(collection);
        return (T)this;
    }

    @Deprecated
    public JsonNode put(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.put(string, jsonNode);
    }

    public JsonNode putIfAbsent(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._children.putIfAbsent(string, jsonNode);
    }

    public JsonNode remove(String string) {
        return this._children.remove(string);
    }

    public ObjectNode remove(Collection<String> collection) {
        this._children.keySet().removeAll(collection);
        return this;
    }

    @Override
    public ObjectNode removeAll() {
        this._children.clear();
        return this;
    }

    @Deprecated
    public JsonNode putAll(Map<String, ? extends JsonNode> map) {
        return this.setAll(map);
    }

    @Deprecated
    public JsonNode putAll(ObjectNode objectNode) {
        return this.setAll(objectNode);
    }

    public ObjectNode retain(Collection<String> collection) {
        this._children.keySet().retainAll(collection);
        return this;
    }

    public ObjectNode retain(String ... stringArray) {
        return this.retain(Arrays.asList(stringArray));
    }

    public ArrayNode putArray(String string) {
        ArrayNode arrayNode = this.arrayNode();
        this._put(string, arrayNode);
        return arrayNode;
    }

    public ObjectNode putObject(String string) {
        ObjectNode objectNode = this.objectNode();
        this._put(string, objectNode);
        return objectNode;
    }

    public ObjectNode putPOJO(String string, Object object) {
        return this._put(string, this.pojoNode(object));
    }

    public ObjectNode putRawValue(String string, RawValue rawValue) {
        return this._put(string, this.rawValueNode(rawValue));
    }

    public ObjectNode putNull(String string) {
        this._children.put(string, this.nullNode());
        return this;
    }

    public ObjectNode put(String string, short s2) {
        return this._put(string, this.numberNode(s2));
    }

    public ObjectNode put(String string, Short s2) {
        return this._put(string, s2 == null ? this.nullNode() : this.numberNode((short)s2));
    }

    public ObjectNode put(String string, int n2) {
        return this._put(string, this.numberNode(n2));
    }

    public ObjectNode put(String string, Integer n2) {
        return this._put(string, n2 == null ? this.nullNode() : this.numberNode((int)n2));
    }

    public ObjectNode put(String string, long l2) {
        return this._put(string, this.numberNode(l2));
    }

    public ObjectNode put(String string, Long l2) {
        return this._put(string, l2 == null ? this.nullNode() : this.numberNode((long)l2));
    }

    public ObjectNode put(String string, float f2) {
        return this._put(string, this.numberNode(f2));
    }

    public ObjectNode put(String string, Float f2) {
        return this._put(string, f2 == null ? this.nullNode() : this.numberNode(f2.floatValue()));
    }

    public ObjectNode put(String string, double d2) {
        return this._put(string, this.numberNode(d2));
    }

    public ObjectNode put(String string, Double d2) {
        return this._put(string, d2 == null ? this.nullNode() : this.numberNode((double)d2));
    }

    public ObjectNode put(String string, BigDecimal bigDecimal) {
        return this._put(string, bigDecimal == null ? this.nullNode() : this.numberNode(bigDecimal));
    }

    public ObjectNode put(String string, BigInteger bigInteger) {
        return this._put(string, bigInteger == null ? this.nullNode() : this.numberNode(bigInteger));
    }

    public ObjectNode put(String string, String string2) {
        return this._put(string, string2 == null ? this.nullNode() : this.textNode(string2));
    }

    public ObjectNode put(String string, boolean bl2) {
        return this._put(string, this.booleanNode(bl2));
    }

    public ObjectNode put(String string, Boolean bl2) {
        return this._put(string, bl2 == null ? this.nullNode() : this.booleanNode(bl2));
    }

    public ObjectNode put(String string, byte[] byArray) {
        return this._put(string, byArray == null ? this.nullNode() : this.binaryNode(byArray));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ObjectNode) {
            return this._childrenEqual((ObjectNode)object);
        }
        return false;
    }

    protected boolean _childrenEqual(ObjectNode objectNode) {
        return this._children.equals(objectNode._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    protected ObjectNode _put(String string, JsonNode jsonNode) {
        this._children.put(string, jsonNode);
        return this;
    }
}

