/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.InternalNodeMapper;

class NodeSerialization
implements Externalizable,
Serializable {
    protected static final int LONGEST_EAGER_ALLOC = 100000;
    private static final long serialVersionUID = 1L;
    public byte[] json;

    public NodeSerialization() {
    }

    public NodeSerialization(byte[] byArray) {
        this.json = byArray;
    }

    protected Object readResolve() {
        try {
            return InternalNodeMapper.bytesToNode(this.json);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to JDK deserialize `JsonNode` value: " + iOException.getMessage(), iOException);
        }
    }

    public static NodeSerialization from(Object object) {
        try {
            return new NodeSerialization(InternalNodeMapper.valueToBytes(object));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to JDK serialize `" + object.getClass().getSimpleName() + "` value: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.json.length);
        objectOutput.write(this.json);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        int n2 = objectInput.readInt();
        this.json = this._read(objectInput, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] _read(ObjectInput objectInput, int n2) throws IOException {
        if (n2 <= 100000) {
            byte[] byArray = new byte[n2];
            objectInput.readFully(byArray, 0, n2);
            return byArray;
        }
        try (ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(100000);){
            byte[] byArray = byteArrayBuilder.resetAndGetFirstSegment();
            int n3 = 0;
            while (true) {
                int n4 = Math.min(byArray.length - n3, n2);
                objectInput.readFully(byArray, 0, n4);
                n3 += n4;
                if ((n2 -= n4) == 0) {
                    byte[] byArray2 = byteArrayBuilder.completeAndCoalesce(n3);
                    return byArray2;
                }
                if (n3 != byArray.length) continue;
                byArray = byteArrayBuilder.finishCurrentSegment();
                n3 = 0;
                continue;
                break;
            }
        }
    }
}

