/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.AnnotationIntrospector;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedMethodMap;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.CollectorBase;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.MemberKey;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.TypeFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;

public class AnnotatedMethodCollector
extends CollectorBase {
    private final ClassIntrospector.MixInResolver _mixInResolver;
    private final boolean _collectAnnotations;

    AnnotatedMethodCollector(AnnotationIntrospector annotationIntrospector, ClassIntrospector.MixInResolver mixInResolver, boolean bl2) {
        super(annotationIntrospector);
        this._mixInResolver = annotationIntrospector == null ? null : mixInResolver;
        this._collectAnnotations = bl2;
    }

    public static AnnotatedMethodMap collectMethods(AnnotationIntrospector annotationIntrospector, TypeResolutionContext typeResolutionContext, ClassIntrospector.MixInResolver mixInResolver, TypeFactory typeFactory, JavaType javaType, List<JavaType> list, Class<?> clazz, boolean bl2) {
        return new AnnotatedMethodCollector(annotationIntrospector, mixInResolver, bl2).collect(typeFactory, typeResolutionContext, javaType, list, clazz);
    }

    AnnotatedMethodMap collect(TypeFactory typeFactory, TypeResolutionContext typeResolutionContext, JavaType javaType, List<JavaType> list, Class<?> clazz) {
        Object object;
        Class<?> clazz2;
        LinkedHashMap<MemberKey, MethodBuilder> linkedHashMap = new LinkedHashMap<MemberKey, MethodBuilder>();
        this._addMemberMethods(typeResolutionContext, javaType.getRawClass(), linkedHashMap, clazz);
        for (JavaType object22 : list) {
            Class<?> clazz3 = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(object22.getRawClass());
            this._addMemberMethods(new TypeResolutionContext.Basic(typeFactory, object22.getBindings()), object22.getRawClass(), linkedHashMap, clazz3);
        }
        boolean bl2 = false;
        if (this._mixInResolver != null && (clazz2 = this._mixInResolver.findMixInClassFor(Object.class)) != null) {
            this._addMethodMixIns(typeResolutionContext, javaType.getRawClass(), linkedHashMap, clazz2);
            bl2 = true;
        }
        if (bl2 && this._intr != null && !linkedHashMap.isEmpty()) {
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                MemberKey memberKey = (MemberKey)entry.getKey();
                if (!"hashCode".equals(memberKey.getName()) || 0 != memberKey.argCount()) continue;
                try {
                    object = Object.class.getDeclaredMethod(memberKey.getName(), new Class[0]);
                    if (object == null) continue;
                    MethodBuilder methodBuilder = (MethodBuilder)entry.getValue();
                    methodBuilder.annotations = this.collectDefaultAnnotations(methodBuilder.annotations, ((Method)object).getDeclaredAnnotations());
                    methodBuilder.method = object;
                }
                catch (Exception exception) {}
            }
        }
        if (linkedHashMap.isEmpty()) {
            return new AnnotatedMethodMap();
        }
        LinkedHashMap<MemberKey, AnnotatedMethod> linkedHashMap2 = new LinkedHashMap<MemberKey, AnnotatedMethod>(linkedHashMap.size());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object = ((MethodBuilder)entry.getValue()).build();
            if (object == null) continue;
            linkedHashMap2.put((MemberKey)entry.getKey(), (AnnotatedMethod)object);
        }
        return new AnnotatedMethodMap(linkedHashMap2);
    }

    private void _addMemberMethods(TypeResolutionContext typeResolutionContext, Class<?> clazz, Map<MemberKey, MethodBuilder> map, Class<?> clazz2) {
        if (clazz2 != null) {
            this._addMethodMixIns(typeResolutionContext, clazz, map, clazz2);
        }
        if (clazz == null) {
            return;
        }
        for (Method method : ClassUtil.getClassMethods(clazz)) {
            Object object;
            if (!AnnotatedMethodCollector._isIncludableMemberMethod(method)) continue;
            MemberKey memberKey = new MemberKey(method);
            MethodBuilder methodBuilder = map.get(memberKey);
            if (methodBuilder == null) {
                object = this._intr == null ? AnnotationCollector.emptyCollector() : this.collectAnnotations(method.getDeclaredAnnotations());
                map.put(memberKey, new MethodBuilder(typeResolutionContext, method, (AnnotationCollector)object));
                continue;
            }
            if (this._collectAnnotations) {
                methodBuilder.annotations = this.collectDefaultAnnotations(methodBuilder.annotations, method.getDeclaredAnnotations());
            }
            if ((object = methodBuilder.method) == null) {
                methodBuilder.method = method;
                continue;
            }
            if (!Modifier.isAbstract(((Method)object).getModifiers()) || Modifier.isAbstract(method.getModifiers())) continue;
            methodBuilder.method = method;
            methodBuilder.typeContext = typeResolutionContext;
        }
    }

    protected void _addMethodMixIns(TypeResolutionContext typeResolutionContext, Class<?> clazz, Map<MemberKey, MethodBuilder> map, Class<?> clazz2) {
        if (this._intr == null) {
            return;
        }
        for (Class<?> clazz3 : ClassUtil.findRawSuperTypes(clazz2, clazz, true)) {
            for (Method method : clazz3.getDeclaredMethods()) {
                if (!AnnotatedMethodCollector._isIncludableMemberMethod(method)) continue;
                MemberKey memberKey = new MemberKey(method);
                MethodBuilder methodBuilder = map.get(memberKey);
                Annotation[] annotationArray = method.getDeclaredAnnotations();
                if (methodBuilder == null) {
                    map.put(memberKey, new MethodBuilder(typeResolutionContext, null, this.collectAnnotations(annotationArray)));
                    continue;
                }
                methodBuilder.annotations = this.collectDefaultAnnotations(methodBuilder.annotations, annotationArray);
            }
        }
    }

    private static boolean _isIncludableMemberMethod(Method method) {
        if (Modifier.isStatic(method.getModifiers()) || method.isSynthetic() || method.isBridge()) {
            return false;
        }
        return method.getParameterCount() <= 2;
    }

    private static final class MethodBuilder {
        public TypeResolutionContext typeContext;
        public Method method;
        public AnnotationCollector annotations;

        public MethodBuilder(TypeResolutionContext typeResolutionContext, Method method, AnnotationCollector annotationCollector) {
            this.typeContext = typeResolutionContext;
            this.method = method;
            this.annotations = annotationCollector;
        }

        public AnnotatedMethod build() {
            if (this.method == null) {
                return null;
            }
            return new AnnotatedMethod(this.typeContext, this.method, this.annotations.asAnnotationMap(), null);
        }
    }
}

