/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg;

import java.io.Serializable;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.Serializers;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ArrayBuilders;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ArrayIterator;

public final class SerializerFactoryConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Serializers[] NO_SERIALIZERS = new Serializers[0];
    protected static final BeanSerializerModifier[] NO_MODIFIERS = new BeanSerializerModifier[0];
    protected final Serializers[] _additionalSerializers;
    protected final Serializers[] _additionalKeySerializers;
    protected final BeanSerializerModifier[] _modifiers;

    public SerializerFactoryConfig() {
        this(null, null, null);
    }

    protected SerializerFactoryConfig(Serializers[] serializersArray, Serializers[] serializersArray2, BeanSerializerModifier[] beanSerializerModifierArray) {
        this._additionalSerializers = serializersArray == null ? NO_SERIALIZERS : serializersArray;
        this._additionalKeySerializers = serializersArray2 == null ? NO_SERIALIZERS : serializersArray2;
        this._modifiers = beanSerializerModifierArray == null ? NO_MODIFIERS : beanSerializerModifierArray;
    }

    public SerializerFactoryConfig withAdditionalSerializers(Serializers serializers) {
        if (serializers == null) {
            throw new IllegalArgumentException("Cannot pass null Serializers");
        }
        Serializers[] serializersArray = ArrayBuilders.insertInListNoDup(this._additionalSerializers, serializers);
        return new SerializerFactoryConfig(serializersArray, this._additionalKeySerializers, this._modifiers);
    }

    public SerializerFactoryConfig withAdditionalKeySerializers(Serializers serializers) {
        if (serializers == null) {
            throw new IllegalArgumentException("Cannot pass null Serializers");
        }
        Serializers[] serializersArray = ArrayBuilders.insertInListNoDup(this._additionalKeySerializers, serializers);
        return new SerializerFactoryConfig(this._additionalSerializers, serializersArray, this._modifiers);
    }

    public SerializerFactoryConfig withSerializerModifier(BeanSerializerModifier beanSerializerModifier) {
        if (beanSerializerModifier == null) {
            throw new IllegalArgumentException("Cannot pass null modifier");
        }
        BeanSerializerModifier[] beanSerializerModifierArray = ArrayBuilders.insertInListNoDup(this._modifiers, beanSerializerModifier);
        return new SerializerFactoryConfig(this._additionalSerializers, this._additionalKeySerializers, beanSerializerModifierArray);
    }

    public boolean hasSerializers() {
        return this._additionalSerializers.length > 0;
    }

    public boolean hasKeySerializers() {
        return this._additionalKeySerializers.length > 0;
    }

    public boolean hasSerializerModifiers() {
        return this._modifiers.length > 0;
    }

    public Iterable<Serializers> serializers() {
        return new ArrayIterator<Serializers>(this._additionalSerializers);
    }

    public Iterable<Serializers> keySerializers() {
        return new ArrayIterator<Serializers>(this._additionalKeySerializers);
    }

    public Iterable<BeanSerializerModifier> serializerModifiers() {
        return new ArrayIterator<BeanSerializerModifier>(this._modifiers);
    }
}

