/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonInclude;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.AnnotationIntrospector;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.PropertyMetadata;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.PropertyName;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.MapperConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.TypeFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.Annotations;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.Named;

public interface BeanProperty
extends Named {
    public static final JsonFormat.Value EMPTY_FORMAT = new JsonFormat.Value();
    public static final JsonInclude.Value EMPTY_INCLUDE = JsonInclude.Value.empty();

    @Override
    public String getName();

    public PropertyName getFullName();

    public JavaType getType();

    public PropertyName getWrapperName();

    public PropertyMetadata getMetadata();

    public boolean isRequired();

    public boolean isVirtual();

    public <A extends Annotation> A getAnnotation(Class<A> var1);

    public <A extends Annotation> A getContextAnnotation(Class<A> var1);

    public AnnotatedMember getMember();

    @Deprecated
    public JsonFormat.Value findFormatOverrides(AnnotationIntrospector var1);

    public JsonFormat.Value findPropertyFormat(MapperConfig<?> var1, Class<?> var2);

    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> var1, Class<?> var2);

    public List<PropertyName> findAliases(MapperConfig<?> var1);

    public void depositSchemaProperty(JsonObjectFormatVisitor var1, SerializerProvider var2) throws JsonMappingException;

    public static class Bogus
    implements BeanProperty {
        @Override
        public String getName() {
            return "";
        }

        @Override
        public PropertyName getFullName() {
            return PropertyName.NO_NAME;
        }

        @Override
        public JavaType getType() {
            return TypeFactory.unknownType();
        }

        @Override
        public PropertyName getWrapperName() {
            return null;
        }

        @Override
        public PropertyMetadata getMetadata() {
            return PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public boolean isVirtual() {
            return false;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> clazz) {
            return null;
        }

        @Override
        public <A extends Annotation> A getContextAnnotation(Class<A> clazz) {
            return null;
        }

        @Override
        public AnnotatedMember getMember() {
            return null;
        }

        @Override
        @Deprecated
        public JsonFormat.Value findFormatOverrides(AnnotationIntrospector annotationIntrospector) {
            return JsonFormat.Value.empty();
        }

        @Override
        public JsonFormat.Value findPropertyFormat(MapperConfig<?> mapperConfig, Class<?> clazz) {
            return JsonFormat.Value.empty();
        }

        @Override
        public JsonInclude.Value findPropertyInclusion(MapperConfig<?> mapperConfig, Class<?> clazz) {
            return null;
        }

        @Override
        public List<PropertyName> findAliases(MapperConfig<?> mapperConfig) {
            return Collections.emptyList();
        }

        @Override
        public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) throws JsonMappingException {
        }
    }

    public static class Std
    implements BeanProperty,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final PropertyName _name;
        protected final JavaType _type;
        protected final PropertyName _wrapperName;
        protected final PropertyMetadata _metadata;
        protected final AnnotatedMember _member;

        public Std(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, AnnotatedMember annotatedMember, PropertyMetadata propertyMetadata) {
            this._name = propertyName;
            this._type = javaType;
            this._wrapperName = propertyName2;
            this._metadata = propertyMetadata;
            this._member = annotatedMember;
        }

        @Deprecated
        public Std(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, Annotations annotations, AnnotatedMember annotatedMember, PropertyMetadata propertyMetadata) {
            this(propertyName, javaType, propertyName2, annotatedMember, propertyMetadata);
        }

        public Std(Std std, JavaType javaType) {
            this(std._name, javaType, std._wrapperName, std._member, std._metadata);
        }

        public Std withType(JavaType javaType) {
            return new Std(this, javaType);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> clazz) {
            return this._member == null ? null : (A)this._member.getAnnotation(clazz);
        }

        @Override
        public <A extends Annotation> A getContextAnnotation(Class<A> clazz) {
            return null;
        }

        @Override
        @Deprecated
        public JsonFormat.Value findFormatOverrides(AnnotationIntrospector annotationIntrospector) {
            JsonFormat.Value value;
            if (this._member != null && annotationIntrospector != null && (value = annotationIntrospector.findFormat(this._member)) != null) {
                return value;
            }
            return EMPTY_FORMAT;
        }

        @Override
        public JsonFormat.Value findPropertyFormat(MapperConfig<?> mapperConfig, Class<?> clazz) {
            JsonFormat.Value value = mapperConfig.getDefaultPropertyFormat(clazz);
            AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
            if (annotationIntrospector == null || this._member == null) {
                return value;
            }
            JsonFormat.Value value2 = annotationIntrospector.findFormat(this._member);
            if (value2 == null) {
                return value;
            }
            return value.withOverrides(value2);
        }

        @Override
        public JsonInclude.Value findPropertyInclusion(MapperConfig<?> mapperConfig, Class<?> clazz) {
            JsonInclude.Value value = mapperConfig.getDefaultInclusion(clazz, this._type.getRawClass());
            AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
            if (annotationIntrospector == null || this._member == null) {
                return value;
            }
            JsonInclude.Value value2 = annotationIntrospector.findPropertyInclusion(this._member);
            if (value2 == null) {
                return value;
            }
            return value.withOverrides(value2);
        }

        @Override
        public List<PropertyName> findAliases(MapperConfig<?> mapperConfig) {
            return Collections.emptyList();
        }

        @Override
        public String getName() {
            return this._name.getSimpleName();
        }

        @Override
        public PropertyName getFullName() {
            return this._name;
        }

        @Override
        public JavaType getType() {
            return this._type;
        }

        @Override
        public PropertyName getWrapperName() {
            return this._wrapperName;
        }

        @Override
        public boolean isRequired() {
            return this._metadata.isRequired();
        }

        @Override
        public PropertyMetadata getMetadata() {
            return this._metadata;
        }

        @Override
        public AnnotatedMember getMember() {
            return this._member;
        }

        @Override
        public boolean isVirtual() {
            return false;
        }

        @Override
        public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) {
            throw new UnsupportedOperationException("Instances of " + this.getClass().getName() + " should not get visited");
        }
    }
}

