/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core;

import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.StreamReadFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.StreamWriteFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.InputDecorator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.OutputDecorator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.json.JsonReadFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.json.JsonWriteFeature;

public abstract class TSFBuilder<F extends JsonFactory, B extends TSFBuilder<F, B>> {
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = JsonFactory.Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    protected int _factoryFeatures;
    protected int _streamReadFeatures;
    protected int _streamWriteFeatures;
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;

    protected TSFBuilder() {
        this._factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
        this._streamReadFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
        this._streamWriteFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
        this._inputDecorator = null;
        this._outputDecorator = null;
    }

    protected TSFBuilder(JsonFactory jsonFactory) {
        this(jsonFactory._factoryFeatures, jsonFactory._parserFeatures, jsonFactory._generatorFeatures);
    }

    protected TSFBuilder(int n2, int n3, int n4) {
        this._factoryFeatures = n2;
        this._streamReadFeatures = n3;
        this._streamWriteFeatures = n4;
    }

    public int factoryFeaturesMask() {
        return this._factoryFeatures;
    }

    public int streamReadFeatures() {
        return this._streamReadFeatures;
    }

    public int streamWriteFeatures() {
        return this._streamWriteFeatures;
    }

    public InputDecorator inputDecorator() {
        return this._inputDecorator;
    }

    public OutputDecorator outputDecorator() {
        return this._outputDecorator;
    }

    public B enable(JsonFactory.Feature feature) {
        this._factoryFeatures |= feature.getMask();
        return this._this();
    }

    public B disable(JsonFactory.Feature feature) {
        this._factoryFeatures &= ~feature.getMask();
        return this._this();
    }

    public B configure(JsonFactory.Feature feature, boolean bl2) {
        return bl2 ? this.enable(feature) : this.disable(feature);
    }

    public B enable(StreamReadFeature streamReadFeature) {
        this._streamReadFeatures |= streamReadFeature.mappedFeature().getMask();
        return this._this();
    }

    public B enable(StreamReadFeature streamReadFeature, StreamReadFeature ... streamReadFeatureArray) {
        this._streamReadFeatures |= streamReadFeature.mappedFeature().getMask();
        for (StreamReadFeature streamReadFeature2 : streamReadFeatureArray) {
            this._streamReadFeatures |= streamReadFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B disable(StreamReadFeature streamReadFeature) {
        this._streamReadFeatures &= ~streamReadFeature.mappedFeature().getMask();
        return this._this();
    }

    public B disable(StreamReadFeature streamReadFeature, StreamReadFeature ... streamReadFeatureArray) {
        this._streamReadFeatures &= ~streamReadFeature.mappedFeature().getMask();
        for (StreamReadFeature streamReadFeature2 : streamReadFeatureArray) {
            this._streamReadFeatures &= ~streamReadFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B configure(StreamReadFeature streamReadFeature, boolean bl2) {
        return bl2 ? this.enable(streamReadFeature) : this.disable(streamReadFeature);
    }

    public B enable(StreamWriteFeature streamWriteFeature) {
        this._streamWriteFeatures |= streamWriteFeature.mappedFeature().getMask();
        return this._this();
    }

    public B enable(StreamWriteFeature streamWriteFeature, StreamWriteFeature ... streamWriteFeatureArray) {
        this._streamWriteFeatures |= streamWriteFeature.mappedFeature().getMask();
        for (StreamWriteFeature streamWriteFeature2 : streamWriteFeatureArray) {
            this._streamWriteFeatures |= streamWriteFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B disable(StreamWriteFeature streamWriteFeature) {
        this._streamWriteFeatures &= ~streamWriteFeature.mappedFeature().getMask();
        return this._this();
    }

    public B disable(StreamWriteFeature streamWriteFeature, StreamWriteFeature ... streamWriteFeatureArray) {
        this._streamWriteFeatures &= ~streamWriteFeature.mappedFeature().getMask();
        for (StreamWriteFeature streamWriteFeature2 : streamWriteFeatureArray) {
            this._streamWriteFeatures &= ~streamWriteFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B configure(StreamWriteFeature streamWriteFeature, boolean bl2) {
        return bl2 ? this.enable(streamWriteFeature) : this.disable(streamWriteFeature);
    }

    public B enable(JsonReadFeature jsonReadFeature) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B enable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B disable(JsonReadFeature jsonReadFeature) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B disable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B configure(JsonReadFeature jsonReadFeature, boolean bl2) {
        return this._failNonJSON(jsonReadFeature);
    }

    private B _failNonJSON(Object object) {
        throw new IllegalArgumentException("Feature " + object.getClass().getName() + "#" + object.toString() + " not supported for non-JSON backend");
    }

    public B enable(JsonWriteFeature jsonWriteFeature) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B enable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B disable(JsonWriteFeature jsonWriteFeature) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B disable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B configure(JsonWriteFeature jsonWriteFeature, boolean bl2) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B inputDecorator(InputDecorator inputDecorator) {
        this._inputDecorator = inputDecorator;
        return this._this();
    }

    public B outputDecorator(OutputDecorator outputDecorator) {
        this._outputDecorator = outputDecorator;
        return this._this();
    }

    public abstract F build();

    protected final B _this() {
        return (B)this;
    }

    protected void _legacyEnable(JsonParser.Feature feature) {
        if (feature != null) {
            this._streamReadFeatures |= feature.getMask();
        }
    }

    protected void _legacyDisable(JsonParser.Feature feature) {
        if (feature != null) {
            this._streamReadFeatures &= ~feature.getMask();
        }
    }

    protected void _legacyEnable(JsonGenerator.Feature feature) {
        if (feature != null) {
            this._streamWriteFeatures |= feature.getMask();
        }
    }

    protected void _legacyDisable(JsonGenerator.Feature feature) {
        if (feature != null) {
            this._streamWriteFeatures &= ~feature.getMask();
        }
    }
}

