/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink.columns;

import java.io.IOException;
import java.sql.SQLException;
import macromedia.jdbc.sequelink.columns.SequeLinkColumn;
import macromedia.jdbc.slbase.BaseColumn;
import macromedia.jdbc.slbase.BaseColumns;
import macromedia.jdbc.slbase.BaseData;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.sequelink.util.UnSyncVector;
import macromedia.sequelink.variables.CursorVariables;
import macromedia.slutil.UtilException;

public class SequeLinkColumns
extends BaseColumns
implements CursorVariables {
    private boolean containsLongColumns;
    private boolean containsNormalColumns;
    private UnSyncVector normalColumns;

    public void add(BaseColumn baseColumn) {
        SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)baseColumn;
        if (sequeLinkColumn.isLong()) {
            this.containsLongColumns = true;
        } else if (!sequeLinkColumn.isPseudo()) {
            this.containsNormalColumns = true;
        }
        super.add(baseColumn);
    }

    public boolean containsLongColumns() {
        return this.containsLongColumns;
    }

    public boolean containsNormalColumns() {
        return this.containsNormalColumns;
    }

    public UnSyncVector getNormalColumns() {
        if (this.normalColumns != null) {
            return this.normalColumns;
        }
        int n2 = this.count(0);
        this.normalColumns = new UnSyncVector();
        for (int i2 = 1; i2 <= n2; ++i2) {
            SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(i2);
            if (sequeLinkColumn.isLong() || sequeLinkColumn.isPseudo()) continue;
            this.normalColumns.addElement(sequeLinkColumn);
        }
        return this.normalColumns;
    }

    public void clearData() {
        int n2 = this.count(0);
        for (int i2 = 1; i2 <= n2; ++i2) {
            SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(i2);
            sequeLinkColumn.clearData();
        }
    }

    public void readNormalVariablesFromStream(SspInputStream sspInputStream) throws IOException, SQLException, UtilException {
        int n2 = this.count(0);
        for (int i2 = 1; i2 <= n2; ++i2) {
            SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(i2);
            if (sequeLinkColumn.isLong() || sequeLinkColumn.isPseudo()) continue;
            sequeLinkColumn.readObjectAndIndicatorFrom(sspInputStream);
        }
    }

    public BaseData getData(int n2, int n3, int n4, DiagnosticList diagnosticList) throws SQLException {
        SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(n2);
        return sequeLinkColumn.getData(n3, n4, diagnosticList);
    }

    public void cacheData(int n2, int n3, DiagnosticList diagnosticList) throws SQLException {
        SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(n2);
        sequeLinkColumn.cacheData(n3, diagnosticList);
    }

    public void clearCache() {
        int n2 = this.count(0);
        for (int i2 = 1; i2 <= n2; ++i2) {
            SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(i2);
            sequeLinkColumn.clearCache();
        }
    }

    public void cleanUp() {
        int n2 = this.count(0);
        for (int i2 = 1; i2 <= n2; ++i2) {
            SequeLinkColumn sequeLinkColumn = (SequeLinkColumn)this.get(i2);
            sequeLinkColumn.cleanUp();
        }
    }
}

