/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRFloatIncrementerFactory;

class JRFloatCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRFloatCountIncrementer mainInstance = new JRFloatCountIncrementer();

    private JRFloatCountIncrementer() {
    }

    public static JRFloatCountIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (expressionValue == null) {
            if (variable.isInitialized()) {
                return JRFloatIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRFloatIncrementerFactory.ZERO;
        }
        return new Float(value.floatValue() + 1.0f);
    }

    @Override
    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (value == null) {
            value = calculable.getValue() == null ? (Number)JRFloatIncrementerFactory.ZERO : (Number)((Number)calculable.getValue());
        }
        if (combineValue == null) {
            return value;
        }
        return new Float(value.floatValue() + combineValue.floatValue());
    }

    @Override
    public Object initialValue(JRCalculable variable) {
        if (variable.getValue() == null) {
            return JRFloatIncrementerFactory.ZERO;
        }
        return (Number)variable.getValue();
    }
}

