/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.lucene;

import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.ConfigMap;
import coldfusion.server.ConfigMapListener;
import coldfusion.server.SecurityService;
import coldfusion.server.Service;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SolrService;
import coldfusion.tagext.io.FileUtils;
import coldfusion.tagext.search.SolrUtils;
import coldfusion.util.FastHashtable;
import coldfusion.util.PasswordUtils;
import coldfusion.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SolrServiceImpl
extends ServiceBase
implements SolrService,
Observer {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private String solrhost;
    private int solrport;
    private String solrwebapp;
    private String solrhome;
    private int solrbuffersize = 40;
    private ConfigMap settings = null;
    private Vector<Map> languages = null;
    private String httpsenabled = "false";
    private int solrhttpsport;
    private String username = "";
    private String password = "";
    private String language;
    private String languagePrefix;
    private String seed;
    private File file;

    public SolrServiceImpl(File f) {
        this.file = f;
        this.setEnableWatch(true);
        this.setWatchFile(this.file);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        String[] split = language.split(",");
        if (split.length != 2) {
            return;
        }
        this.language = split[0];
        this.languagePrefix = split[1];
        this.removeLanguage(this.language);
        ConfigMap m = new ConfigMap();
        m.put("name", this.language);
        m.put("suffix", this.languagePrefix);
        this.languages = new Vector<Map>(this.languages);
        this.languages.add((Map)m);
        this.settings.put((Object)"languages", this.languages);
    }

    public String getLanguagePrefix() {
        return this.languagePrefix;
    }

    public void setLanguagePrefix(String languagePrefix) {
        this.languagePrefix = languagePrefix;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.settings.put((Object)USERNAME, (Object)username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pass) {
        this.password = this.encryptPassword(pass);
        this.settings.put((Object)PASSWORD, (Object)this.password);
    }

    private void setEncryptedPassword(String password) {
        this.password = password;
        this.settings.put((Object)PASSWORD, (Object)password);
    }

    public synchronized Map getSettings() {
        return this.settings;
    }

    public synchronized void setSolrHost(String hostname) {
        this.solrhost = hostname;
        this.settings.put((Object)"solrhost", (Object)this.solrhost);
    }

    public synchronized void setSolrPort(int port) {
        this.solrport = port;
        this.settings.put((Object)"solrport", (Object)this.solrport);
    }

    public synchronized void setSolrWebapp(String webapp) {
        this.solrwebapp = webapp;
        this.settings.put((Object)"solrwebapp", (Object)this.solrwebapp);
    }

    public synchronized void setSolrHome(String shome) {
        if (this.solrhost.equals("localhost") || this.solrhost.equals("127.0.0.1")) {
            File configpath;
            int correctfiles = 0;
            File file = new File(shome);
            if (file.exists() && file.isDirectory() && (configpath = new File(file + "/template/conf")).exists() && configpath.isDirectory()) {
                for (String innerfile : configpath.list()) {
                    if (!innerfile.equalsIgnoreCase("schema.xml") && !innerfile.equalsIgnoreCase("solrconfig.xml")) continue;
                    ++correctfiles;
                }
            }
            if (correctfiles != 2) {
                throw new InvalidJettyPathException(shome);
            }
        }
        this.solrhome = shome;
        this.settings.put((Object)"solrhome", (Object)this.solrhome);
        try {
            this.updateJettyLaxFile();
        }
        catch (Throwable t) {
            CFLogs.APPLICATION_LOG.error(t);
        }
    }

    private void updateJettyLaxFile() throws Exception {
        String laxFile = ServiceFactory.getRuntimeService().getRootDir() + "/jetty/jetty.lax";
        if (!new File(laxFile).exists()) {
            return;
        }
        String finalContent = "";
        try (BufferedReader br = new BufferedReader(new FileReader(laxFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.trim().startsWith("lax.nl.java.option.additional")) {
                    String[] splits = line.split(" ");
                    line = "";
                    for (String split : splits) {
                        if (split.startsWith("-Dsolr.solr.home")) {
                            split = "-Dsolr.solr.home=" + this.solrhome;
                        }
                        line = line + " " + split;
                    }
                }
                finalContent = finalContent + "\n" + line;
            }
        }
        Path path = Paths.get(laxFile, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(finalContent);
        }
    }

    public synchronized void setSolrBufferSize(int size) {
        this.solrbuffersize = size;
        this.settings.put((Object)"solrbuffersize", (Object)this.solrbuffersize);
    }

    public synchronized String getSolrHost() {
        return this.solrhost;
    }

    public synchronized int getSolrPort() {
        return this.solrport;
    }

    public synchronized String getSolrWebapp() {
        return this.solrwebapp;
    }

    public synchronized String getSolrHome() {
        return this.solrhome;
    }

    public synchronized SolrClient getSolrClient() {
        String solrurl = "http://" + this.solrhost + ":" + this.solrport + "/" + this.solrwebapp;
        return SolrUtils.getSolrClient(solrurl);
    }

    public synchronized Vector<Map> getLanguages() {
        return this.languages;
    }

    public synchronized int getSolrBufferSize() {
        return this.solrbuffersize;
    }

    public synchronized void setSolrhttpsport(int port) {
        this.solrhttpsport = port;
        this.settings.put((Object)"solrhttpsport", (Object)this.solrhttpsport);
    }

    public synchronized int getSolrhttpsport() {
        return this.solrhttpsport;
    }

    public Map getCollectionInfo(String name) throws IOException {
        FastHashtable out = new FastHashtable();
        String solrurl = "http://" + this.solrhost + ":" + this.solrport + "/" + this.solrwebapp;
        SolrClient client = SolrUtils.getSolrClient(solrurl);
        CoreAdminResponse res = null;
        try {
            res = CoreAdminRequest.Create.getStatus((String)name, (SolrClient)client);
        }
        catch (SolrServerException solrServerException) {
            // empty catch block
        }
        if (res != null) {
            NamedList status = res.getCoreStatus(name);
            String corename = (String)status.get("name");
            String directory = (String)status.get("instanceDir");
            SimpleOrderedMap o = (SimpleOrderedMap)status.get("index");
            String lastModified = "";
            if (o.get("lastModified") != null) {
                lastModified = o.get("lastModified").toString();
            }
            String doccount = Integer.toString((Integer)o.get("numDocs"));
            out.put((Object)"NAME", (Object)corename);
            out.put((Object)"PATH", (Object)directory);
            out.put((Object)"LANGUAGE", (Object)"");
            out.put((Object)"LASTMODIFIED", (Object)lastModified);
            out.put((Object)"DOCCOUNT", (Object)doccount);
            out.put((Object)"SIZE", (Object)Long.toString(coldfusion.tagext.search.Utils.getDirectorySize(new File(directory)) / 1024L));
        }
        return out;
    }

    public void registerCollection(String name, String path) {
        String solrurl = "http://" + this.solrhost + ":" + this.solrport + "/" + this.solrwebapp;
        SolrUtils.createSolrCore(solrurl, this.solrhome, name, path);
    }

    public void start() throws ServiceException {
        super.start();
        PasswordUtils.getInstance().addObserver((Observer)this);
        this.settings.setUnchanged();
        this.settings.setConfigMapListener((ConfigMapListener)this);
    }

    public void load() throws ServiceException {
        try {
            this.file = Utils.getCanonicalFile((File)this.file);
            this.settings = (ConfigMap)this.deserialize(this.file);
            ConfigMap settingsLocal = (ConfigMap)this.deserialize(this.file, true);
            this.settings.init((Service)this, "configuration");
            String value = (String)this.settings.get((Object)"solrhost");
            if (value != null) {
                this.setSolrHost(value);
            } else {
                this.settings.put((Object)"verityhost", (Object)this.solrhost);
            }
            Number port = (Number)this.settings.get((Object)"solrport");
            if (port != null) {
                this.solrport = port.intValue();
            } else {
                this.settings.put((Object)"solrport", (Object)new Integer(this.solrport));
            }
            Number httpsport = (Number)this.settings.get((Object)"solrhttpsport");
            if (httpsport != null) {
                this.solrhttpsport = httpsport.intValue();
            } else {
                this.settings.put((Object)"solrhttpsport", (Object)new Integer(this.solrhttpsport));
            }
            String un = (String)this.settings.get((Object)USERNAME);
            if (un != null) {
                this.username = un;
            } else {
                this.settings.put((Object)USERNAME, (Object)this.username);
            }
            String pass = (String)settingsLocal.get((Object)PASSWORD);
            if (pass != null) {
                this.password = pass;
            }
            this.settings.put((Object)PASSWORD, (Object)this.password, false);
            String httpsrequired = (String)this.settings.get((Object)"httpsenabled");
            if (httpsrequired != null) {
                this.httpsenabled = httpsrequired;
            } else {
                this.settings.put((Object)"httpsenabled", (Object)this.httpsenabled);
            }
            value = (String)this.settings.get((Object)"solrwebapp");
            if (value != null) {
                this.solrwebapp = value;
            } else {
                this.settings.put((Object)"solrwebapp", (Object)this.solrwebapp);
            }
            value = (String)settingsLocal.get((Object)"solrhome");
            if (value != null) {
                this.solrhome = value;
            }
            this.settings.put((Object)"solrhome", (Object)this.solrhome, false);
            Number lvalue = (Number)this.settings.get((Object)"solrbuffersize");
            if (lvalue != null) {
                this.solrbuffersize = lvalue.intValue();
            } else {
                this.settings.put((Object)"solrbuffersize", (Object)new Integer(this.solrbuffersize));
            }
            Vector lang_values = (Vector)this.settings.get((Object)"languages");
            if (lang_values != null) {
                this.languages = lang_values;
            }
        }
        catch (Exception ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    public void store() throws ServiceException {
        this.store(null, null, null, true);
    }

    public void store(boolean broadcast) throws ServiceException {
        this.store(null, null, null, broadcast);
    }

    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    public void store(Object key, Object value, Object oldValue, boolean broadcast) throws ServiceException {
        this.serialize(this.settings, this.file, broadcast, key, value, oldValue);
    }

    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("configuration.keys", "solrhost,solrport,solrhttpsport,solrwebapp,solrhome,solrbuffersize,username,password,languages,httpsenabled");
            this.rb.put("configuration.types", "java.lang.String,java.lang.Number,java.lang.Number,java.lang.String,java.lang.String,java.lang.Number,java.lang.String,java.lang.String,java.util.Map,java.lang.String");
            this.rb.put("configuration.formats", "coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.MapFormatter,coldfusion.server.StringFormatter");
        }
        return this.rb;
    }

    public String getHttpsenabled() {
        return this.httpsenabled;
    }

    public void setHttpsEnabled(String isHttpsEnabled) {
        this.httpsenabled = isHttpsEnabled;
        this.settings.put((Object)"httpsenabled", (Object)isHttpsEnabled);
    }

    public Map<String, String> getCredentials() {
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put(USERNAME, this.username);
        credentials.put(PASSWORD, this.password);
        return credentials;
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            SolrUtils.setSeed(this.seed);
            if (oldSeed == null) {
                return;
            }
            this.reEncryptPassword(oldSeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reEncryptPassword(String oldSeed) {
        if (oldSeed.equalsIgnoreCase(this.seed)) {
            return;
        }
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        String oldPassword = this.getPassword();
        if (oldPassword != null && oldPassword.length() > 0) {
            ConfigMap configMap = this.settings;
            synchronized (configMap) {
                try {
                    String newPassword = PasswordUtils.reEncryptWithNewSeed((String)oldPassword, (String)oldSeed, (String)this.seed);
                    this.setEncryptedPassword(newPassword);
                }
                catch (Exception e) {
                    CFLogs.SERVER_LOG.error((Throwable)e);
                }
            }
        }
    }

    private String encryptPassword(String p) {
        return PasswordUtils.encryptPassword((String)p, (String)this.seed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reEncryptPasswordForMigration(String password, String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        if (password != null) {
            ConfigMap configMap = this.settings;
            synchronized (configMap) {
                try {
                    password = PasswordUtils.reEncryptWithNewSeed((String)password, (String)oldSeed, (String)this.seed, (String)oldAlgoValue, (int)majorVersion, (int)minorVersion);
                    this.setEncryptedPassword(password);
                }
                catch (Exception e) {
                    CFLogs.SERVER_LOG.error((Throwable)e);
                }
            }
        }
    }

    public void removeLanguage(String languageName) {
        this.languages = new Vector<Map>(this.languages);
        Map toBeRemoved = null;
        for (int i = 0; i < this.languages.size(); ++i) {
            if (!languageName.equals((String)this.languages.get(i).get("name"))) continue;
            toBeRemoved = this.languages.get(i);
            break;
        }
        this.languages.remove(toBeRemoved);
        this.settings.put((Object)"languages", this.languages);
    }

    public void migrateCollections(String oldMulticorePath) {
        String newJettyPath = this.solrhome;
        String SOLRXML = "/solr.xml";
        String NAME = "name";
        String INSTANCEDIR = "instanceDir";
        String oldsolrxml = oldMulticorePath + SOLRXML;
        File newSchema = new File(newJettyPath + "/template/conf/schema.xml");
        if (!new File(oldsolrxml).exists()) {
            throw new InvalidOldMulticorePathException(oldsolrxml);
        }
        if (!newSchema.exists()) {
            throw new InvalidJettyPathException(newSchema.getAbsolutePath());
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document oldxmldom = null;
        DocumentBuilder db = null;
        Node newsolrcore = null;
        Document newxmldom = null;
        try {
            db = dbf.newDocumentBuilder();
            oldxmldom = db.parse(oldsolrxml);
            newxmldom = db.parse(newJettyPath + SOLRXML);
            newsolrcore = newxmldom.getElementsByTagName("cores").item(0);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
            throw new SolrMigrationException();
        }
        NodeList newcolslist = newxmldom.getElementsByTagName("core");
        HashSet<String> newcollections = new HashSet<String>();
        for (int pos = 0; pos < newcolslist.getLength(); ++pos) {
            Node node = newcolslist.item(pos);
            String collectionname = node.getAttributes().getNamedItem(NAME).getNodeValue();
            newcollections.add(collectionname);
        }
        Element docEle = oldxmldom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("core");
        for (int pos = 0; pos < nl.getLength(); ++pos) {
            Node node = nl.item(pos);
            String collectionPath = node.getAttributes().getNamedItem(INSTANCEDIR).getNodeValue();
            String nodename = node.getAttributes().getNamedItem(NAME).getNodeValue();
            if (newcollections.contains(nodename) || !new File(collectionPath).exists()) continue;
            try {
                FileUtils.copyFile((File)newSchema, (String)(collectionPath + "/conf/schema.xml"));
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error((Throwable)e);
            }
            Element child = newxmldom.createElement("core");
            child.setAttribute(NAME, nodename);
            child.setAttribute(INSTANCEDIR, collectionPath);
            newsolrcore.appendChild(child);
        }
        this.storeDom(newJettyPath + SOLRXML, newxmldom);
    }

    private void storeDom(String outpath, Node node) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamResult result = new StreamResult(new File(outpath));
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
            throw new SolrMigrationException();
        }
    }

    public boolean isSolrServiceInstance(Object obj) {
        return obj != null && obj instanceof SolrServiceImpl;
    }

    public static class SolrMigrationException
    extends ApplicationException {
    }

    public static class InvalidJettyPathException
    extends ApplicationException {
        public String file;

        public InvalidJettyPathException(String file) {
            this.file = file;
        }
    }

    public static class InvalidOldMulticorePathException
    extends ApplicationException {
        public String file;

        public InvalidOldMulticorePathException(String file) {
            this.file = file;
        }
    }
}

