/*
 * Decompiled with CFR 0.152.
 */
package ice.util.alg;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.IThread;

public class ThreadVar {
    private static final ThreadVar prototype = ThreadVar.newMaster();
    private HashArray threadToValue;

    protected ThreadVar() {
    }

    private static ThreadVar newMaster() {
        ThreadVar x = null;
        String className = Defs.sysProperty("ice.util.alg.ThreadVar");
        if (className != null) {
            x = (ThreadVar)Defs.newClassInstance(className);
        }
        if (x == null) {
            className = "ice.util.alg.jdk12.ThreadVar_jdk12";
            x = (ThreadVar)Defs.newClassInstance(className);
        }
        if (Debug.trace) {
            Debug.trace(x != null ? className : "JDK 1.1 compatible");
        }
        return x;
    }

    public static ThreadVar create() {
        if (prototype != null) {
            return prototype.newInstance();
        }
        ThreadVar tv = new ThreadVar();
        tv.threadToValue = new HashArray();
        return tv;
    }

    public Object get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof IThread) {
            return ((IThread)thread).locals.get(this);
        }
        return this.threadToValue.get(thread);
    }

    public Object push(Object new_value) {
        Thread thread = Thread.currentThread();
        Object old_value = thread instanceof IThread ? ((IThread)thread).locals.put(this, new_value) : (new_value == null ? this.threadToValue.remove(thread) : this.threadToValue.put(thread, new_value));
        return old_value;
    }

    public void restore(Object old_value) {
        Thread thread = Thread.currentThread();
        if (thread instanceof IThread) {
            ((IThread)thread).locals.put(this, old_value);
        } else if (old_value == null) {
            this.threadToValue.remove(thread);
        } else {
            this.threadToValue.put(thread, old_value);
        }
    }

    protected ThreadVar newInstance() {
        return null;
    }
}

