/*
 * Decompiled with CFR 0.152.
 */
package ice.util.alg;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.alg.Comparator;
import ice.util.alg.SysComparator;

public class HashArray {
    private static final boolean check = true;
    private static final int MINIMAL_ALLOCATION_SIZE = 8;
    private static final int A = -1640531527;
    private static final Entry DELETED = new Entry();
    private Entry[] entries_array;
    private int key_count;
    private int occupied_count;
    private Object monitor_lock;
    private Entry entryPrototype = DELETED;
    private Entry lastNamedAccess = DELETED;
    private Comparator comparator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Object lock = this.monitor_lock;
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                HashArray h = new HashArray();
                h.comparator = this.comparator;
                h.entries_array = new Entry[this.entries_array.length];
                h.key_count = this.key_count;
                h.occupied_count = this.occupied_count;
                for (int i = 0; i < this.entries_array.length; ++i) {
                    if (this.entries_array[i] == DELETED) {
                        h.entries_array[i] = DELETED;
                        continue;
                    }
                    Entry oldEntry = this.entries_array[i];
                    if (oldEntry == null) continue;
                    Entry newEntry = new Entry();
                    newEntry.initKey(oldEntry.key(), oldEntry.keyHash());
                    newEntry.value = oldEntry.value;
                    h.entries_array[i] = newEntry;
                }
                return h;
            }
        }
        HashArray h = new HashArray();
        h.comparator = this.comparator;
        h.entries_array = new Entry[this.entries_array.length];
        h.key_count = this.key_count;
        h.occupied_count = this.occupied_count;
        for (int i = 0; i < this.entries_array.length; ++i) {
            if (this.entries_array[i] == DELETED) {
                h.entries_array[i] = DELETED;
                continue;
            }
            Entry oldEntry = this.entries_array[i];
            Entry newEntry = new Entry();
            newEntry.initKey(oldEntry.key(), oldEntry.keyHash());
            newEntry.value = oldEntry.value;
            h.entries_array[i] = newEntry;
        }
        return h;
    }

    public HashArray() {
        this(0);
    }

    public HashArray(Object lock) {
        this(lock, 0);
    }

    public HashArray(int initialCapacity) {
        this.monitor_lock = this;
        this.setupInitialCapacity(initialCapacity);
    }

    public HashArray(Object lock, int initialCapacity) {
        this.monitor_lock = lock;
        this.setupInitialCapacity(initialCapacity);
    }

    final Entry[] access_entries_array() {
        return this.entries_array;
    }

    private void setupInitialCapacity(int initialCapacity) {
        if (initialCapacity != 0) {
            this.entries_array = new Entry[1 << HashArray.log_2(initialCapacity) + 1];
        }
    }

    public void setEntryPrototype(Entry entryPrototype) {
        if (this.key_count != 0) {
            Debug.bug();
        }
        this.entryPrototype = entryPrototype;
    }

    public void setComparator(Comparator comparator) {
        if (this.key_count != 0) {
            Debug.bug();
        }
        this.comparator = comparator;
    }

    public final Object synchronizationLock() {
        return this.monitor_lock;
    }

    public Object setSynchronizationLock(Object new_lock) {
        if (this.key_count != 0) {
            Debug.bug();
        }
        this.monitor_lock = new_lock;
        return this.monitor_lock;
    }

    public boolean isEmpty() {
        return this.key_count == 0;
    }

    public int size() {
        return this.key_count;
    }

    public final boolean isSealed() {
        return this.occupied_count < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sealObject() {
        Object lock = this.monitor_lock;
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                this.occupied_count = -1;
            }
        } else {
            this.occupied_count = -1;
        }
    }

    public Entry getEntry(Object key) {
        Entry entry = this.lastNamedAccess;
        if ((entry.key != key || entry.wasDeleted) && (entry = this.getEntry(this.getHashCode(key), key, false)) != null) {
            entry.key = key;
            this.lastNamedAccess = entry;
        }
        return entry;
    }

    public Entry getEntry(int index) {
        return this.getEntry(index, null, false);
    }

    public final boolean has(Object key) {
        return null != this.getEntry(key);
    }

    public final boolean has(int index) {
        return null != this.getEntry(index);
    }

    public final Object get(Object key) {
        Entry entry = this.getEntry(key);
        return entry != null ? entry.value : null;
    }

    public final Object get(int index) {
        Entry entry = this.getEntry(index);
        return entry != null ? entry.value : null;
    }

    public Entry ensureEntry(Object key) {
        Entry entry;
        this.lastNamedAccess = entry = this.ensureEntry(this.getHashCode(key), key);
        return entry;
    }

    public Entry ensureEntry(int index) {
        return this.ensureEntry(index, null);
    }

    public final Object put(Object key, Object value) {
        Entry entry = this.ensureEntry(key);
        Object old_value = entry.value;
        entry.value = value;
        return old_value;
    }

    public final Object put(int index, Object value) {
        Entry entry = this.ensureEntry(index);
        Object old_value = entry.value;
        entry.value = value;
        return old_value;
    }

    public final void setValue(Object key, Object value) {
        if (this.isSealed()) {
            Debug.bug();
        }
        Entry entry = this.lastNamedAccess;
        if (entry.key != key || entry.wasDeleted) {
            int hash = this.getHashCode(key);
            entry = this.getEntry(hash, key, false);
            if (entry == null) {
                entry = this.ensureEntry(hash, key);
            }
            entry.key = key;
            this.lastNamedAccess = entry;
        }
        entry.value = value;
    }

    public final void setValue(int index, Object value) {
        Entry entry;
        if (this.isSealed()) {
            Debug.bug();
        }
        if ((entry = this.getEntry(index)) == null) {
            entry = this.ensureEntry(index);
        }
        entry.value = value;
    }

    public Object remove(Object key) {
        return this.deleteEntry(this.getHashCode(key), key);
    }

    public Object remove(int index) {
        return this.deleteEntry(index, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object lock;
        if (this.isSealed()) {
            Debug.bug();
        }
        if ((lock = this.monitor_lock) != null) {
            Object object = lock;
            synchronized (object) {
                this.do_removeAllValues();
            }
        } else {
            this.do_removeAllValues();
        }
        this.lastNamedAccess = DELETED;
    }

    private void do_removeAllValues() {
        this.entries_array = null;
        this.key_count = 0;
        this.occupied_count = 0;
    }

    public Iterator newIterator() {
        return new Iterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getEntries() {
        Object lock = this.monitor_lock;
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                return this.do_getEntries();
            }
        }
        return this.do_getEntries();
    }

    private Entry[] do_getEntries() {
        int n = this.key_count;
        Entry[] result = new Entry[n];
        Entry[] array = this.entries_array;
        int i = 0;
        while (n != 0) {
            Entry entry = array[i];
            if (entry != null && entry != DELETED) {
                result[--n] = entry;
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getObjectKeys(Object[] result, int offset) {
        Object lock = this.monitor_lock;
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                this.copyKeysOrValues(true, result, offset);
            }
        } else {
            this.copyKeysOrValues(true, result, offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getValues() {
        Object[] result;
        Object lock = this.monitor_lock;
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                if (this.key_count == 0) {
                    result = Defs.EMPTY_OBJECT_ARRAY;
                } else {
                    result = new Object[this.key_count];
                    this.copyKeysOrValues(false, result, 0);
                }
            }
        } else if (this.key_count == 0) {
            result = Defs.EMPTY_OBJECT_ARRAY;
        } else {
            result = new Object[this.key_count];
            this.copyKeysOrValues(false, result, 0);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(Object[] result, int offset) {
        Object lock = this.monitor_lock;
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                this.copyKeysOrValues(false, result, offset);
            }
        } else {
            this.copyKeysOrValues(false, result, offset);
        }
    }

    private void copyKeysOrValues(boolean copyKeys, Object[] result, int offset) {
        int n = this.key_count;
        Entry[] array = this.entries_array;
        int i = 0;
        while (n != 0) {
            Entry entry = array[i];
            if (entry != null && entry != DELETED) {
                if (copyKeys) {
                    if (entry.key != null) {
                        result[offset] = entry.key;
                        ++offset;
                    }
                } else {
                    result[offset] = entry.value;
                    ++offset;
                }
                --n;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deleteEntry(int hash, Object key) {
        Object lock;
        if (this.isSealed()) {
            Debug.bug();
        }
        if ((lock = this.monitor_lock) != null) {
            Object object = lock;
            synchronized (object) {
                return this.do_deleteEntry(hash, key);
            }
        }
        return this.do_deleteEntry(hash, key);
    }

    private Object do_deleteEntry(int hash, Object key) {
        Object result = null;
        Entry deleted = this.getEntry(hash, key, true);
        if (null != deleted) {
            result = deleted.value;
            deleted.value = null;
        }
        return result;
    }

    private static int log_2_for_exact_power(int N) {
        switch (N) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 64: {
                return 6;
            }
            case 128: {
                return 7;
            }
            case 256: {
                return 8;
            }
            case 512: {
                return 9;
            }
            case 1024: {
                return 10;
            }
            case 2048: {
                return 11;
            }
            case 4096: {
                return 12;
            }
            case 8192: {
                return 13;
            }
            case 16384: {
                return 14;
            }
            case 32768: {
                return 15;
            }
            case 65536: {
                return 16;
            }
            case 131072: {
                return 17;
            }
            case 262144: {
                return 18;
            }
            case 524288: {
                return 19;
            }
            case 0x100000: {
                return 20;
            }
            case 0x200000: {
                return 21;
            }
            case 0x400000: {
                return 22;
            }
            case 0x800000: {
                return 23;
            }
            case 0x1000000: {
                return 24;
            }
            case 0x2000000: {
                return 25;
            }
            case 0x4000000: {
                return 26;
            }
            case 0x8000000: {
                return 27;
            }
            case 0x10000000: {
                return 28;
            }
            case 0x20000000: {
                return 29;
            }
            case 0x40000000: {
                return 30;
            }
            case -2147483648: {
                return 31;
            }
        }
        Debug.bug();
        return 0;
    }

    private static int log_2(int N) {
        int x;
        int log = 0;
        if (N >> 4 != 0) {
            x = N >> 16;
            if (x != 0) {
                log |= 0x10;
                N = x;
            }
            if ((x = N >> 8) != 0) {
                log |= 8;
                N = x;
            }
            if ((x = N >> 4) != 0) {
                log |= 4;
                N = x;
            }
        }
        if ((x = N >> 2) != 0) {
            log |= 2;
            N = x;
        }
        if ((N & 2) != 0) {
            log |= 1;
        }
        return log;
    }

    private static int tableLookupStep(int fraction, int mask, int power) {
        int shift = 32 - 2 * power;
        int step = shift >= 0 ? fraction >>> shift & mask | 1 : fraction & mask >>> -shift | 1;
        return step;
    }

    private Entry getEntry(int hash, Object key, boolean shouldDelete) {
        int N;
        int power;
        int fraction;
        int index;
        Entry entry;
        Entry[] array = this.entries_array;
        if (array != null && (entry = array[index = (fraction = hash * -1640531527) >>> 32 - (power = HashArray.log_2_for_exact_power(N = array.length))]) != null) {
            boolean found = false;
            if (entry != DELETED && entry.hash == hash && (key == null || key == entry.key || this.cmp(key, entry.key))) {
                found = true;
            }
            if (!found) {
                int mask = N - 1;
                int step = HashArray.tableLookupStep(fraction, mask, power);
                while ((entry = array[index = index + step & mask]) != null) {
                    if (entry == DELETED || entry.hash != hash || key != null && key != entry.key && !this.cmp(key, entry.key)) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                if (shouldDelete) {
                    array[index] = DELETED;
                    --this.key_count;
                    entry.wasDeleted = true;
                }
                return entry;
            }
        }
        return null;
    }

    private static int getNewEntryIndex(Entry[] array, int power, int hash, Object key) {
        int index;
        block2: {
            int fraction;
            Entry entry;
            int N = array.length;
            if (N != 1 << power) {
                Debug.bug();
            }
            if ((entry = array[index = (fraction = hash * -1640531527) >>> 32 - power]) == null) break block2;
            int mask = N - 1;
            int step = HashArray.tableLookupStep(fraction, mask, power);
            do {
                if (entry != DELETED) continue;
                Debug.bug();
            } while ((entry = array[index = index + step & mask]) != null);
        }
        return index;
    }

    private static Entry[] rehashTable(int new_capacity, int new_power, Entry[] array, int present_count) {
        Entry[] new_entries = new Entry[new_capacity];
        if (array != null) {
            int i = 0;
            int remaining = present_count;
            while (remaining != 0) {
                Entry entry = array[i];
                if (entry != null && entry != DELETED) {
                    int index = HashArray.getNewEntryIndex(new_entries, new_power, entry.hash, entry.key);
                    new_entries[index] = entry;
                    --remaining;
                }
                ++i;
            }
        }
        return new_entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry ensureEntry(int hash, Object key) {
        Entry entry;
        Object lock;
        if (this.isSealed()) {
            Debug.bug();
        }
        if ((lock = this.monitor_lock) != null) {
            Object object = lock;
            synchronized (object) {
                entry = this.do_ensureEntry(hash, key);
            }
        } else {
            entry = this.do_ensureEntry(hash, key);
        }
        return entry;
    }

    private Entry do_ensureEntry(int hash, Object key) {
        Entry[] array = this.entries_array;
        int N = array != null ? array.length : 0;
        int new_entry_pos = -1;
        boolean replace_deleted = false;
        if (N != 0) {
            int fraction = hash * -1640531527;
            int power = HashArray.log_2_for_exact_power(N);
            int index = fraction >>> 32 - power;
            Entry entry = array[index];
            if (entry == null) {
                new_entry_pos = index;
            } else {
                if (entry != DELETED) {
                    if (entry.hash == hash && (key == null || key == entry.key || this.cmp(key, entry.key))) {
                        return entry;
                    }
                } else {
                    new_entry_pos = index;
                    replace_deleted = true;
                }
                int mask = N - 1;
                int step = HashArray.tableLookupStep(fraction, mask, power);
                while (true) {
                    if ((entry = array[index = index + step & mask]) == null) {
                        if (new_entry_pos >= 0) break;
                        new_entry_pos = index;
                        break;
                    }
                    if (entry != DELETED) {
                        if (entry.hash != hash || key != null && key != entry.key && !this.cmp(key, entry.key)) continue;
                        return entry;
                    }
                    if (new_entry_pos >= 0) continue;
                    new_entry_pos = index;
                    replace_deleted = true;
                }
            }
        }
        if (!replace_deleted) {
            if (this.occupied_count * 4 >= N * 3) {
                int new_capacity = this.key_count * 2 < this.occupied_count ? N : (N == 0 ? 8 : N * 2);
                int power = HashArray.log_2_for_exact_power(new_capacity);
                array = HashArray.rehashTable(new_capacity, power, array, this.key_count);
                this.entries_array = array;
                this.occupied_count = this.key_count;
                new_entry_pos = HashArray.getNewEntryIndex(array, power, hash, key);
            }
            ++this.occupied_count;
        }
        Entry result = this.entryPrototype.newEntry();
        result.initKey(key, hash);
        array[new_entry_pos] = result;
        ++this.key_count;
        return result;
    }

    private boolean cmp(Object a, Object b) {
        Comparator c = this.comparator;
        return c == null ? a.equals(b) : (c == SysComparator.instance ? a == b : c.equals(a, b));
    }

    private int getHashCode(Object key) {
        Comparator c = this.comparator;
        return c == null ? key.hashCode() : c.hashCode(key);
    }

    public static class Iterator {
        HashArray _master;
        private int _cursor;
        private Entry[] _entries;

        Iterator(HashArray master) {
            this._master = master;
            this._cursor = -1;
        }

        void init(Object[] entries) {
        }

        public void start() {
            this._entries = this._master.access_entries_array();
            this._cursor = this._entries == null ? 0 : this._entries.length;
            this.next();
        }

        public boolean done() {
            return this._cursor < 0;
        }

        public void next() {
            Entry entry;
            if (this._cursor < 0) {
                Debug.bug();
            }
            --this._cursor;
            while (this._cursor >= 0 && ((entry = this._entries[this._cursor]) == null || entry == DELETED)) {
                --this._cursor;
            }
        }

        public Entry entry() {
            return this._entries[this._cursor];
        }

        public Object value() {
            return this._entries[this._cursor].value;
        }
    }

    public static class Entry {
        boolean wasDeleted;
        int hash;
        Object key;
        public volatile Object value;

        final void initKey(Object key, int hash) {
            this.hash = hash;
            this.key = key;
        }

        public final boolean isIndex() {
            return this.key == null;
        }

        public final boolean isKey() {
            return this.key != null;
        }

        public final Object key() {
            return this.key;
        }

        public final int keyHash() {
            return this.hash;
        }

        public final int index() {
            return this.hash;
        }

        protected Entry newEntry() {
            return new Entry();
        }
    }
}

