/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.debug.Debug;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.ICEDropClient;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.ScrollHandler;
import ice.pilots.html4.awt.DocPanel;
import ice.pilots.html4.awt.EmbeddedObjectContainer;
import ice.pilots.html4.awt.FormInputButton;
import ice.pilots.html4.awt.FormInputCheckbox;
import ice.pilots.html4.awt.FormInputText;
import ice.pilots.html4.awt.FormInputUpload;
import ice.pilots.html4.awt.FormSelectChoice;
import ice.pilots.html4.awt.FormSelectList;
import ice.pilots.html4.awt.FormTextArea;
import ice.pilots.html4.awt.PanePanel;
import ice.pilots.html4.awt.Scroller;
import ice.pilots.html4.awt.TheFactory;
import ice.storm.ViewportLayoutManager;
import ice.util.Defs;
import ice.util.alg.HashArray;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.w3c.dom.events.EventListener;

final class DocView
extends DocPaneXml
implements AdjustmentListener {
    TheFactory factory;
    PanePanel _panePanel;
    Scrollbar vbar;
    Scrollbar hbar;
    DocPanel docPanel;
    private boolean cursorChange = true;
    long repaintTimeout;
    private ScrollHandler scrollHandler;
    private boolean _doAutoRepaint = true;
    private boolean scrollbarEast = true;
    private final HashArray cgs = new HashArray();
    private final HashArray cgs_none = new HashArray();
    int validateTreeNesting = 0;
    private boolean isMousePressPopupTrigger = false;

    DocView(TheFactory factory) {
        this.factory = factory;
    }

    protected void init(int scrollbars) {
        boolean drawScrollbars;
        this._panePanel = new PanePanel(this);
        this._panePanel.setLayout(new BorderLayout());
        this.docPanel = new DocPanel(this);
        this.repaintTimeout = Defs.sysPropertyInt("ice.pilots.html4.awt.repaintTimeout", 200);
        boolean bl = drawScrollbars = !Defs.sysPropertyBoolean("ice.browser.pjava");
        if (drawScrollbars) {
            drawScrollbars = Defs.sysPropertyBoolean("ice.pilots.html4.scrollbars", true);
        }
        boolean bl2 = this.cursorChange = !Defs.sysPropertyBoolean("ice.pilots.html4.cssCursor");
        if (drawScrollbars && scrollbars != 2) {
            this.vbar = new Scrollbar(1);
            this.hbar = new Scrollbar(0);
        }
        this._panePanel.add((Component)this.docPanel, "Center");
        if (this.vbar != null) {
            this._panePanel.add((Component)this.vbar, "East");
            this._panePanel.add((Component)this.hbar, "South");
            this.vbar.addAdjustmentListener(this);
            this.hbar.addAdjustmentListener(this);
            this.initMouseWheelSupport();
        }
    }

    private void initMouseWheelSupport() {
        block7: {
            try {
                Class<?> mouseWheelEvent = Class.forName("java.awt.event.MouseWheelEvent");
                try {
                    String className = "ice.util.awt.jdk14.AWTMouseWheelListener";
                    Constructor<?> constr = Class.forName(className).getConstructors()[0];
                    Object[] args = new Object[]{this.vbar, this.hbar};
                    java.util.EventListener aListener = null;
                    aListener = (java.util.EventListener)constr.newInstance(args);
                    this.addMouseWheelListenerReflectively(aListener, this.docPanel);
                    this.addMouseWheelListenerReflectively(aListener, this.vbar);
                    this.addMouseWheelListenerReflectively(aListener, this.hbar);
                    if (Debug.trace) {
                        Debug.trace("MouseWheel support found and configured.");
                    }
                }
                catch (Throwable t1) {
                    if (Debug.trace) {
                        Debug.trace("MouseWheel support found, but error occurred during configuration.");
                    }
                    if (Debug.ex) {
                        Debug.ex(t1);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (!Debug.trace) break block7;
                Debug.trace("MouseWheel support not found.");
            }
        }
    }

    private void addMouseWheelListenerReflectively(Object listener, Object target) throws Throwable {
        Class<?> targetClass = target.getClass();
        Class[] classArgs = new Class[]{Class.forName("java.awt.event.MouseWheelListener")};
        Method addListenerMethod = targetClass.getMethod("addMouseWheelListener", classArgs);
        addListenerMethod.invoke(target, listener);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.docPanel.scroll(this.hbar.getValue(), this.vbar.getValue());
    }

    public void updateScrollbars(boolean isRTL) {
        if (this.vbar == null) {
            return;
        }
        if (isRTL) {
            if (this.scrollbarEast) {
                this._panePanel.remove(this.vbar);
                this._panePanel.add((Component)this.vbar, "West");
                this.scrollbarEast = false;
            }
        } else if (!this.scrollbarEast) {
            this._panePanel.remove(this.vbar);
            this._panePanel.add((Component)this.vbar, "East");
            this.scrollbarEast = true;
        }
    }

    public int getScrollX() {
        return this.docPanel.getScrollX();
    }

    public int getScrollY() {
        return this.docPanel.getScrollY();
    }

    public int getPaneWidth() {
        return this.docPanel.getSize().width;
    }

    public int getPaneHeight() {
        return this.docPanel.getSize().height;
    }

    public void setScrollPosition(int x, int y) {
        if (this.vbar != null) {
            this.hbar.setValue(this.getScrollX(x));
            this.vbar.setValue(this.getScrollY(y));
            this.docPanel.scroll(this.hbar.getValue(), this.vbar.getValue());
        } else {
            this.docPanel.scroll(this.getScrollX(x), this.getScrollY(y));
        }
    }

    public void setPaneBounds(int x, int y, int w, int h) {
        this._panePanel.setBounds(x, y, w, h);
    }

    public void revalidate() {
        this.cgs.clear();
        this.cgs_none.clear();
        this.getPilot().getStorm().runOnEventThreadLater(new Runnable(){

            public void run() {
                DocView.this.do_revalidate();
            }
        }, 0L);
    }

    void do_revalidate() {
        this.docPanel.invalidate();
        if (this._panePanel.getParent() != null) {
            this._panePanel.validate();
            this.docPanel.repaint();
        }
    }

    public void reqRepaint() {
        this.docPanel.repaint();
    }

    public void reqRepaint(int x, int y, int w, int h) {
        y -= this.getScrollY();
        if ((x -= this.getScrollX()) < 0) {
            if (x + w <= 0) {
                return;
            }
            w += x;
            x = 0;
        }
        if (y < 0) {
            if (y + h <= 0) {
                return;
            }
            h += y;
            y = 0;
        }
        int visibleWidth = this.getPaneWidth();
        int visibleHeight = this.getPaneHeight();
        if (x >= visibleWidth || y >= visibleHeight) {
            return;
        }
        if (x + w > visibleWidth) {
            w = visibleWidth - x;
        }
        if (y + h > visibleHeight) {
            h = visibleHeight - y;
        }
        if (w > 0 && h > 0) {
            this.docPanel.preventOptimisedPaintOnce = true;
            this.docPanel.repaint(x, y, w, h);
        }
    }

    public void setDropClient(ICEDropClient client) {
    }

    public Color getSelectionColor() {
        return SystemColor.textHighlightText;
    }

    public Color getSelectionBackground() {
        return SystemColor.textHighlight;
    }

    public void reqClear() {
        this.docPanel.removeAll();
        this.docPanel.setScrollPosition(0, 0);
        this.docPanel.nsy = 0;
        this.docPanel.nsx = 0;
        if (this.vbar != null) {
            this.vbar.setValue(0);
            this.hbar.setValue(0);
        }
    }

    public void setAutoRepaint(boolean flag) {
        this._doAutoRepaint = flag;
    }

    public boolean doesAutoRepaint() {
        return this._doAutoRepaint;
    }

    public void setCursor(int type) {
        Cursor c;
        if (this.cursorChange && (c = Cursor.getPredefinedCursor(type)) != null && c != this.docPanel.getCursor()) {
            this.docPanel.setCursor(c);
        }
    }

    public Image createImage(int w, int h) {
        return this._panePanel.createImage(w, h);
    }

    protected Component getPaneComponent() {
        return this._panePanel;
    }

    protected ObjectPainter createFormControl(DElement e) {
        Component c = null;
        String tagName = e.getLocalName();
        if (tagName.equalsIgnoreCase("input")) {
            String t = e.getAttribute("type");
            if (t == null || t.equalsIgnoreCase("text")) {
                c = new FormInputText(this, e);
            } else if (t.equalsIgnoreCase("password")) {
                c = new FormInputText(this, e);
                ((TextField)c).setEchoChar('*');
            } else if (t.equalsIgnoreCase("button")) {
                c = new FormInputButton(this, e, "button");
            } else if (t.equalsIgnoreCase("submit")) {
                c = new FormInputButton(this, e, "submit");
            } else if (t.equalsIgnoreCase("reset")) {
                c = new FormInputButton(this, e, "reset");
            } else if (t.equalsIgnoreCase("file")) {
                c = new FormInputUpload(this, e);
            } else if (t.equalsIgnoreCase("checkbox")) {
                c = new FormInputCheckbox(this, e, null);
                ((Checkbox)c).setState(((DInputElement)e).getChecked());
            } else if (t.equalsIgnoreCase("radio")) {
                FormInputCheckbox cb;
                String name = e.getAttribute("name");
                if (name != null) {
                    Checkbox cg_none = (Checkbox)this.cgs_none.get(name);
                    CheckboxGroup cg = (CheckboxGroup)this.cgs.get(name);
                    if (cg == null) {
                        cg = new CheckboxGroup();
                        cg_none = new Checkbox();
                        cg_none.setCheckboxGroup(cg);
                        cg_none.setState(((DInputElement)e).getChecked());
                        this.cgs.put(name, (Object)cg);
                        this.cgs_none.put(name, (Object)cg_none);
                    }
                    cb = new FormInputCheckbox(this, e, cg_none);
                    cb.setCheckboxGroup(cg);
                } else {
                    cb = new FormInputCheckbox(this, e, null);
                    cb.setCheckboxGroup(new CheckboxGroup());
                }
                ((Checkbox)cb).setState(((DInputElement)e).getChecked());
                c = cb;
            }
        } else if (tagName.equalsIgnoreCase("textarea")) {
            c = new FormTextArea(this, e);
        } else if (tagName.equalsIgnoreCase("select")) {
            int sz = e.getAttributeAsInt("size");
            c = sz <= 1 ? new FormSelectChoice(this, e) : new FormSelectList(this, e, sz);
        }
        if (c != null) {
            this.docPanel.add(c);
        }
        return c;
    }

    protected ObjectPainter createScroller() {
        Scroller s = new Scroller(this);
        this.docPanel.add(s);
        return s;
    }

    protected Container createEmbeddedContainer(EmbeddedObject obj, Component child) {
        EmbeddedObjectContainer c = new EmbeddedObjectContainer(obj);
        c.setLayout(new ViewportLayoutManager(obj));
        ((Component)c).setSize(obj.getPrefWidth(), obj.getPrefHeight());
        c.add(child);
        this.docPanel.add(c);
        this.postValidate(c.getParent());
        return c;
    }

    protected Component createFramesDividerComponent() {
        Panel p = new Panel();
        p.setBackground(new Color(200, 200, 200));
        return p;
    }

    protected void checkAwtTree(ObjectBox obox, Component c) {
        if (obox == null) {
            return;
        }
        ScrollBox sbox = obox.getAncestorScrollBox();
        if (sbox == null) {
            if (this.docPanel != c.getParent()) {
                this.docPanel.add(c);
            }
        } else {
            ObjectBox sobox = sbox.getObjectBox();
            ObjectPainter sop = sobox.getObjectPainter();
            if (sop instanceof Scroller) {
                Scroller scroller = (Scroller)sop;
                scroller.getView().add(c);
            }
        }
    }

    boolean onComponentEvent(Component source, AWTEvent event) {
        return this.onComponentEvent(source, event, null);
    }

    boolean onComponentEvent(Component source, AWTEvent event, EventListener action) {
        if (!this.checkDocumentId()) {
            return false;
        }
        int id = event.getID();
        if (500 <= id && id <= 507) {
            return this.onComponentMouseEvent(source, id, (MouseEvent)event, action);
        }
        if (400 <= id && id <= 402) {
            return this.onComponentKeyEvent(source, id, (KeyEvent)event, action);
        }
        if (1004 == id) {
            this.notifyFocusGain();
        } else if (1005 == id) {
            this.notifyFocusLost();
        }
        return true;
    }

    private boolean onComponentMouseEvent(Component c, int awt_id, MouseEvent e, EventListener action) {
        DOMUIEvent uie = this._translateMouseEvent(awt_id, e);
        if (uie == null) {
            return true;
        }
        return this.uiEvent(uie, e, action);
    }

    private DOMUIEvent _translateMouseEvent(int awt_id, MouseEvent e) {
        DOMUIEvent retval = null;
        int x = this._translateX(e);
        int y = this._translateY(e);
        int id = -1;
        switch (awt_id) {
            case 504: {
                id = 5;
                break;
            }
            case 505: {
                id = 7;
                break;
            }
            case 500: {
                if (e.getSource() != this.docPanel) break;
                this.docPanel.requestFocus();
                break;
            }
            case 501: {
                id = 3;
                break;
            }
            case 502: {
                id = 4;
                break;
            }
            case 503: 
            case 506: {
                id = 6;
            }
        }
        if (id >= 0) {
            retval = this.createDomUIEvent(id);
            boolean isPopupTrigger = e.isPopupTrigger();
            if (isPopupTrigger) {
                retval.setPopupTrigger(isPopupTrigger);
            }
            retval.setMousePressPopupTrigger(this.isMousePressPopupTrigger);
            if (id == 4 && this.isMousePressPopupTrigger) {
                this.isMousePressPopupTrigger = false;
            } else if (id == 3 && isPopupTrigger) {
                this.isMousePressPopupTrigger = true;
            }
            retval.setClientCoords(x, y, this.docPanel.getScrollX(), this.docPanel.getScrollY());
            try {
                Component c = e.getComponent();
                if (c.isShowing()) {
                    Point p = c.getLocationOnScreen();
                    retval.setScreenCoords(p.x + e.getX(), p.y + e.getY());
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return retval;
    }

    private int _translateX(MouseEvent e) {
        int add = 0;
        for (Component tmp = e.getComponent(); tmp != null && tmp != this.docPanel; tmp = tmp.getParent()) {
            Point ltmp = tmp.getLocation();
            add += ltmp.x;
        }
        return e.getX() + add;
    }

    private int _translateY(MouseEvent e) {
        int add = 0;
        for (Component tmp = e.getComponent(); tmp != null && tmp != this.docPanel; tmp = tmp.getParent()) {
            Point ltmp = tmp.getLocation();
            add += ltmp.y;
        }
        return e.getY() + add;
    }

    private boolean onComponentKeyEvent(Component c, int awt_id, KeyEvent awtEvent, EventListener action) {
        return this.processAwtKeyEvent(c, awtEvent, action);
    }

    private void postValidate(final Component c) {
        Runnable event = new Runnable(){

            public void run() {
                c.validate();
            }
        };
        this.getPilot().getStorm().runOnEventThreadLater(event, 100L);
    }

    void postShowChildren(final DocPanel p) {
        Runnable event = new Runnable(){

            public void run() {
                p.showChildren();
            }
        };
        this.getPilot().getStorm().runOnEventThreadLater(event, this.repaintTimeout);
    }

    protected void onNodeSelectCall(DNode node) {
        Component c;
        ObjectPainter painter = this.getNodePainter(node);
        if (painter instanceof Component && (c = (Component)((Object)painter)) instanceof TextComponent) {
            ((TextComponent)c).selectAll();
        }
    }

    protected void onNodeBlurEvent(DOMUIEvent event, DNode node) {
        ObjectPainter painter = this.getNodePainter(node);
        if (painter instanceof Component && event.getRelatedTarget() == null) {
            ((Component)((Object)painter)).getParent().requestFocus();
        }
    }

    protected void onNodeFocusEvent(DOMUIEvent event, DNode node) {
        ObjectPainter painter = this.getNodePainter(node);
        if (painter instanceof Component) {
            ((Component)((Object)painter)).requestFocus();
        }
    }

    public void reqFocus() {
        this.docPanel.requestFocus();
    }

    public void dispose() {
        this.docPanel.dispose();
    }
}

