/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DocAction;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ThePilot;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

class MarqueeObjectPainter
extends DocAction
implements ObjectPainter {
    private static final long delay = 100L;
    private static final int SCROLL = 0;
    private static final int ALTERNATE = 1;
    private static final int SLIDE = 2;
    private ThePilot pilot;
    private ObjectBox box;
    private int width;
    private int height;
    private int prefWidth;
    private int prefHeight;
    private int behavior = 0;
    private Font font;
    private FontMetrics fm;
    private Color textcolor;
    private String text;
    private boolean running = false;
    private boolean done = false;
    private int textLength = -1;
    private int _x;
    private int _y;
    private int _dx = -4;

    MarqueeObjectPainter(DDocument doc) {
        super(doc);
    }

    private void init() {
        DElement marquee = (DElement)this.box.parentBox.getDomNode();
        this.pilot = marquee.getPilot();
        String tmp = marquee.getAttribute("behavior");
        if (tmp == null) {
            tmp = marquee.getAttribute("behaviour");
        }
        if (tmp != null) {
            if (tmp.equalsIgnoreCase("alternate")) {
                this.behavior = 1;
            } else if (tmp.equalsIgnoreCase("slide")) {
                this.behavior = 2;
            }
        }
        this.text = marquee.getInnerText();
        this.fm = this.box.css.getFontMetrics();
        this.prefHeight = this.box.css.height;
        this.prefWidth = this.box.css.width;
        this.textcolor = this.box.css.color;
        this.textLength = this.fm.stringWidth(this.text);
    }

    public int getPrefWidth() {
        return this.prefWidth;
    }

    public int getPrefHeight() {
        return this.prefHeight;
    }

    public void setPainterSize(int w, int h) {
        this.width = w;
        this.height = h;
        this._y = this.fm.getMaxAscent() + this.fm.getLeading() + 1;
        if (this.behavior == 2 && this.width != 0 && !this.done) {
            this._x = this.width;
        }
        if (!this.running && !this.done) {
            this.running = true;
            this.postToEventThread(100L);
        }
    }

    public void dispose() {
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        if (box == null) {
            this.running = false;
            return;
        }
        this.init();
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public void setForeground(Color c) {
    }

    public void setBackground(Color c) {
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
        this.font = css.getTestedFont(this.text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics og) {
        Graphics g = og.create(0, 0, this.width, this.height);
        try {
            if (g.getFont() != this.font) {
                g.setFont(this.font);
            }
            g.setColor(this.textcolor);
            g.drawString(this.text, this._x, this._y);
        }
        finally {
            g.dispose();
        }
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
    }

    protected void doit(DDocument doc) {
        this._x += this._dx;
        if (this.behavior == 1) {
            if (this._dx < 0) {
                if (this.textLength < this.width) {
                    if (this._x < 0) {
                        this._dx = -this._dx;
                        this._x += this._dx;
                    }
                } else if (this._x + this.textLength < this.width) {
                    this._dx = -this._dx;
                    this._x += this._dx;
                }
            } else if (this.textLength < this.width) {
                if (this._x + this.textLength > this.width) {
                    this._dx = -this._dx;
                    this._x += this._dx;
                }
            } else if (this._x > 0) {
                this._dx = -this._dx;
                this._x += this._dx;
            }
        } else if (this.behavior == 2) {
            if (this.textLength < this.width) {
                if (this._x <= 0) {
                    this._x = 0;
                    this.done = true;
                }
            } else if (this._x + this.textLength <= this.width) {
                this._x = this.width - this.textLength;
                this.done = true;
            }
        } else if (this._x + this.textLength < 0) {
            this._x = this.width;
        }
        if (this.running && !this.done) {
            if (this.box != null) {
                this.box.reqRepaint();
            }
            this.postToEventThread(100L);
        }
    }

    public int getClientWidth() {
        return this.width;
    }

    public int getClientHeight() {
        return this.height;
    }
}

