/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSDecl;
import ice.pilots.html4.CSSRect;
import ice.util.JavaVersion;
import ice.util.alg.CharKit;
import ice.util.alg.HashArray;
import java.awt.Color;
import java.awt.Graphics;
import java.util.StringTokenizer;

class CSSUtil {
    static final int INVALID_LENGTH = Integer.MIN_VALUE;
    private static final Color[] defaultColors = new Color[]{new Color(0xF0F8FF), new Color(16444375), new Color(65535), new Color(8388564), new Color(0xF0FFFF), new Color(16119260), new Color(16770244), Color.black, new Color(16772045), new Color(255), new Color(9055202), new Color(0xA52A2A), new Color(14596231), new Color(6266528), new Color(0x7FFF00), new Color(13789470), new Color(16744272), new Color(6591981), new Color(16775388), new Color(14423100), new Color(65535), new Color(139), new Color(35723), new Color(12092939), new Color(0xA9A9A9), new Color(25600), new Color(0xA9A9A9), new Color(12433259), new Color(0x8B008B), new Color(5597999), new Color(16747520), new Color(10040012), new Color(0x8B0000), new Color(15308410), new Color(9419919), new Color(4734347), new Color(0x2F4F4F), new Color(0x2F4F4F), new Color(52945), new Color(9699539), new Color(16716947), new Color(49151), new Color(0x696969), new Color(0x696969), new Color(2003199), new Color(0xB22222), new Color(0xFFFAF0), new Color(0x228B22), new Color(0xFF00FF), new Color(0xDCDCDC), new Color(0xF8F8FF), new Color(16766720), new Color(14329120), new Color(0x808080), new Color(0x808080), new Color(32768), new Color(11403055), new Color(0xF0FFF0), new Color(16738740), new Color(0xCD5C5C), new Color(4915330), new Color(0xFFFFF0), new Color(15787660), new Color(15132410), new Color(0xFFF0F5), new Color(8190976), new Color(16775885), new Color(11393254), new Color(0xF08080), new Color(0xE0FFFF), new Color(16448210), new Color(0xD3D3D3), new Color(0x90EE90), new Color(0xD3D3D3), new Color(16758465), new Color(16752762), new Color(2142890), new Color(8900346), new Color(0x778899), new Color(0x778899), new Color(11584734), new Color(0xFFFFE0), new Color(65280), new Color(3329330), new Color(16445670), new Color(0xFF00FF), new Color(0x800000), new Color(6737322), new Color(205), new Color(12211667), new Color(9662683), new Color(3978097), new Color(8087790), new Color(64154), new Color(4772300), new Color(13047173), new Color(1644912), new Color(0xF5FFFA), new Color(16770273), new Color(16770229), new Color(16768685), new Color(128), new Color(16643558), new Color(0x808000), new Color(7048739), new Color(16753920), new Color(16729344), new Color(14315734), new Color(0xEEE8AA), new Color(10025880), new Color(0xAFEEEE), new Color(14381203), new Color(16773077), new Color(16767673), new Color(13468991), new Color(16761035), new Color(0xDDA0DD), new Color(11591910), new Color(0x800080), new Color(0xFF0000), new Color(12357519), new Color(4286945), new Color(9127187), new Color(16416882), new Color(16032864), new Color(3050327), new Color(0xFFF5EE), new Color(10506797), new Color(0xC0C0C0), new Color(8900331), new Color(6970061), new Color(7372944), new Color(7372944), new Color(0xFFFAFA), new Color(65407), new Color(4620980), new Color(13808780), new Color(32896), new Color(14204888), new Color(16737095), new Color(4251856), new Color(0xEE82EE), new Color(16113331), Color.white, new Color(0xF5F5F5), new Color(0xFFFF00), new Color(10145074)};
    private static final HashArray colors = new HashArray();

    CSSUtil() {
    }

    static int parseInt(String s, int defaultValue) {
        int start = 0;
        int end = s.length();
        return CSSUtil.parseInt(s, start, end, defaultValue);
    }

    static int parseInt(String s, int start, int end, int defaultValue) {
        long value;
        char c;
        if ((start = CharKit.trimStart(s, start, end)) != (end = CharKit.trimEnd(s, start, end)) && ((c = s.charAt(end - 1)) == '\"' || c == '.')) {
            --end;
        }
        if ((value = CharKit.parseInt(s, start, end)) >= 0L) {
            return (int)value;
        }
        return defaultValue;
    }

    static int parseIntAsFloat(String s) throws NumberFormatException {
        if ((s = s.trim()).endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return Double.valueOf(s).intValue();
    }

    static int findNonSpace(char[] buf, int pos1, int pos2) {
        char c = '\u0000';
        while (pos1 < pos2) {
            c = buf[pos1];
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != '\f') {
                return pos1;
            }
            ++pos1;
        }
        return -1;
    }

    static int findWhitespace(char[] buf, int pos1, int pos2) {
        char c = '\u0000';
        while (pos1 < pos2) {
            c = buf[pos1];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f') {
                return pos1;
            }
            ++pos1;
        }
        return -1;
    }

    static int parseLength(String s) {
        int start = 0;
        int end = s.length();
        if ((start = CharKit.trimStart(s, start, end)) != (end = CharKit.trimEnd(s, start, end))) {
            int number_end;
            long tmp;
            int i = start;
            boolean percents = false;
            do {
                char c;
                if ('0' <= (c = s.charAt(i)) && c <= '9') continue;
                if (c != '%') break;
                percents = true;
                break;
            } while (++i != end);
            if ((tmp = CharKit.parseInt(s, start, number_end = i)) >= 0L) {
                int value = (int)tmp;
                if (percents) {
                    value = -value;
                }
                return value;
            }
        }
        return Integer.MIN_VALUE;
    }

    static long findNextValue1(char[] buf, int pos1, int pos2) {
        int p;
        char c = '\u0000';
        block0: while (pos1 < pos2) {
            c = buf[pos1];
            if (c == '/' && pos1 + 1 < pos2 && buf[pos1 + 1] == '*') {
                pos1 += 2;
                while (pos1 < pos2) {
                    c = buf[pos1];
                    if (c == '*' && pos1 + 1 < pos2 && buf[pos1 + 1] == '/') {
                        pos1 += 2;
                        continue block0;
                    }
                    ++pos1;
                }
                continue;
            }
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != '\f') break;
            ++pos1;
        }
        if (pos1 >= pos2) {
            return 0L;
        }
        boolean comma_found = false;
        int par = 0;
        for (p = pos1; p < pos2; ++p) {
            c = buf[p];
            if (c == ')') {
                --par;
                continue;
            }
            if (c == '(') {
                ++par;
                continue;
            }
            if (c == ',') {
                comma_found = true;
                continue;
            }
            if (par == 0 && !comma_found && (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f')) break;
            comma_found = false;
        }
        return (long)p << 32 | (long)pos1;
    }

    static void parseRect(CSSDecl decl, String str) {
        if ((str = CharKit.toLowerCase(str.trim())).startsWith("rect(")) {
            str = str.substring(5, str.length() - 1);
        }
        if ((str = str.replace(',', ' ')).equals("auto")) {
            decl.type = 15;
            return;
        }
        CSSRect r = new CSSRect();
        StringTokenizer st = new StringTokenizer(str, "\n\r\t ");
        int count = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            CSSDecl d = new CSSDecl(0, 0, null);
            if (s.equals("auto")) {
                d.type = 15;
            } else {
                char[] c = s.toCharArray();
                CSSUtil.parseLength(d, c, 0, c.length);
            }
            if (d.type == 0) continue;
            if (count == 0) {
                r.declTop = d;
            } else if (count == 1) {
                r.declRight = d;
            } else if (count == 2) {
                r.declBottom = d;
            } else if (count == 3) {
                r.declLeft = d;
            }
            ++count;
        }
        if (r.declTop != null && r.declRight != null && r.declBottom != null && r.declLeft != null) {
            decl.type = -16;
            decl.value = r;
        }
    }

    static void cssClipRectToPixels(CSSRect r, CSSAttribs css, int zoom) {
        css.clip = new CSSRect();
        css.clip.top = r.declTop != null && r.declTop.type != 15 ? CSSUtil.cssLengthToPixels(r.declTop, css, zoom) : 0;
        css.clip.right = r.declRight != null && r.declRight.type != 15 ? CSSUtil.cssLengthToPixels(r.declRight, css, zoom) : 100000;
        css.clip.bottom = r.declBottom != null && r.declBottom.type != 15 ? CSSUtil.cssLengthToPixels(r.declBottom, css, zoom) : 100000;
        css.clip.left = r.declLeft != null && r.declLeft.type != 15 ? CSSUtil.cssLengthToPixels(r.declLeft, css, zoom) : 0;
    }

    static String parseUrl(char[] buf, int pos1, int pos2) {
        if (pos2 >= buf.length) {
            pos2 = buf.length - 1;
        }
        if (!(buf[pos1] != 'u' && buf[pos1] != 'U' || buf[pos1 + 1] != 'r' && buf[pos1 + 1] != 'R' || buf[pos1 + 2] != 'l' && buf[pos1 + 2] != 'L')) {
            boolean _startBrace = false;
            boolean _endBrace = false;
            if (buf[pos1 += 3] == '(') {
                _startBrace = true;
                ++pos1;
            } else {
                return null;
            }
            if (buf[pos2] != ')') {
                for (int i = pos2 - 1; i > pos1; --i) {
                    if (buf[i] != ')') continue;
                    _endBrace = true;
                    pos2 = i - 1;
                    break;
                }
            } else {
                _endBrace = true;
                --pos2;
            }
            if (!_startBrace || !_endBrace) {
                return null;
            }
        }
        while (buf[pos1] == ' ' && pos1 + 1 < pos2) {
            ++pos1;
        }
        while (buf[pos2] == ' ' && pos2 - 1 > pos1) {
            --pos2;
        }
        if (buf[pos1] == '\"' && buf[pos2] == '\"' || buf[pos1] == '\'' && buf[pos2] == '\'') {
            ++pos1;
            --pos2;
        } else if (buf[pos1] == '\"' || buf[pos2] == '\"' || buf[pos1] == '\'' || buf[pos2] == '\'') {
            return null;
        }
        while (buf[pos1] == ' ' && pos1 + 1 < pos2) {
            ++pos1;
        }
        while (buf[pos2] == ' ' && pos2 - 1 > pos1) {
            --pos2;
        }
        return new String(buf, pos1, pos2 - pos1 + 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getDefaultColorIndex(String s) {
        boolean Id_aliceblue = true;
        int Id_antiquewhite = 2;
        int Id_aqua = 3;
        int Id_aquamarine = 4;
        int Id_azure = 5;
        int Id_beige = 6;
        int Id_bisque = 7;
        int Id_black = 8;
        int Id_blanchedalmond = 9;
        int Id_blue = 10;
        int Id_blueviolet = 11;
        int Id_brown = 12;
        int Id_burlywood = 13;
        int Id_cadetblue = 14;
        int Id_chartreuse = 15;
        int Id_chocolate = 16;
        int Id_coral = 17;
        int Id_cornflowerblue = 18;
        int Id_cornsilk = 19;
        int Id_crimson = 20;
        int Id_cyan = 21;
        int Id_darkblue = 22;
        int Id_darkcyan = 23;
        int Id_darkgoldenrod = 24;
        int Id_darkgray = 25;
        int Id_darkgreen = 26;
        int Id_darkgrey = 27;
        int Id_darkkhaki = 28;
        int Id_darkmagenta = 29;
        int Id_darkolivegreen = 30;
        int Id_darkorange = 31;
        int Id_darkorchid = 32;
        int Id_darkred = 33;
        int Id_darksalmon = 34;
        int Id_darkseagreen = 35;
        int Id_darkslateblue = 36;
        int Id_darkslategray = 37;
        int Id_darkslategrey = 38;
        int Id_darkturquoise = 39;
        int Id_darkviolet = 40;
        int Id_deeppink = 41;
        int Id_deepskyblue = 42;
        int Id_dimgray = 43;
        int Id_dimgrey = 44;
        int Id_dodgerblue = 45;
        int Id_firebrick = 46;
        int Id_floralwhite = 47;
        int Id_forestgreen = 48;
        int Id_fuchsia = 49;
        int Id_gainsboro = 50;
        int Id_ghostwhite = 51;
        int Id_gold = 52;
        int Id_goldenrod = 53;
        int Id_gray = 54;
        int Id_grey = 55;
        int Id_green = 56;
        int Id_greenyellow = 57;
        int Id_honeydew = 58;
        int Id_hotpink = 59;
        int Id_indianred = 60;
        int Id_indigo = 61;
        int Id_ivory = 62;
        int Id_khaki = 63;
        int Id_lavender = 64;
        int Id_lavenderblush = 65;
        int Id_lawngreen = 66;
        int Id_lemonchiffon = 67;
        int Id_lightblue = 68;
        int Id_lightcoral = 69;
        int Id_lightcyan = 70;
        int Id_lightgoldenrodyellow = 71;
        int Id_lightgray = 72;
        int Id_lightgreen = 73;
        int Id_lightgrey = 74;
        int Id_lightpink = 75;
        int Id_lightsalmon = 76;
        int Id_lightseagreen = 77;
        int Id_lightskyblue = 78;
        int Id_lightslategray = 79;
        int Id_lightslategrey = 80;
        int Id_lightsteelblue = 81;
        int Id_lightyellow = 82;
        int Id_lime = 83;
        int Id_limegreen = 84;
        int Id_linen = 85;
        int Id_magenta = 86;
        int Id_maroon = 87;
        int Id_mediumaquamarine = 88;
        int Id_mediumblue = 89;
        int Id_mediumorchid = 90;
        int Id_mediumpurple = 91;
        int Id_mediumseagreen = 92;
        int Id_mediumslateblue = 93;
        int Id_mediumspringgreen = 94;
        int Id_mediumturquoise = 95;
        int Id_mediumvioletred = 96;
        int Id_midnightblue = 97;
        int Id_mintcream = 98;
        int Id_mistyrose = 99;
        int Id_moccasin = 100;
        int Id_navajowhite = 101;
        int Id_navy = 102;
        int Id_oldlace = 103;
        int Id_olive = 104;
        int Id_olivedrab = 105;
        int Id_orange = 106;
        int Id_orangered = 107;
        int Id_orchid = 108;
        int Id_palegoldenrod = 109;
        int Id_palegreen = 110;
        int Id_paleturquoise = 111;
        int Id_palevioletred = 112;
        int Id_papayawhip = 113;
        int Id_peachpuff = 114;
        int Id_peru = 115;
        int Id_pink = 116;
        int Id_plum = 117;
        int Id_powderblue = 118;
        int Id_purple = 119;
        int Id_red = 120;
        int Id_rosybrown = 121;
        int Id_royalblue = 122;
        int Id_saddlebrown = 123;
        int Id_salmon = 124;
        int Id_sandybrown = 125;
        int Id_seagreen = 126;
        int Id_seashell = 127;
        int Id_sienna = 128;
        int Id_silver = 129;
        int Id_skyblue = 130;
        int Id_slateblue = 131;
        int Id_slategray = 132;
        int Id_slategrey = 133;
        int Id_snow = 134;
        int Id_springgreen = 135;
        int Id_steelblue = 136;
        int Id_tan = 137;
        int Id_teal = 138;
        int Id_thistle = 139;
        int Id_tomato = 140;
        int Id_turquoise = 141;
        int Id_violet = 142;
        int Id_wheat = 143;
        int Id_white = 144;
        int Id_whitesmoke = 145;
        int Id_yellow = 146;
        int Id_yellowgreen = 147;
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 3: {
                char c = s.charAt(0);
                if (c == 'r') {
                    if (s.charAt(2) != 'd' || s.charAt(1) != 'e') break;
                    return 119;
                }
                if (c != 't' || s.charAt(2) != 'n' || s.charAt(1) != 'a') break;
                return 136;
            }
            case 4: {
                switch (s.charAt(3)) {
                    case 'a': {
                        X = "aqua";
                        id = 3;
                        break;
                    }
                    case 'd': {
                        X = "gold";
                        id = 52;
                        break;
                    }
                    case 'e': {
                        char c = s.charAt(0);
                        if (c == 'b') {
                            if (s.charAt(2) != 'u' || s.charAt(1) != 'l') break;
                            return 9;
                        }
                        if (c != 'l' || s.charAt(2) != 'm' || s.charAt(1) != 'i') break;
                        return 82;
                    }
                    case 'k': {
                        X = "pink";
                        id = 116;
                        break;
                    }
                    case 'l': {
                        X = "teal";
                        id = 138;
                        break;
                    }
                    case 'm': {
                        X = "plum";
                        id = 117;
                        break;
                    }
                    case 'n': {
                        X = "cyan";
                        id = 21;
                        break;
                    }
                    case 'u': {
                        X = "peru";
                        id = 115;
                        break;
                    }
                    case 'w': {
                        X = "snow";
                        id = 134;
                        break;
                    }
                    case 'y': {
                        char c = s.charAt(2);
                        if (c == 'a') {
                            if (s.charAt(0) != 'g' || s.charAt(1) != 'r') break;
                            return 53;
                        }
                        if (c == 'e') {
                            if (s.charAt(0) != 'g' || s.charAt(1) != 'r') break;
                            return 54;
                        }
                        if (c != 'v' || s.charAt(0) != 'n' || s.charAt(1) != 'a') break;
                        return 101;
                    }
                }
                break;
            }
            case 5: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "azure";
                        id = 5;
                        break;
                    }
                    case 'b': {
                        char c = s.charAt(4);
                        if (c == 'e') {
                            X = "beige";
                            id = 6;
                            break;
                        }
                        if (c == 'k') {
                            X = "black";
                            id = 8;
                            break;
                        }
                        if (c != 'n') break;
                        X = "brown";
                        id = 12;
                        break;
                    }
                    case 'c': {
                        X = "coral";
                        id = 17;
                        break;
                    }
                    case 'g': {
                        X = "green";
                        id = 56;
                        break;
                    }
                    case 'i': {
                        X = "ivory";
                        id = 62;
                        break;
                    }
                    case 'k': {
                        X = "khaki";
                        id = 63;
                        break;
                    }
                    case 'l': {
                        X = "linen";
                        id = 85;
                        break;
                    }
                    case 'o': {
                        X = "olive";
                        id = 104;
                        break;
                    }
                    case 'w': {
                        char c = s.charAt(4);
                        if (c == 'e') {
                            X = "white";
                            id = 144;
                            break;
                        }
                        if (c != 't') break;
                        X = "wheat";
                        id = 143;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(3)) {
                    case 'a': {
                        X = "tomato";
                        id = 140;
                        break;
                    }
                    case 'h': {
                        X = "orchid";
                        id = 108;
                        break;
                    }
                    case 'i': {
                        X = "indigo";
                        id = 61;
                        break;
                    }
                    case 'l': {
                        char c = s.charAt(0);
                        if (c == 'v') {
                            X = "violet";
                            id = 142;
                            break;
                        }
                        if (c != 'y') break;
                        X = "yellow";
                        id = 146;
                        break;
                    }
                    case 'm': {
                        X = "salmon";
                        id = 124;
                        break;
                    }
                    case 'n': {
                        char c = s.charAt(0);
                        if (c == 'o') {
                            X = "orange";
                            id = 106;
                            break;
                        }
                        if (c != 's') break;
                        X = "sienna";
                        id = 128;
                        break;
                    }
                    case 'o': {
                        X = "maroon";
                        id = 87;
                        break;
                    }
                    case 'p': {
                        X = "purple";
                        id = 119;
                        break;
                    }
                    case 'q': {
                        X = "bisque";
                        id = 7;
                        break;
                    }
                    case 'v': {
                        X = "silver";
                        id = 129;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(3)) {
                    case 'b': {
                        X = "skyblue";
                        id = 130;
                        break;
                    }
                    case 'e': {
                        X = "magenta";
                        id = 86;
                        break;
                    }
                    case 'g': {
                        char c = s.charAt(5);
                        if (c == 'a') {
                            X = "dimgray";
                            id = 43;
                            break;
                        }
                        if (c != 'e') break;
                        X = "dimgrey";
                        id = 44;
                        break;
                    }
                    case 'h': {
                        X = "fuchsia";
                        id = 49;
                        break;
                    }
                    case 'k': {
                        X = "darkred";
                        id = 33;
                        break;
                    }
                    case 'l': {
                        X = "oldlace";
                        id = 103;
                        break;
                    }
                    case 'm': {
                        X = "crimson";
                        id = 20;
                        break;
                    }
                    case 'p': {
                        X = "hotpink";
                        id = 59;
                        break;
                    }
                    case 's': {
                        X = "thistle";
                        id = 139;
                        break;
                    }
                }
                break;
            }
            case 8: {
                switch (s.charAt(4)) {
                    case 'a': {
                        X = "moccasin";
                        id = 100;
                        break;
                    }
                    case 'b': {
                        X = "darkblue";
                        id = 22;
                        break;
                    }
                    case 'c': {
                        X = "darkcyan";
                        id = 23;
                        break;
                    }
                    case 'g': {
                        char c = s.charAt(6);
                        if (c == 'a') {
                            X = "darkgray";
                            id = 25;
                            break;
                        }
                        if (c != 'e') break;
                        X = "darkgrey";
                        id = 27;
                        break;
                    }
                    case 'h': {
                        X = "seashell";
                        id = 127;
                        break;
                    }
                    case 'n': {
                        X = "lavender";
                        id = 64;
                        break;
                    }
                    case 'p': {
                        X = "deeppink";
                        id = 41;
                        break;
                    }
                    case 'r': {
                        X = "seagreen";
                        id = 126;
                        break;
                    }
                    case 's': {
                        X = "cornsilk";
                        id = 19;
                        break;
                    }
                    case 'y': {
                        X = "honeydew";
                        id = 58;
                        break;
                    }
                }
                break;
            }
            case 9: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "aliceblue";
                        id = 1;
                        break;
                    }
                    case 'b': {
                        X = "burlywood";
                        id = 13;
                        break;
                    }
                    case 'c': {
                        char c = s.charAt(1);
                        if (c == 'a') {
                            X = "cadetblue";
                            id = 14;
                            break;
                        }
                        if (c != 'h') break;
                        X = "chocolate";
                        id = 16;
                        break;
                    }
                    case 'd': {
                        char c = s.charAt(8);
                        if (c == 'i') {
                            X = "darkkhaki";
                            id = 28;
                            break;
                        }
                        if (c != 'n') break;
                        X = "darkgreen";
                        id = 26;
                        break;
                    }
                    case 'f': {
                        X = "firebrick";
                        id = 46;
                        break;
                    }
                    case 'g': {
                        char c = s.charAt(8);
                        if (c == 'd') {
                            X = "goldenrod";
                            id = 53;
                            break;
                        }
                        if (c != 'o') break;
                        X = "gainsboro";
                        id = 50;
                        break;
                    }
                    case 'i': {
                        X = "indianred";
                        id = 60;
                        break;
                    }
                    case 'l': {
                        switch (s.charAt(5)) {
                            case 'b': {
                                X = "lightblue";
                                id = 68;
                                break;
                            }
                            case 'c': {
                                X = "lightcyan";
                                id = 70;
                                break;
                            }
                            case 'g': {
                                char c = s.charAt(7);
                                if (c == 'a') {
                                    X = "lightgray";
                                    id = 72;
                                    break;
                                }
                                if (c != 'e') break;
                                X = "lightgrey";
                                id = 74;
                                break;
                            }
                            case 'p': {
                                X = "lightpink";
                                id = 75;
                                break;
                            }
                            case 'r': {
                                char c = s.charAt(1);
                                if (c == 'a') {
                                    X = "lawngreen";
                                    id = 66;
                                    break;
                                }
                                if (c != 'i') break;
                                X = "limegreen";
                                id = 84;
                                break;
                            }
                        }
                        break;
                    }
                    case 'm': {
                        char c = s.charAt(8);
                        if (c == 'e') {
                            X = "mistyrose";
                            id = 99;
                            break;
                        }
                        if (c != 'm') break;
                        X = "mintcream";
                        id = 98;
                        break;
                    }
                    case 'o': {
                        char c = s.charAt(8);
                        if (c == 'b') {
                            X = "olivedrab";
                            id = 105;
                            break;
                        }
                        if (c != 'd') break;
                        X = "orangered";
                        id = 107;
                        break;
                    }
                    case 'p': {
                        char c = s.charAt(8);
                        if (c == 'f') {
                            X = "peachpuff";
                            id = 114;
                            break;
                        }
                        if (c != 'n') break;
                        X = "palegreen";
                        id = 110;
                        break;
                    }
                    case 'r': {
                        char c = s.charAt(8);
                        if (c == 'e') {
                            X = "royalblue";
                            id = 122;
                            break;
                        }
                        if (c != 'n') break;
                        X = "rosybrown";
                        id = 121;
                        break;
                    }
                    case 's': {
                        char c = s.charAt(7);
                        if (c == 'a') {
                            X = "slategray";
                            id = 132;
                            break;
                        }
                        if (c == 'e') {
                            X = "slategrey";
                            id = 133;
                            break;
                        }
                        if (c != 'u') break;
                        c = s.charAt(1);
                        if (c == 'l') {
                            X = "slateblue";
                            id = 131;
                            break;
                        }
                        if (c != 't') break;
                        X = "steelblue";
                        id = 136;
                        break;
                    }
                    case 't': {
                        X = "turquoise";
                        id = 141;
                        break;
                    }
                }
                break;
            }
            case 10: {
                switch (s.charAt(8)) {
                    case 'a': {
                        X = "lightcoral";
                        id = 69;
                        break;
                    }
                    case 'e': {
                        char c = s.charAt(0);
                        if (c == 'b') {
                            X = "blueviolet";
                            id = 11;
                            break;
                        }
                        if (c == 'd') {
                            X = "darkviolet";
                            id = 40;
                            break;
                        }
                        if (c != 'l') break;
                        X = "lightgreen";
                        id = 73;
                        break;
                    }
                    case 'g': {
                        X = "darkorange";
                        id = 31;
                        break;
                    }
                    case 'i': {
                        char c = s.charAt(0);
                        if (c == 'd') {
                            X = "darkorchid";
                            id = 32;
                            break;
                        }
                        if (c != 'p') break;
                        X = "papayawhip";
                        id = 113;
                        break;
                    }
                    case 'k': {
                        X = "whitesmoke";
                        id = 145;
                        break;
                    }
                    case 'n': {
                        X = "aquamarine";
                        id = 4;
                        break;
                    }
                    case 'o': {
                        X = "darksalmon";
                        id = 34;
                        break;
                    }
                    case 's': {
                        X = "chartreuse";
                        id = 15;
                        break;
                    }
                    case 't': {
                        X = "ghostwhite";
                        id = 51;
                        break;
                    }
                    case 'u': {
                        char c = s.charAt(0);
                        if (c == 'd') {
                            X = "dodgerblue";
                            id = 45;
                            break;
                        }
                        if (c == 'm') {
                            X = "mediumblue";
                            id = 89;
                            break;
                        }
                        if (c != 'p') break;
                        X = "powderblue";
                        id = 118;
                        break;
                    }
                    case 'w': {
                        X = "sandybrown";
                        id = 125;
                        break;
                    }
                }
                break;
            }
            case 11: {
                switch (s.charAt(5)) {
                    case 'a': {
                        X = "darkmagenta";
                        id = 29;
                        break;
                    }
                    case 'e': {
                        X = "saddlebrown";
                        id = 123;
                        break;
                    }
                    case 'g': {
                        X = "springgreen";
                        id = 135;
                        break;
                    }
                    case 'k': {
                        X = "deepskyblue";
                        id = 42;
                        break;
                    }
                    case 'l': {
                        X = "floralwhite";
                        id = 47;
                        break;
                    }
                    case 'o': {
                        X = "navajowhite";
                        id = 101;
                        break;
                    }
                    case 's': {
                        X = "lightsalmon";
                        id = 76;
                        break;
                    }
                    case 't': {
                        X = "forestgreen";
                        id = 48;
                        break;
                    }
                    case 'w': {
                        X = "yellowgreen";
                        id = 147;
                        break;
                    }
                    case 'y': {
                        char c = s.charAt(0);
                        if (c == 'g') {
                            X = "greenyellow";
                            id = 57;
                            break;
                        }
                        if (c != 'l') break;
                        X = "lightyellow";
                        id = 82;
                        break;
                    }
                }
                break;
            }
            case 12: {
                switch (s.charAt(7)) {
                    case 'g': {
                        X = "darkseagreen";
                        id = 35;
                        break block0;
                    }
                    case 'i': {
                        X = "lemonchiffon";
                        id = 67;
                        break block0;
                    }
                    case 'r': {
                        X = "mediumorchid";
                        id = 90;
                        break block0;
                    }
                    case 't': {
                        X = "midnightblue";
                        id = 97;
                        break block0;
                    }
                    case 'u': {
                        X = "mediumpurple";
                        id = 91;
                        break block0;
                    }
                    case 'w': {
                        X = "antiquewhite";
                        id = 2;
                        break block0;
                    }
                    case 'y': {
                        X = "lightskyblue";
                        id = 78;
                        break block0;
                    }
                }
                break;
            }
            case 13: {
                switch (s.charAt(9)) {
                    case 'b': {
                        X = "darkslateblue";
                        id = 36;
                        break;
                    }
                    case 'g': {
                        char c = s.charAt(11);
                        if (c == 'a') {
                            X = "darkslategray";
                            id = 37;
                            break;
                        }
                        if (c != 'e') break;
                        X = "darkslategrey";
                        id = 38;
                        break;
                    }
                    case 'l': {
                        X = "lavenderblush";
                        id = 65;
                        break;
                    }
                    case 'n': {
                        char c = s.charAt(0);
                        if (c == 'd') {
                            X = "darkgoldenrod";
                            id = 24;
                            break;
                        }
                        if (c != 'p') break;
                        X = "palegoldenrod";
                        id = 109;
                        break;
                    }
                    case 'o': {
                        char c = s.charAt(0);
                        if (c == 'd') {
                            X = "darkturquoise";
                            id = 39;
                            break;
                        }
                        if (c != 'p') break;
                        X = "paleturquoise";
                        id = 111;
                        break;
                    }
                    case 'r': {
                        X = "lightseagreen";
                        id = 77;
                        break;
                    }
                    case 't': {
                        X = "palevioletred";
                        id = 112;
                        break;
                    }
                }
                break;
            }
            case 14: {
                switch (s.charAt(6)) {
                    case 'e': {
                        X = "blanchedalmond";
                        id = 9;
                        break;
                    }
                    case 'i': {
                        X = "darkolivegreen";
                        id = 30;
                        break;
                    }
                    case 'l': {
                        char c = s.charAt(12);
                        if (c == 'a') {
                            X = "lightslategray";
                            id = 79;
                            break;
                        }
                        if (c != 'e') break;
                        X = "lightslategrey";
                        id = 80;
                        break;
                    }
                    case 'o': {
                        X = "cornflowerblue";
                        id = 18;
                        break;
                    }
                    case 's': {
                        X = "mediumseagreen";
                        id = 92;
                        break;
                    }
                    case 't': {
                        X = "lightsteelblue";
                        id = 81;
                        break;
                    }
                }
                break;
            }
            case 15: {
                char c = s.charAt(6);
                if (c == 's') {
                    X = "mediumslateblue";
                    id = 93;
                    break;
                }
                if (c == 't') {
                    X = "mediumturquoise";
                    id = 95;
                    break;
                }
                if (c != 'v') break;
                X = "mediumvioletred";
                id = 96;
                break;
            }
            case 16: {
                X = "mediumaquamarine";
                id = 88;
                break;
            }
            case 17: {
                X = "mediumspringgreen";
                id = 94;
                break;
            }
            case 20: {
                X = "lightgoldenrodyellow";
                id = 71;
            }
        }
        if (X == null) return id - 1;
        if (X == s) return id - 1;
        if (X.equals(s)) return id - 1;
        return -1;
    }

    static void addColorDefinition(String name, Color color) {
        int index = CSSUtil.getDefaultColorIndex(name = CharKit.toLowerCase(name));
        if (index >= 0) {
            CSSUtil.defaultColors[index] = color;
        } else {
            colors.put(name, (Object)color);
        }
    }

    private static Color convertNamedColor(String name) {
        int index = CSSUtil.getDefaultColorIndex(name);
        return index >= 0 ? defaultColors[index] : (Color)colors.get(name);
    }

    static String convertColorNameToRGB(String name) {
        Color c = CSSUtil.convertNamedColor(CharKit.toLowerCase(name));
        if (c != null) {
            int rgb = c.getRGB();
            char[] buf = new char[7];
            buf[0] = 35;
            int pos = 1;
            for (int shift = 20; shift >= 0; shift -= 4) {
                int d = 0xF & rgb >> shift;
                buf[pos] = (char)(d < 10 ? d + 48 : d + 65 - 10);
                ++pos;
            }
            name = new String(buf, 0, 7);
        }
        return name;
    }

    static Color parseColor(char[] buf, int pos, int len) {
        if (len < 2) {
            return null;
        }
        int pos2 = pos + len;
        char c = buf[pos];
        char c1 = buf[pos + 1];
        if (c == '#') {
            int r = 0;
            int g = 0;
            int b = 0;
            if (pos2 - pos < 4) {
                return null;
            }
            if (pos2 - pos >= 7) {
                r = (CSSUtil.hexToInt(buf[pos + 1]) << 4) + CSSUtil.hexToInt(buf[pos + 2]);
                g = (CSSUtil.hexToInt(buf[pos + 3]) << 4) + CSSUtil.hexToInt(buf[pos + 4]);
                b = (CSSUtil.hexToInt(buf[pos + 5]) << 4) + CSSUtil.hexToInt(buf[pos + 6]);
            } else if (pos2 - pos == 6) {
                r = (CSSUtil.hexToInt(buf[pos + 1]) << 4) + CSSUtil.hexToInt(buf[pos + 2]);
                g = (CSSUtil.hexToInt(buf[pos + 3]) << 4) + CSSUtil.hexToInt(buf[pos + 4]);
                b = (CSSUtil.hexToInt(buf[pos + 5]) << 4) + 0;
            } else if (pos2 - pos < 6) {
                r = CSSUtil.hexToInt(buf[pos + 1]);
                g = CSSUtil.hexToInt(buf[pos + 2]);
                b = CSSUtil.hexToInt(buf[pos + 3]);
                r = (r << 4) + r;
                g = (g << 4) + g;
                b = (b << 4) + b;
            }
            return new Color(r, g, b);
        }
        if (!(c != 'r' && c != 'R' || c1 != 'g' && c1 != 'G')) {
            int idx;
            pos += 4;
            --pos2;
            int r = 0;
            boolean p = false;
            boolean skip = false;
            boolean valueFound = false;
            for (idx = pos; idx < pos2; ++idx) {
                c = buf[idx];
                if (c == ',') {
                    ++idx;
                    break;
                }
                if (c == '.') {
                    skip = true;
                    continue;
                }
                if (c == '%') {
                    p = true;
                    continue;
                }
                if (c < '0' || c > '9' || skip) continue;
                valueFound = true;
                r = r * 10 + (c - 48);
            }
            if (!valueFound) {
                r = 255;
            }
            if (p) {
                r = 255 * r / 100;
            }
            if (r < 0) {
                r = 0;
            } else if (r > 255) {
                r = 255;
            }
            int g = 0;
            p = false;
            skip = false;
            valueFound = false;
            while (idx < pos2) {
                c = buf[idx];
                if (c == ',') {
                    ++idx;
                    break;
                }
                if (c == '.') {
                    skip = true;
                } else if (c == '%') {
                    p = true;
                } else if (c >= '0' && c <= '9' && !skip && idx > pos) {
                    valueFound = true;
                    g = g * 10 + (c - 48);
                }
                ++idx;
            }
            if (!valueFound) {
                g = 255;
            }
            if (p) {
                g = 255 * g / 100;
            }
            if (g < 0) {
                g = 0;
            } else if (g > 255) {
                g = 255;
            }
            int b = 0;
            p = false;
            skip = false;
            valueFound = false;
            while (idx < pos2) {
                c = buf[idx];
                if (c == ',') {
                    ++idx;
                    break;
                }
                if (c == '.') {
                    skip = true;
                } else if (c == '%') {
                    p = true;
                } else if (c >= '0' && c <= '9' && !skip && idx > pos) {
                    valueFound = true;
                    b = b * 10 + (c - 48);
                }
                ++idx;
            }
            if (!valueFound) {
                b = 255;
            }
            if (p) {
                b = 255 * b / 100;
            }
            if (b < 0) {
                b = 0;
            } else if (b > 255) {
                b = 255;
            }
            return new Color(r, g, b);
        }
        char[] tmpbuf = new char[len];
        System.arraycopy(buf, pos, tmpbuf, 0, len);
        CharKit.asciiToLowerCase(tmpbuf, 0, len);
        String s = new String(tmpbuf);
        Color color = CSSUtil.convertNamedColor(s);
        if (color != null) {
            return color;
        }
        if (len == 6) {
            char nextChar = buf[pos];
            boolean validColour = true;
            for (int i = 0; i < 6; ++i) {
                nextChar = buf[pos + i];
                if (nextChar >= '0' && nextChar <= '9' || nextChar >= 'A' && nextChar <= 'F' || nextChar >= 'a' && nextChar <= 'f') continue;
                validColour = false;
                break;
            }
            if (validColour) {
                int r = 0;
                int g = 0;
                int b = 0;
                r = (CSSUtil.hexToInt(buf[pos + 0]) << 4) + CSSUtil.hexToInt(buf[pos + 1]);
                g = (CSSUtil.hexToInt(buf[pos + 2]) << 4) + CSSUtil.hexToInt(buf[pos + 3]);
                b = (CSSUtil.hexToInt(buf[pos + 4]) << 4) + CSSUtil.hexToInt(buf[pos + 5]);
                return new Color(r, g, b);
            }
        }
        return null;
    }

    static void parseLength(CSSDecl decl, char[] buf, int pos, int len) {
        if (len == 1) {
            int t = buf[pos];
            t = t >= 48 || t <= 57 ? (t -= 48) : 0;
            decl.type = -7;
            decl.value = new Float(t);
            return;
        }
        char c = buf[pos + len - 1];
        if (c == '%') {
            try {
                decl.value = new Float(new String(buf, pos, len - 1));
                decl.type = -4;
            }
            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        char c1 = buf[pos + len - 2];
        decl.type = !(c1 != 'e' && c1 != 'E' || c != 'm' && c != 'M') ? -5 : (!(c1 != 'e' && c1 != 'E' || c != 'x' && c != 'X') ? -6 : (!(c1 != 'p' && c1 != 'P' || c != 'x' && c != 'X') ? -7 : (!(c1 != 'i' && c1 != 'I' || c != 'n' && c != 'N') ? -8 : (!(c1 != 'c' && c1 != 'C' || c != 'm' && c != 'M') ? -9 : (!(c1 != 'm' && c1 != 'M' || c != 'm' && c != 'M') ? -10 : (!(c1 != 'p' && c1 != 'P' || c != 't' && c != 'T') ? -11 : (!(c1 != 'p' && c1 != 'P' || c != 'c' && c != 'C') ? -12 : -7)))))));
        try {
            decl.value = Character.isDigit(c) ? new Float(new String(buf, pos, len)) : new Float(new String(buf, pos, len - 2));
        }
        catch (Exception ex) {
            decl.type = 0;
        }
    }

    static int cssLengthToPixels(CSSDecl decl, CSSAttribs css, int zoom) {
        float f = 0.0f;
        try {
            f = ((Float)decl.value).floatValue();
        }
        catch (Exception ex) {
            return 0;
        }
        switch (decl.type) {
            case -4: {
                return (int)f;
            }
            case -5: {
                return (int)(f * (float)css.font_size);
            }
            case -6: {
                return (int)(0.5f * f * (float)css.font_size);
            }
            case -7: {
                break;
            }
            case -8: {
                f *= css.getFontCache().getScreenResolution();
                break;
            }
            case -9: {
                f = f * css.getFontCache().getScreenResolution() / 2.54f;
                break;
            }
            case -10: {
                f = f * css.getFontCache().getScreenResolution() / 25.4f;
                break;
            }
            case -11: {
                f = f * css.getFontCache().getScreenResolution() / 72.0f;
                break;
            }
            case -12: {
                f = f * 12.0f * css.getFontCache().getScreenResolution() / 72.0f;
            }
        }
        float fInt = f * (float)zoom / 256.0f;
        if ((double)fInt > 0.01 && (double)fInt < 1.0) {
            fInt = 1.0f;
        }
        return Math.round(fInt);
    }

    private static int hexToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        return 0;
    }

    static Color getImageSelectionColor(Color selectionColor, boolean isV12) {
        if (isV12) {
            return new Color(selectionColor.getRed(), selectionColor.getGreen(), selectionColor.getBlue(), 120);
        }
        return new Color(128, 128, 255);
    }

    static String colorToString(Object o) {
        Color c = (Color)o;
        if (c == null) {
            return "";
        }
        return "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
    }

    static int cssCursorToAWT(int c) {
        switch (c) {
            case 23: {
                return 1;
            }
            case 24: {
                return 0;
            }
            case 25: {
                return 12;
            }
            case 26: {
                return 13;
            }
            case 27: {
                return 11;
            }
            case 28: {
                return 7;
            }
            case 29: {
                return 6;
            }
            case 30: {
                return 8;
            }
            case 31: {
                return 5;
            }
            case 32: {
                return 4;
            }
            case 33: {
                return 9;
            }
            case 34: {
                return 10;
            }
            case 35: {
                return 2;
            }
            case 36: {
                return 3;
            }
            case 37: {
                return -1;
            }
            case 159: {
                return 12;
            }
        }
        return -1;
    }

    static void drawStyledLine(Graphics g, int startx, int starty, int stopx, int stopy, int style, int width) {
        if (startx > stopx || starty > stopy) {
            int temp = startx;
            startx = stopx;
            stopx = temp;
            temp = starty;
            starty = stopy;
            stopy = temp;
        }
        if (width == 1) {
            CSSUtil.drawStyledLine(g, startx, starty, stopx, stopy, style);
        } else {
            switch (style) {
                case 168: {
                    if (!JavaVersion.IS_MAC_OS) {
                        g.setXORMode(Color.white);
                    }
                    int gap = 2 * width;
                    if (starty == stopy) {
                        for (int x = startx; x <= stopx; x += gap) {
                            if (x + width > stopx) {
                                width = stopx - x;
                            }
                            g.fillRect(x, starty, width, width);
                        }
                    } else if (startx == stopx) {
                        for (int y = starty; y <= stopy; y += gap) {
                            if (y + width > stopy) {
                                width = stopy - y;
                            }
                            g.fillRect(startx, y, width, width);
                        }
                    }
                    g.setPaintMode();
                    break;
                }
                case 148: {
                    int gap = 2 * width;
                    if (starty == stopy) {
                        for (int x = startx; x < stopx; x += gap) {
                            if (x + width > stopx) {
                                width = stopx - x;
                            }
                            g.fillRect(x, starty, width, width);
                        }
                    } else {
                        if (startx != stopx) break;
                        for (int y = starty; y < stopy; y += gap) {
                            if (y + width > stopy) {
                                width = stopy - y;
                            }
                            g.fillRect(startx, y, width, width);
                        }
                    }
                    break;
                }
                case 149: {
                    int len = 3 * width;
                    int gap = 2 * len;
                    if (starty == stopy) {
                        for (int x = startx; x < stopx; x += gap) {
                            if (x + len > stopx) {
                                len = stopx - x;
                            }
                            g.fillRect(x, starty, len, width);
                        }
                    } else {
                        if (startx != stopx) break;
                        for (int y = starty; y < stopy; y += gap) {
                            if (y + len > stopy) {
                                len = stopy - y;
                            }
                            g.fillRect(startx, y, width, len);
                        }
                    }
                    break;
                }
                default: {
                    CSSUtil.drawStyledLine(g, startx, starty, stopx, stopy, style);
                }
            }
        }
    }

    static void drawStyledLine(Graphics g, int startx, int starty, int stopx, int stopy, int style) {
        switch (style) {
            case 168: {
                if (!JavaVersion.IS_MAC_OS) {
                    g.setXORMode(Color.white);
                }
                if (starty == stopy) {
                    for (int x = startx + 1; x < stopx; x += 2) {
                        g.drawLine(x, starty, x, starty);
                    }
                } else if (startx == stopx) {
                    for (int y = starty + 1; y < stopy; y += 2) {
                        g.drawLine(startx, y, startx, y);
                    }
                }
                g.setPaintMode();
                break;
            }
            case 148: {
                if (starty == stopy) {
                    for (int x = startx; x < stopx; x += 2) {
                        g.drawLine(x, starty, x, starty);
                    }
                } else {
                    if (startx != stopx) break;
                    for (int y = starty; y < stopy; y += 2) {
                        g.drawLine(startx, y, startx, y);
                    }
                }
                break;
            }
            case 149: {
                if (starty == stopy) {
                    for (int x = startx; x < stopx; x += 6) {
                        int endx = x + 2;
                        if (endx > stopx - 1) {
                            endx = stopx - 1;
                        }
                        g.drawLine(x, starty, endx, starty);
                    }
                } else {
                    if (startx != stopx) break;
                    for (int y = starty; y < stopy; y += 6) {
                        int endy = y + 2;
                        if (endy > stopy - 1) {
                            endy = stopy - 1;
                        }
                        g.drawLine(startx, y, startx, endy);
                    }
                }
                break;
            }
            default: {
                g.drawLine(startx, starty, stopx, stopy);
            }
        }
    }
}

