/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.math.BigDecimal;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRCalculable;

class JRBigDecimalAverageIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRBigDecimalAverageIncrementer mainInstance = new JRBigDecimalAverageIncrementer();

    private JRBigDecimalAverageIncrementer() {
    }

    public static JRBigDecimalAverageIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        if (expressionValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return variable.getValue();
        }
        BigDecimal countValue = (BigDecimal)valueProvider.getValue(variable.getHelperVariable((byte)0));
        BigDecimal sumValue = (BigDecimal)valueProvider.getValue(variable.getHelperVariable((byte)1));
        return sumValue.divide(countValue, 4);
    }

    @Override
    public Object initialValue(JRCalculable variable) {
        if (variable.getValue() == null) {
            return JRBigDecimalIncrementerFactory.ZERO;
        }
        return (BigDecimal)variable.getValue();
    }
}

