/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRBaseSubreport
extends JRBaseElement
implements JRSubreport {
    private static final long serialVersionUID = 10200L;
    protected Boolean isUsingCache = null;
    protected JRExpression parametersMapExpression = null;
    protected JRSubreportParameter[] parameters = null;
    protected JRExpression connectionExpression = null;
    protected JRExpression dataSourceExpression = null;
    protected JRExpression expression = null;
    protected JRSubreportReturnValue[] returnValues = null;
    protected Map subreportQueries;
    protected Map subreportStyles;

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    protected JRBaseSubreport(JRSubreport subreport, JRBaseObjectFactory factory) {
        super(subreport, factory);
        this.isUsingCache = subreport.isOwnUsingCache();
        this.parametersMapExpression = factory.getExpression(subreport.getParametersMapExpression());
        JRSubreportParameter[] jrSubreportParameters = subreport.getParameters();
        if (jrSubreportParameters != null && jrSubreportParameters.length > 0) {
            this.parameters = new JRSubreportParameter[jrSubreportParameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = factory.getSubreportParameter(jrSubreportParameters[i]);
            }
        }
        this.connectionExpression = factory.getExpression(subreport.getConnectionExpression());
        this.dataSourceExpression = factory.getExpression(subreport.getDataSourceExpression());
        JRSubreportReturnValue[] subrepReturnValues = subreport.getReturnValues();
        if (subrepReturnValues != null && subrepReturnValues.length > 0) {
            this.returnValues = new JRSubreportReturnValue[subrepReturnValues.length];
            for (int i = 0; i < subrepReturnValues.length; ++i) {
                this.returnValues[i] = factory.getSubreportReturnValue(subrepReturnValues[i]);
            }
        }
        this.expression = factory.getExpression(subreport.getExpression());
    }

    @Override
    public boolean isUsingCache() {
        if (this.isUsingCache == null) {
            JRExpression subreportExpression = this.getExpression();
            if (subreportExpression != null) {
                return String.class.getName().equals(subreportExpression.getValueClassName());
            }
            return true;
        }
        return this.isUsingCache;
    }

    @Override
    public void setUsingCache(boolean isUsingCache) {
        this.setUsingCache(isUsingCache ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    @Override
    public JRSubreportParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    @Override
    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getSubreport(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void writeXml(JRXmlWriter xmlWriter) throws IOException {
        xmlWriter.writeSubreport(this);
    }

    @Override
    public JRSubreportReturnValue[] getReturnValues() {
        return this.returnValues;
    }

    @Override
    public Boolean isOwnUsingCache() {
        return this.isUsingCache;
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
        this.isUsingCache = isUsingCache;
    }

    @Override
    public ResultSet getQuery() {
        if (this.subreportQueries != null) {
            return (ResultSet)this.subreportQueries.get(this.key);
        }
        return null;
    }

    @Override
    public void setSubreportQueries(Map srQueries) {
        this.subreportQueries = srQueries;
    }

    @Override
    public Map getSubreportQueries() {
        return this.subreportQueries;
    }

    @Override
    public void setSubreportStyles(Map srStyles) {
        this.subreportStyles = srStyles;
    }

    @Override
    public Map getSubreportStyles() {
        return this.subreportStyles;
    }
}

