/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JRBaseField
implements JRField,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String name = null;
    protected String description = null;
    protected String valueClassName = String.class.getName();
    protected transient Class valueClass = null;

    protected JRBaseField() {
    }

    protected JRBaseField(JRField field, JRBaseObjectFactory factory) {
        factory.put(field, this);
        this.name = field.getName();
        this.description = field.getDescription();
        this.valueClassName = field.getValueClassName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Class getValueClass() {
        if (this.valueClass == null && this.valueClassName != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(this.valueClassName);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.valueClass;
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }
}

