/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.util;

import java.io.IOException;
import java.io.OutputStream;
import macromedia.sequelink.util.UtilMessage;

public class OutputStreamOnByteArray
extends OutputStream {
    protected byte[] array;
    protected int begin;
    protected int end;
    protected int position;

    public OutputStreamOnByteArray(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public OutputStreamOnByteArray(byte[] byArray, int n, int n2) {
        this.array = byArray;
        this.begin = n;
        this.end = n2;
        this.position = n;
    }

    public final void write(int n) throws IOException {
        if (this.position >= this.end) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.ba.oob"));
        }
        this.array[this.position++] = (byte)n;
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        int n3 = this.position + n2 > this.end ? this.end - this.position : n2;
        System.arraycopy(byArray, n, this.array, this.position, n3);
        this.position += n3;
        if (n3 < n2) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.ba.oob"));
        }
    }

    public final void reset() {
        this.position = this.begin;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) throws IOException {
        if (n < this.begin) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.ba.oob"));
        }
        if (n > this.end) {
            throw new IOException(UtilMessage.Gen.getPrefixedMessage("err.ba.oob"));
        }
        this.position = n;
    }

    public final int getFreeSpace() {
        return this.end - this.position;
    }

    public final int size() {
        return this.position - this.begin;
    }
}

