/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.ssp;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import macromedia.sequelink.net.NetInputStream;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.SlXid;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;

public class SspInputStreamOnDataInputStream
extends SspInputStream {
    private DataInputStream dis;
    private NetInputStream nis;
    private char[] charBuf = new char[80];
    private boolean newByte;
    private int buf;
    private UtilTransliterator transliterator;
    private static byte[] sl = new byte[]{83, 101, 113, 117, 101, 76, 105, 110, 107};

    public UtilTransliterator getTransliterator() {
        return this.transliterator;
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }

    public void setInputStream(NetInputStream netInputStream) {
        this.nis = netInputStream;
        this.dis = new DataInputStream(netInputStream);
    }

    public int readSSPInt8() throws IOException {
        int n = this.nis.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    public int readSSPInt16() throws IOException {
        return this.dis.readShort();
    }

    public int readSSPFullInt32() throws IOException {
        return this.dis.readInt();
    }

    public int readSSPInt32() throws IOException {
        int n = this.nis.read();
        if (n == -1) {
            throw new EOFException();
        }
        if (n != 128) {
            return (byte)n;
        }
        return this.dis.readInt();
    }

    public int readSSPUInt32() throws IOException {
        int n = this.nis.read();
        if (n == -1) {
            throw new EOFException();
        }
        if (n != 255) {
            return n;
        }
        return this.dis.readInt();
    }

    public int readSSPIndicator() throws IOException {
        return this.readSSPInt32();
    }

    public int readSSPEnum() throws IOException {
        return this.readSSPInt32();
    }

    public int readSSPErr() throws IOException {
        return this.readSSPFullInt32();
    }

    public int readSSPRefNum() throws IOException {
        return this.readSSPUInt32();
    }

    public int readSSPRowCount(boolean bl) throws IOException {
        int n = bl ? this.readSSPInt32() : this.readSSPFullInt32();
        return n == -1 ? 0 : n;
    }

    public String readSSPString() throws IOException, UtilException {
        byte[] byArray;
        int n = this.readSSPUInt32();
        byte[] byArray2 = n > (byArray = this.transliterator.getBytesCache()).length ? new byte[n] : byArray;
        int n2 = this.nis.read(byArray2, 0, n);
        return this.transliterator.decode(byArray2, 0, n2);
    }

    public String readSSPString(int n) throws IOException, UtilException {
        byte[] byArray;
        int n2 = this.readSSPUInt32();
        byte[] byArray2 = n2 > (byArray = this.transliterator.getBytesCache()).length ? new byte[n2] : byArray;
        int n3 = this.nis.read(byArray2, 0, n2);
        return this.transliterator.decode(byArray2, 0, n3, n);
    }

    private byte readNibble() throws IOException {
        if (this.newByte) {
            this.buf = this.nis.read();
            if (this.buf == -1) {
                throw new EOFException();
            }
        }
        int n = this.buf;
        if (this.newByte) {
            n >>= 4;
        }
        this.newByte = !this.newByte;
        return (byte)(n &= 0xF);
    }

    public BigDecimal readSSPBcdType(int n) throws IOException {
        int n2;
        int n3;
        this.newByte = true;
        int n4 = this.nis.read();
        if (n4 == -1) {
            throw new EOFException();
        }
        int n5 = this.nis.read();
        if (n5 == -1) {
            throw new EOFException();
        }
        n5 = (byte)(n5 & 0xFF);
        int n6 = n4 + 1;
        int n7 = 0;
        if (n >= 0) {
            n6 += n - n5;
            n7 = n;
        } else if (n5 <= 0) {
            n6 -= n5;
        } else {
            n7 = n5;
        }
        if (n6 > this.charBuf.length) {
            this.charBuf = new char[n6];
        }
        if ((n4 & 1) == 0 && this.readNibble() != 0) {
            throw new IOException();
        }
        int n8 = n4 + 1;
        for (n3 = 1; n3 < n8; ++n3) {
            this.charBuf[n3] = (char)(this.readNibble() + 48);
        }
        while (n3 < n6) {
            this.charBuf[n3] = 48;
            ++n3;
        }
        byte by = this.readNibble();
        if (by == 13) {
            this.charBuf[0] = 45;
            n2 = 0;
            if (n6 < n4 + 1) {
                n6 = n4 + 1;
            }
        } else {
            if (--n6 < n4) {
                n6 = n4;
            }
            n2 = 1;
        }
        String string = new String(this.charBuf, n2, n6);
        return new BigDecimal(new BigInteger(string), n7);
    }

    public byte[] readSSPBinaryType() throws IOException {
        int n = this.dis.readInt();
        byte[] byArray = new byte[n];
        this.nis.read(byArray);
        return byArray;
    }

    public byte[] readSSPBinaryType(int n) throws IOException {
        int n2 = this.dis.readInt();
        if (n < n2) {
            n = n2;
        }
        byte[] byArray = new byte[n];
        this.nis.read(byArray, 0, n2);
        while (n2 < n) {
            byArray[n2++] = 0;
        }
        return byArray;
    }

    public double readSSPFloatType() throws IOException {
        return this.dis.readDouble();
    }

    public float readSSPRealType() throws IOException {
        return this.dis.readFloat();
    }

    public SlXid readXid() throws IOException {
        int n = this.readSSPFullInt32();
        byte[] byArray = new byte[this.readSSPInt32()];
        byte[] byArray2 = new byte[this.readSSPInt32()];
        this.nis.read(byArray);
        this.nis.read(byArray2);
        return new SlXid(n, byArray, byArray2);
    }

    public void readSequeLink() throws IOException, SQLException {
        int n = sl.length;
        byte[] byArray = new byte[n];
        int n2 = this.nis.read(byArray);
        if (n2 != n) {
            throw Message.Gen.getSqlException(7427);
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == sl[i]) continue;
            throw Message.Gen.getSqlException(7427);
        }
    }

    public String readSSPASCIIString() throws IOException {
        int n = this.readSSPFullInt32();
        if (n > this.charBuf.length) {
            this.charBuf = new char[n];
        }
        for (int i = 0; i < n; ++i) {
            this.charBuf[i] = (char)(this.dis.readByte() & 0xFF);
        }
        return new String(this.charBuf, 0, n);
    }

    public void skipBytes(int n) throws IOException, SQLException {
        if (this.dis.skipBytes(n) != n) {
            throw Message.Gen.getSqlException(7428);
        }
    }

    public int readSSPLongVarBinary(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.readSSPFullInt32();
        this.nis.read(byArray, n, n3);
        return n3;
    }

    public int readSSPLongVarChar(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.readSSPUInt32();
        this.nis.read(byArray, n, n3);
        return n3;
    }
}

