/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.ssp;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import macromedia.sequelink.auth.MGSSHandle;
import macromedia.sequelink.auth.MGSSToken;
import macromedia.sequelink.describe.VariableDescriptor;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.net.Session;
import macromedia.sequelink.ssp.AttribList;
import macromedia.sequelink.ssp.Chain;
import macromedia.sequelink.ssp.CodecAdmin;
import macromedia.sequelink.ssp.CodecAssociate;
import macromedia.sequelink.ssp.CodecAuthenticate;
import macromedia.sequelink.ssp.CodecChainedPacket;
import macromedia.sequelink.ssp.CodecDefineDescribe;
import macromedia.sequelink.ssp.CodecExec;
import macromedia.sequelink.ssp.CodecExecDirect;
import macromedia.sequelink.ssp.CodecExecRsn;
import macromedia.sequelink.ssp.CodecExtendedDefine;
import macromedia.sequelink.ssp.CodecFetch;
import macromedia.sequelink.ssp.CodecFreeVariables;
import macromedia.sequelink.ssp.CodecGetDescribe;
import macromedia.sequelink.ssp.CodecGetSettings;
import macromedia.sequelink.ssp.CodecLogon;
import macromedia.sequelink.ssp.CodecNImmediate;
import macromedia.sequelink.ssp.CodecNextResult;
import macromedia.sequelink.ssp.CodecOpen;
import macromedia.sequelink.ssp.CodecPartialBind;
import macromedia.sequelink.ssp.CodecPartialFetch;
import macromedia.sequelink.ssp.CodecSetGetSettings;
import macromedia.sequelink.ssp.CodecSetSettings;
import macromedia.sequelink.ssp.CodecXaRecover;
import macromedia.sequelink.ssp.CodecXaXainfo;
import macromedia.sequelink.ssp.CodecXaXid;
import macromedia.sequelink.ssp.GetSetting;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.SetGetSetting;
import macromedia.sequelink.ssp.SetSetting;
import macromedia.sequelink.ssp.SlXid;
import macromedia.sequelink.ssp.Ssp;
import macromedia.sequelink.ssp.SspContext;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.sequelink.ssp.SspOutputStream;
import macromedia.sequelink.ssp.SspStreamFactory;
import macromedia.sequelink.util.UnSyncVector;
import macromedia.sequelink.variables.CursorVariables;
import macromedia.sequelink.variables.StreamVariable;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;

public class Ssp7
extends Ssp {
    private Session netSession;
    private int serverVersion;
    private SspInputStream sis;
    private SspOutputStream sos;
    private UtilTransliterator transliterator;
    private UtilTransliterator asciiTransliterator;
    private HashMap transliteratorCache;
    private int transliterationWorkaroundClient;
    private int transliterationWorkaroundServer;
    private static Vector preventGarbageCollection = new Vector();

    Ssp7(Session session, String string, int n, UtilTransliterator utilTransliterator) throws SQLException {
        UtilTransliterator utilTransliterator2;
        this.netSession = session;
        this.serverVersion = n;
        this.transliteratorCache = new HashMap();
        this.asciiTransliterator = utilTransliterator;
        this.transliteratorCache.put("ASCII", utilTransliterator);
        if (!"ASCII".equals(string)) {
            try {
                utilTransliterator2 = UtilTransliterator.GetNewTransliterator(string);
            }
            catch (UtilException utilException) {
                SQLException sQLException = Message.Gen.getSqlException(7452);
                Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
                throw sQLException;
            }
            this.transliteratorCache.put(string, utilTransliterator2);
        } else {
            utilTransliterator2 = utilTransliterator;
        }
        this.sis = SspStreamFactory.GetInputStream();
        this.sos = SspStreamFactory.GetOutputStream();
        this.setDefaultTransliterator(utilTransliterator2);
        preventGarbageCollection.addElement(this);
    }

    public int getSspVersion() {
        return 7;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public void close() throws SQLException {
        try {
            preventGarbageCollection.removeElement(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.netSession.detach();
        }
        catch (NetworkException networkException) {
            throw networkException.toSqlException();
        }
    }

    public Session getNetworkSession() {
        return this.netSession;
    }

    public SspInputStream getSspInputStream() {
        return this.sis;
    }

    public SspOutputStream getSspOutputStream() {
        return this.sos;
    }

    public boolean supportsCancel() {
        return this.netSession.getCancelOption();
    }

    public void cancel() throws SQLException {
        try {
            this.netSession.cancel();
        }
        catch (NetworkException networkException) {
            // empty catch block
        }
    }

    public Chain getChain() {
        return new Chain(this, this.getSspVersion());
    }

    public CodecAdmin getCodecAdmin(SspContext sspContext, UnSyncVector unSyncVector) {
        return new CodecAdmin(sspContext, unSyncVector);
    }

    public CodecAssociate getCodecAssociate(String string, SspContext sspContext) {
        return new CodecAssociate(string, sspContext);
    }

    public CodecChainedPacket getCodecClose(SspContext sspContext) {
        return this.getCodec(3, sspContext);
    }

    public CodecChainedPacket getCodecCloseCursor(SspContext sspContext) {
        return this.getCodec(4, sspContext);
    }

    public CodecChainedPacket getCodecCommit(SspContext sspContext) {
        return this.getCodec(5, sspContext);
    }

    public CodecDefineDescribe getCodecDefineDescribeCursor(VariableDescriptor[] variableDescriptorArray, SspContext sspContext) {
        return new CodecDefineDescribe(6, variableDescriptorArray, sspContext);
    }

    public CodecDefineDescribe getCodecDefineDescribeParam(VariableDescriptor[] variableDescriptorArray, SspContext sspContext) {
        throw new InternalError(this.getClass().getName() + " getCodecDefineDescribeParam");
    }

    public CodecExec getCodecExec(SspContext sspContext, UnSyncVector unSyncVector, UnSyncVector unSyncVector2) {
        return new CodecExec(sspContext, unSyncVector, unSyncVector2);
    }

    public CodecExecDirect getCodecExecDirect(String string, SspContext sspContext, UnSyncVector unSyncVector, UnSyncVector unSyncVector2) {
        return new CodecExecDirect(string, sspContext, unSyncVector, unSyncVector2);
    }

    public CodecExecRsn getCodecExecRsn(SspContext sspContext, int n, UnSyncVector unSyncVector, UnSyncVector unSyncVector2) {
        return new CodecExecRsn(sspContext, n, unSyncVector, unSyncVector2);
    }

    public CodecExtendedDefine getCodecExtendedDefine(UnSyncVector unSyncVector, SspContext sspContext) {
        return new CodecExtendedDefine(unSyncVector, sspContext);
    }

    public CodecFetch getCodecFetch(int n, CursorVariables cursorVariables, UnSyncVector unSyncVector, SspContext sspContext) {
        return new CodecFetch(n, cursorVariables, unSyncVector, sspContext);
    }

    public CodecFreeVariables getCodecFreeVariables(int n, SspContext sspContext) {
        return new CodecFreeVariables(n, sspContext);
    }

    public CodecGetDescribe getCodecGetDescribeCursor(VariableDescriptor[] variableDescriptorArray, SspContext sspContext) {
        return new CodecGetDescribe(10, variableDescriptorArray, sspContext);
    }

    public CodecGetDescribe getCodecGetDescribeParam(VariableDescriptor[] variableDescriptorArray, SspContext sspContext) {
        throw new InternalError(this.getClass().getName() + " getCodecGetDescribeParam");
    }

    public CodecGetSettings getCodecGetSettings(GetSetting[] getSettingArray, SspContext sspContext) {
        return new CodecGetSettings(getSettingArray, sspContext);
    }

    public CodecChainedPacket getCodecLogoff(SspContext sspContext) {
        return this.getCodec(13, sspContext);
    }

    public CodecLogon getCodecLogon(AttribList attribList, SspContext sspContext) {
        return new CodecLogon(attribList, sspContext);
    }

    public CodecNextResult getCodecNextResult(SspContext sspContext, UnSyncVector unSyncVector) {
        return new CodecNextResult(sspContext, unSyncVector);
    }

    public CodecNImmediate getCodecNImmediate(UnSyncVector unSyncVector, SspContext sspContext) {
        return new CodecNImmediate(unSyncVector, sspContext);
    }

    public CodecOpen getCodecOpen(int n, SspContext sspContext) {
        return new CodecOpen(n, sspContext);
    }

    public CodecPartialBind getCodecPartialBind(StreamVariable streamVariable, SspContext sspContext) {
        return new CodecPartialBind(streamVariable, sspContext);
    }

    public CodecPartialFetch getCodecPartialFetch(StreamVariable streamVariable, SspContext sspContext) {
        return new CodecPartialFetch(streamVariable, sspContext);
    }

    public CodecChainedPacket getCodecRollback(SspContext sspContext) {
        return this.getCodec(20, sspContext);
    }

    public CodecChainedPacket getCodecSetGetSettings(SetGetSetting[] setGetSettingArray, SspContext sspContext) {
        return new CodecSetGetSettings(setGetSettingArray, sspContext);
    }

    public CodecChainedPacket getCodecSetSettings(SetSetting[] setSettingArray, SspContext sspContext) {
        return new CodecSetSettings(setSettingArray, sspContext);
    }

    public CodecXaXainfo getCodecXaOpen(SspContext sspContext) {
        return new CodecXaXainfo(21, sspContext);
    }

    public CodecXaXainfo getCodecXaClose(SspContext sspContext) {
        return new CodecXaXainfo(22, sspContext);
    }

    public CodecXaXid getCodecXaStart(SspContext sspContext, SlXid slXid, int n) {
        return new CodecXaXid(23, sspContext, slXid, n);
    }

    public CodecXaXid getCodecXaEnd(SspContext sspContext, SlXid slXid, int n) {
        return new CodecXaXid(27, sspContext, slXid, n);
    }

    public CodecXaXid getCodecXaPrepare(SspContext sspContext, SlXid slXid) {
        return new CodecXaXid(24, sspContext, slXid, 0);
    }

    public CodecXaXid getCodecXaCommit(SspContext sspContext, SlXid slXid, int n) {
        return new CodecXaXid(25, sspContext, slXid, n);
    }

    public CodecXaXid getCodecXaRollback(SspContext sspContext, SlXid slXid) {
        return new CodecXaXid(26, sspContext, slXid, 0);
    }

    public CodecXaXid getCodecXaForget(SspContext sspContext, SlXid slXid) {
        return new CodecXaXid(29, sspContext, slXid, 0);
    }

    public CodecXaRecover getCodecXaRecover(SspContext sspContext, int n) {
        return new CodecXaRecover(28, sspContext, n);
    }

    public CodecAuthenticate getCodecAuthenticate(SspContext sspContext, MGSSHandle mGSSHandle, MGSSToken mGSSToken, int n) {
        return new CodecAuthenticate(sspContext, mGSSHandle, mGSSToken, n);
    }

    public UtilTransliterator getDefaultTransliterator() {
        return this.transliterator;
    }

    public UtilTransliterator getAsciiTransliterator() {
        return this.asciiTransliterator;
    }

    public UtilTransliterator getTransliterator(String string) throws SQLException {
        UtilTransliterator utilTransliterator = (UtilTransliterator)this.transliteratorCache.get(string);
        if (utilTransliterator == null) {
            try {
                utilTransliterator = UtilTransliterator.GetNewTransliterator(string, this.transliterationWorkaroundClient, this.transliterationWorkaroundServer);
                this.transliteratorCache.put(string, utilTransliterator);
            }
            catch (UtilException utilException) {
                SQLException sQLException = Message.Gen.getSqlException(7452);
                Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
                throw sQLException;
            }
        }
        return utilTransliterator;
    }

    public void applyTransliterationWorkarounds() throws SQLException {
        if (this.transliterationWorkaroundClient == 0) {
            this.transliterationWorkaroundServer = 0;
            return;
        }
        if (this.transliterationWorkaroundServer == 0) {
            this.transliterationWorkaroundClient = 0;
            return;
        }
        if (this.transliterationWorkaroundClient == this.transliterationWorkaroundServer) {
            this.transliterationWorkaroundClient = 0;
            this.transliterationWorkaroundServer = 0;
            return;
        }
        HashMap hashMap = this.transliteratorCache;
        this.transliteratorCache = new HashMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            UtilTransliterator utilTransliterator;
            String string = (String)iterator.next();
            UtilTransliterator utilTransliterator2 = (UtilTransliterator)hashMap.get(string);
            if (string.equals("ASCII")) {
                utilTransliterator = utilTransliterator2;
            } else {
                if (string.equals("")) continue;
                try {
                    utilTransliterator = UtilTransliterator.GetNewTransliterator(string, this.transliterationWorkaroundClient, this.transliterationWorkaroundServer);
                }
                catch (UtilException utilException) {
                    SQLException sQLException = Message.Gen.getSqlException(7452);
                    Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
                    throw sQLException;
                }
            }
            this.transliteratorCache.put(string, utilTransliterator);
            if (utilTransliterator2 != this.transliterator) continue;
            this.transliterator = utilTransliterator;
            this.transliteratorCache.put("", utilTransliterator);
        }
    }

    public byte[] transliterate(String string) throws SQLException {
        try {
            return this.transliterator.encode(string);
        }
        catch (UtilException utilException) {
            SQLException sQLException = Message.Gen.getSqlException(7452);
            Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
            throw sQLException;
        }
        catch (NullPointerException nullPointerException) {
            throw Message.Gen.getSqlException(7398);
        }
    }

    public void setTransliterationWorkaroundServer(int n) {
        this.transliterationWorkaroundServer = n;
    }

    public void setTransliterationWorkaroundClient(int n) {
        this.transliterationWorkaroundClient = n;
    }

    protected CodecChainedPacket getCodec(int n, SspContext sspContext) {
        return new CodecChainedPacket(n, sspContext);
    }

    void setDefaultTransliterator(UtilTransliterator utilTransliterator) {
        this.transliteratorCache.remove("");
        this.transliterator = utilTransliterator;
        this.transliteratorCache.put("", utilTransliterator);
        this.sis.setTransliterator(utilTransliterator);
        this.sos.setTransliterator(utilTransliterator);
    }
}

