/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.ssp;

import java.io.IOException;
import java.util.Enumeration;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.sequelink.ssp.SspOutputStream;
import macromedia.sequelink.util.UnSyncVector;
import macromedia.slutil.UtilException;

public class AttribList {
    static final int kSWAN_ATTRIB_STRINGENCR = 0;
    static final int kSWAN_ATTRIB_INTEGER = 3;
    static final int kSWAN_ATTRIB_STRING = 4;
    static final int kSWAN_ATTRIB_BOOLEAN = 12;
    UnSyncVector attributes = new UnSyncVector();

    public void addInteger(int n, int n2) {
        Attribute attribute = new Attribute(n, 3, new Integer(n2));
        this.attributes.addElement(attribute);
    }

    public void addBoolean(int n, boolean bl) {
        Attribute attribute = new Attribute(n, 12, new Boolean(bl));
        this.attributes.addElement(attribute);
    }

    public void addString(int n, String string) {
        Attribute attribute = new Attribute(n, 4, string);
        this.attributes.addElement(attribute);
    }

    public void addStringEncrypted(int n, String string) {
        Attribute attribute = new Attribute(n, 0, string);
        this.attributes.addElement(attribute);
    }

    public void encode(SspOutputStream sspOutputStream) throws IOException, UtilException {
        int n = this.attributes.size();
        sspOutputStream.writeSSPFullInt32(n);
        for (int i = 0; i < n; ++i) {
            Attribute attribute = (Attribute)this.attributes.elementAt(i);
            attribute.encode(sspOutputStream);
        }
    }

    public void decode(SspInputStream sspInputStream) throws IOException, UtilException {
        int n = sspInputStream.readSSPFullInt32();
        this.attributes.removeAllElements();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = new Attribute();
            attribute.decode(sspInputStream);
            this.attributes.addElement(attribute);
        }
    }

    public boolean checkPair(int n, Object object) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.key != n || !attribute.value.equals(object)) continue;
            return true;
        }
        return false;
    }

    public String getStringValue(int n) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.key != n) continue;
            return (String)attribute.value;
        }
        return null;
    }

    public Integer getIntegerValue(int n) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.key != n) continue;
            return (Integer)attribute.value;
        }
        return null;
    }

    public Boolean getBooleanValue(int n) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.key != n) continue;
            return (Boolean)attribute.value;
        }
        return null;
    }

    public Object[] getValues(int n) {
        UnSyncVector unSyncVector = new UnSyncVector();
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.key != n) continue;
            unSyncVector.addElement(attribute.value);
        }
        int n2 = unSyncVector.size();
        if (n2 > 0) {
            Object[] objectArray = new Object[n2];
            unSyncVector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public String[] getStringValues(int n) {
        UnSyncVector unSyncVector = new UnSyncVector();
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.key != n) continue;
            unSyncVector.addElement(attribute.value);
        }
        int n2 = unSyncVector.size();
        if (n2 > 0) {
            Object[] objectArray = new String[n2];
            unSyncVector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    class Attribute {
        int key;
        int type;
        Object value;

        Attribute() {
        }

        Attribute(int n, int n2, Object object) {
            this.key = n;
            this.type = n2;
            this.value = object;
        }

        void encode(SspOutputStream sspOutputStream) throws IOException, UtilException {
            sspOutputStream.writeSSPInt32(this.key);
            switch (this.type) {
                case 3: {
                    sspOutputStream.writeSSPInt32(this.type);
                    sspOutputStream.writeSSPFullInt32((Integer)this.value);
                    break;
                }
                case 4: {
                    sspOutputStream.writeSSPInt32(this.type);
                    sspOutputStream.writeSSPString((String)this.value);
                    break;
                }
                case 0: {
                    sspOutputStream.writeSSPInt32(4);
                    sspOutputStream.writeSSPCipherString((String)this.value);
                    break;
                }
                case 12: {
                    sspOutputStream.writeSSPInt32(this.type);
                    if (((Boolean)this.value).booleanValue()) {
                        sspOutputStream.writeSSPInt8(1);
                        break;
                    }
                    sspOutputStream.writeSSPInt8(0);
                    break;
                }
                default: {
                    throw new IOException(Message.Gen.getPrefixedMessage("msg.attrib.invalid"));
                }
            }
        }

        void decode(SspInputStream sspInputStream) throws IOException, UtilException {
            this.key = sspInputStream.readSSPInt32();
            this.type = sspInputStream.readSSPInt32();
            switch (this.type) {
                case 3: {
                    this.value = new Integer(sspInputStream.readSSPFullInt32());
                    break;
                }
                case 4: {
                    this.value = sspInputStream.readSSPString();
                    break;
                }
                case 12: {
                    if (sspInputStream.readSSPInt8() != 0) {
                        this.value = new Boolean(true);
                        break;
                    }
                    this.value = new Boolean(false);
                    break;
                }
                default: {
                    throw new IOException(Message.Gen.getPrefixedMessage("msg.attrib.invalid"));
                }
            }
        }
    }
}

