/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import macromedia.sequelink.net.IIOP;
import macromedia.sequelink.net.IIOPDecoder;
import macromedia.sequelink.net.IIOPFormat;
import macromedia.sequelink.net.IIOPReply;
import macromedia.sequelink.net.IIOPReplyDecoder;
import macromedia.sequelink.net.IIOPRequest;
import macromedia.sequelink.net.NetAttributes;
import macromedia.sequelink.net.NetByteOrder;
import macromedia.sequelink.net.NetCrypto;
import macromedia.sequelink.net.NetInputStream;
import macromedia.sequelink.net.NetMessage;
import macromedia.sequelink.net.NetOutputStream;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.net.SPDU;
import macromedia.sequelink.net.SPDUAccept;
import macromedia.sequelink.net.SPDUAcceptDecoder;
import macromedia.sequelink.net.SPDUConnect;
import macromedia.sequelink.net.SPDUConnectEncoder;
import macromedia.sequelink.net.SPDUDecoder;
import macromedia.sequelink.net.SPDUEncoder;
import macromedia.sequelink.net.SPDUExcRpt;
import macromedia.sequelink.net.SPDUExcRptDecoder;
import macromedia.sequelink.net.SPDUExpData;
import macromedia.sequelink.net.SPDUExpDataDecoder;
import macromedia.sequelink.net.SPDUExpDataEncoder;
import macromedia.sequelink.net.SPDUFormat;
import macromedia.sequelink.net.SPDUPAbort;
import macromedia.sequelink.net.SPDUPAbortDecoder;
import macromedia.sequelink.net.SPDURefuse;
import macromedia.sequelink.net.SPDURefuseDecoder;
import macromedia.sequelink.net.TrEndPoint;
import macromedia.sequelink.util.BufferManager;
import macromedia.sequelink.util.InputStreamOnByteArray;
import macromedia.sequelink.util.OutputStreamOnByteArray;

public class Session {
    public static final int kSESSION_ABSRC_REMOTE = 1;
    public static final int kSESSION_ABSRC_LOCAL = 2;
    public static final int kSESSION_ABSRC_TRANSPORT = 3;
    public static final int kSESSION_ABSRC_USER = 4;
    public static final int kSESSION_ABSRC_SERVICE = 5;
    public static final int kSESSION_ABSRC_REFUSE = 6;
    public static final int kSESSION_ABR_NOREASON = 1;
    public static final int kSESSION_ABR_PROTOCOL = 2;
    public static final int kSESSION_ABR_BUFMGR = 3;
    public static final int kSESSION_ABR_KILL = 4;
    public static final int kSESSION_ABR_SHUTDOWN = 5;
    public static final int kSESSION_ABR_SPAWN = 6;
    public static final int kSESSION_ABR_TDIS = 7;
    public static final int kSESSION_ABR_ADDRNOTAVAIL = 8;
    public static final int kSESSION_ABR_HOSTUNREACH = 9;
    public static final int kSESSION_ABR_NETUNREACH = 10;
    public static final int kSESSION_ABR_NETDOWN = 11;
    public static final int kSESSION_ABR_NOBUFS = 12;
    public static final int kSESSION_ABR_CONNREFUSED = 13;
    public static final int kSESSION_ABR_ADDRINUSE = 14;
    public static final int kSESSION_ABR_TIMEDOUT = 15;
    public static final int kSESSION_ABR_TREPLIMIT = 16;
    public static final int kSESSION_ABR_TIMEOUT = 17;
    public static final int kSESSION_ABR_MEM = 18;
    public static final int kSESSION_ABR_TRMGRLOAD = 19;
    public static final int kSESSION_ABR_CONNRESET = 20;
    public static final int kSESSION_ABR_NETWORK = 21;
    public static final int kSESSION_ABR_INTERNAL = 22;
    public static final int kSESSION_ABR_LBLANKS = 23;
    public static final int kSESSION_ABR_TBLANKS = 24;
    public static final int kSESSION_ABR_BLANKS = 25;
    public static final int kSESSION_ABR_RANGE = 26;
    public static final int kSESSION_ABR_FORMAT = 27;
    public static final int kSESSION_ABR_NOSEP = 28;
    public static final int kSESSION_ABR_NUMSEP = 29;
    public static final int kSESSION_ABR_FSEP = 30;
    public static final int kSESSION_ABR_LSEP = 31;
    public static final int kSESSION_ABR_MAXVAL = 32;
    public static final int kSESSION_ABR_NUM = 33;
    public static final int kSESSION_ABR_NEG = 34;
    public static final int kSESSION_ABR_ZERO = 35;
    public static final int kSESSION_ABR_MAXLEN = 36;
    public static final int kSESSION_ABR_ZEROLEN = 37;
    public static final int kSESSION_ABR_MINLEN = 38;
    public static final int kSESSION_ABR_TRPOLL = 39;
    public static final int kSESSION_ABR_LOADLIMIT = 40;
    public static final int kSESSION_ABR_MAXSESSIONS = 41;
    public static final int kSESSION_ABR_USER = 42;
    public static final int kSESSION_ABR_SPDU = 43;
    public static final int kSESSION_ABR_KEY = 44;
    public static final int kSESSION_ABR_IDLE = 45;
    public static final int kSESSION_ABR_HOSTLKUP = 46;
    public static final int kSESSION_ABR_SERVICELKUP = 47;
    public static final int kSESSION_ABR_CRASH = 48;
    public static final int kSESSION_ABR_CONV = 49;
    public static final int kSESSION_ABR_USEREXCPT = 50;
    public static final int kSESSION_ABR_SYSTEMEXCPT = 51;
    public static final int kSESSION_ABR_MSGERROR = 52;
    public static final int kSESSION_ABR_NOTC = 53;
    public static final int kSESSION_ABR_ENCRYPT = 54;
    public static final int kSESSION_ABR_DECRYPT = 55;
    public static final int kSESSION_ABR_OBJECTKEY = 56;
    public static final int kSESSION_ABR_OPERATION = 57;
    public static final int kSESSION_ABR_RPC = 58;
    public static final int kSESSION_ABR_PORT = 59;
    public static final int kSESSION_ABR_SOCKET = 60;
    public static final int kSESSION_ABR_STREAM = 61;
    public static final int kSESSION_ABR_UNKNOWN = 62;
    public static final int kSESSION_ABR_SSLHANDSHAKE = 63;
    public static final int kSESSION_ABR_CIPHERSUITE = 64;
    private static final int kSta01 = 1;
    private static final int kSta01B = 2;
    private static final int kSta02A = 3;
    private static final int kSta713 = 4;
    private static final int kSta03 = 5;
    private static final int kSta16 = 6;
    private static final int kStaClosed = 7;
    private static final int kStaAborted = 8;
    private static final int kSta19 = 9;
    private static final int kTCONcnf = 1;
    private static final int kTDISind = 2;
    private static final int kSUABind = 3;
    private static final int kSPABind = 4;
    private static final int kSABNRind = 5;
    private static final int kSCONind = 6;
    private static final int kSCONpos_cnf = 7;
    private static final int kSCONneg_cnf = 8;
    private static final int kSNDind = 9;
    private static final int kSTDind = 10;
    private static final int kSEDind = 11;
    private static final int kSPTind = 13;
    private static final int kSRELind = 14;
    private static final int kSRELpos_cnf = 15;
    private static final int kSNDGTind = 17;
    private static final int kSUERind = 18;
    private static final int kSPERind = 19;
    private static final int kTIMind = 20;
    private static final int kINTERNAL_BUFSIZE = 1024;
    private static final int kCANCEL_TAG = 1;
    private static final int kCANCEL_ERR = 2;
    private int lenHdr;
    private int lenFtr;
    private int fuReq;
    private int protocolOptions;
    private int maxSendTduSize;
    private int maxRecvTduSize;
    private int reqIdCnt;
    private byte[] callingSelector;
    private byte[] calledSelector;
    private TrEndPoint firstChannel;
    private TrEndPoint secondChannel;
    private NetAttributes netAttributes;
    private byte[] sessionKey;
    private int abortReason;
    private int abortSource;
    private int excReportCode;
    private byte[] buffer;
    private NetInputStream nis;
    private boolean deadEnabled;
    private int deadReqId;
    private boolean cancelEnabled;
    private int state;
    private boolean haveDataToken;
    private byte[] iiopObjectKey;
    private byte[] iiopOperationTarget;
    private NetCrypto crypto;
    private boolean requestPending;
    private byte[] expData;
    private static final int[][] gDiagAbort = new int[][]{{2251, 4, 4}, {2252, 4, 5}, {2253, 4, 50}, {2254, 4, 51}, {2255, 4, 52}, {2299, 4, 62}, {2202, 2, 3}, {2203, 1, 3}, {2204, 2, 2}, {2205, 1, 2}, {2200, 2, 17}, {2201, 1, 17}, {2208, 2, 22}, {2207, 2, 43}, {2212, 2, 44}, {2213, 1, 44}, {2210, 2, 4}, {2211, 1, 4}, {2214, 2, 53}, {2215, 1, 53}, {2216, 2, 48}, {2217, 1, 48}, {2218, 2, 56}, {2219, 1, 56}, {2220, 2, 57}, {2221, 1, 57}, {2222, 2, 58}, {2223, 1, 58}, {2250, 1, 62}, {2450, 5, 23}, {2451, 5, 24}, {2452, 5, 25}, {2453, 5, 26}, {2454, 5, 27}, {2455, 5, 28}, {2456, 5, 29}, {2457, 5, 30}, {2458, 5, 31}, {2459, 5, 32}, {2460, 5, 33}, {2461, 5, 34}, {2462, 5, 35}, {2463, 5, 36}, {2464, 5, 37}, {2465, 5, 38}, {2466, 5, 18}, {2469, 5, 46}, {2470, 5, 47}, {2300, 3, 7}, {2302, 3, 9}, {2301, 3, 8}, {2303, 3, 10}, {2304, 3, 11}, {2305, 3, 12}, {2306, 3, 13}, {2307, 3, 14}, {2308, 3, 15}, {2310, 3, 20}, {2311, 3, 21}, {2312, 3, 45}, {2313, 3, 3}, {2315, 3, 49}, {2316, 3, 54}, {2317, 3, 55}, {2311, 3, 60}, {2311, 3, 61}, {2318, 3, 63}, {2319, 3, 64}, {2400, 6, 40}, {2401, 6, 41}, {2402, 6, 5}, {2403, 6, 18}, {2404, 6, 42}, {2405, 6, 3}, {2406, 6, 6}, {2449, 6, 62}};
    private static ProtoTable protoTable = new ProtoTable();

    public Session() {
        this.setDefaultAttributes();
        this.reqIdCnt = 0;
        this.sessionKey = new byte[0];
        this.iiopObjectKey = IIOP.defaultObjectKey;
        this.iiopOperationTarget = IIOP.defaultOperationTarget;
        this.buffer = new byte[1024];
        this.state = 1;
        this.haveDataToken = true;
        this.requestPending = false;
    }

    public NetInputStream attach(NetOutputStream netOutputStream) throws NetworkException {
        this.connect(netOutputStream);
        if (this.deadEnabled) {
            this.dead();
        }
        return this.nis;
    }

    public void attach() throws NetworkException {
        NetOutputStream netOutputStream = new NetOutputStream(this.buffer.length);
        this.connect(netOutputStream);
        if (this.deadEnabled) {
            this.dead();
        }
    }

    public void detach() throws NetworkException {
        if (this.firstChannel.available() > 0) {
            this.skip(this.firstChannel, this.buffer);
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(NetOutputStream netOutputStream) throws NetworkException {
        try {
            IIOPRequest iIOPRequest;
            SPDU sPDU;
            if (this.firstChannel.available() > 0) {
                this.skip(this.firstChannel, this.buffer);
            }
            ++this.reqIdCnt;
            if (this.crypto != null) {
                netOutputStream.encrypt(this.crypto);
            }
            int n = netOutputStream.getSize();
            try {
                sPDU = new SPDU(10, this.sessionKey);
            }
            catch (NetworkException networkException) {
                this.providerAbort(2, 43);
                throw this.getException(7773, networkException);
            }
            int n2 = SPDUEncoder.getLen(sPDU);
            try {
                iIOPRequest = new IIOPRequest(this.reqIdCnt, n2 + n, this.iiopObjectKey, this.iiopOperationTarget);
            }
            catch (NetworkException networkException) {
                this.providerAbort(2, 43);
                throw this.getException(7772, networkException);
            }
            this.protocol(17, true);
            this.send(netOutputStream, iIOPRequest, sPDU, n, this.firstChannel);
            this.requestPending = true;
        }
        finally {
            netOutputStream.close();
        }
    }

    public NetInputStream reply() throws NetworkException {
        byte[] byArray = BufferManager.GetBuffer();
        this.protocol(17, false);
        this.recv(byArray, this.firstChannel, this.reqIdCnt);
        this.requestPending = false;
        return this.nis;
    }

    public synchronized void cancel() throws NetworkException {
        if (!this.cancelEnabled) {
            throw this.getNaException(2206);
        }
        if (!this.requestPending) {
            throw this.getNaException(2209);
        }
        int n = this.sendCancel();
        if (n != this.recvCancel()) {
            throw this.getNaException(2208);
        }
    }

    public void setNetAttributes(NetAttributes netAttributes) throws NetworkException {
        String string;
        String string2;
        if (this.state != 1) {
            throw this.getException(7780);
        }
        this.netAttributes = netAttributes;
        String string3 = netAttributes.getIIOPObjectKey();
        if (string3 != null) {
            this.iiopObjectKey = this.convertStringToByteArray(string3);
        }
        if ((string2 = netAttributes.getIIOPOperationTarget()) != null) {
            this.iiopOperationTarget = this.convertStringToByteArray(string2);
        }
        if ((string = netAttributes.getNetworkProtocol()).equalsIgnoreCase("socket")) {
            this.setCancelOption(true);
        } else if (string.equalsIgnoreCase("ssl")) {
            this.setCancelOption(false);
        } else {
            this.providerAbort(2, 22);
            throw this.getException(7771);
        }
    }

    private void setCancelOption(boolean bl) throws NetworkException {
        if (this.state != 1) {
            this.providerAbort(2, 22);
            throw this.getException(7780);
        }
        this.cancelEnabled = bl;
        if (bl) {
            this.fuReq |= 4;
            this.protocolOptions |= 2;
        } else {
            this.fuReq &= 0xFB;
            this.protocolOptions &= 0xFD;
        }
    }

    public void setDeadConnDet(boolean bl) throws NetworkException {
        if (this.state != 1) {
            this.providerAbort(2, 22);
            throw this.getException(7780);
        }
        this.deadEnabled = bl;
        this.protocolOptions = bl ? (this.protocolOptions |= 8) : (this.protocolOptions &= 0xF7);
    }

    public NetOutputStream getNetOutputStream() throws NetworkException {
        switch (this.state) {
            case 1: {
                byte[] byArray = new byte[6];
                byte[] byArray2 = new byte[]{};
                SPDUConnect sPDUConnect = new SPDUConnect(this.fuReq, this.protocolOptions, byArray, byArray2, this.maxSendTduSize, this.maxRecvTduSize, 0);
                int n = IIOPFormat.getRequestLen(this.iiopObjectKey, this.iiopOperationTarget) + SPDUConnectEncoder.getLen(sPDUConnect);
                return new NetOutputStream(n);
            }
            case 4: {
                if (!this.haveDataToken) break;
                int n = IIOPFormat.getRequestLen(this.iiopObjectKey, this.iiopOperationTarget) + SPDUFormat.getLen(this.sessionKey);
                return new NetOutputStream(n);
            }
        }
        throw this.getException(7780);
    }

    public boolean getCancelOption() {
        return this.cancelEnabled;
    }

    public boolean getDeadOption() {
        return this.deadEnabled;
    }

    public void setEncryption(int n, byte[] byArray) throws NetworkException {
        this.crypto = new NetCrypto(n, byArray);
    }

    private void setDefaultAttributes() {
        this.fuReq = 53;
        this.protocolOptions = 14;
        this.maxSendTduSize = Integer.MAX_VALUE;
        this.maxRecvTduSize = Integer.MAX_VALUE;
        this.deadEnabled = true;
        this.cancelEnabled = true;
    }

    private void setCallingSelector(InetAddress inetAddress, int n) throws NetworkException {
        this.callingSelector = new byte[6];
        OutputStreamOnByteArray outputStreamOnByteArray = new OutputStreamOnByteArray(this.callingSelector);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStreamOnByteArray);
        try {
            outputStreamOnByteArray.write(inetAddress.getAddress());
            dataOutputStream.writeShort((short)n);
        }
        catch (IOException iOException) {
            this.providerAbort(2, 22);
            throw this.getException(7775, iOException.getMessage());
        }
    }

    private void setCalledSelector(InetAddress inetAddress, int n) throws NetworkException {
        this.calledSelector = new byte[6];
        OutputStreamOnByteArray outputStreamOnByteArray = new OutputStreamOnByteArray(this.calledSelector);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStreamOnByteArray);
        try {
            outputStreamOnByteArray.write(inetAddress.getAddress());
            dataOutputStream.writeShort((short)n);
        }
        catch (IOException iOException) {
            this.providerAbort(2, 22);
            throw this.getException(7775, iOException.getMessage());
        }
    }

    private void negotiateAttributes(int n, int n2, int n3, int n4) {
        this.fuReq &= n;
        this.protocolOptions &= n2;
        if (n3 < this.maxSendTduSize) {
            this.maxSendTduSize = n3;
        }
        if (n4 < this.maxRecvTduSize) {
            this.maxRecvTduSize = n4;
        }
        this.deadEnabled = (this.protocolOptions & 8) > 0;
        this.cancelEnabled = (this.fuReq & 4) > 0 && (this.protocolOptions & 2) > 0;
    }

    private TrEndPoint channelOpen() throws NetworkException {
        TrEndPoint trEndPoint = new TrEndPoint();
        trEndPoint.connect(this.netAttributes);
        return trEndPoint;
    }

    private void channelSend(TrEndPoint trEndPoint, byte[] byArray, int n) throws NetworkException {
        trEndPoint.send(byArray, n);
    }

    private void channelRecv(TrEndPoint trEndPoint, byte[] byArray, int n, int n2) throws NetworkException {
        trEndPoint.recv(byArray, n, n2);
    }

    private void channelClose(TrEndPoint trEndPoint) throws NetworkException {
        trEndPoint.close();
    }

    private void checkprotocol(int n, boolean bl) throws NetworkException {
        if (n == 4) {
            this.state = 8;
            return;
        }
        ProtoEntry protoEntry = protoTable.protocol(this.state, this.haveDataToken, n, bl, this.fuReq);
        if (protoEntry != null) {
            this.state = protoEntry.newState;
            this.haveDataToken = protoEntry.ownerDataToken;
            return;
        }
        this.providerAbort(2, 2);
        throw this.getException(7780);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void protocol(int n, boolean bl) throws NetworkException {
        if (this.cancelEnabled) {
            Session session = this;
            synchronized (session) {
                this.checkprotocol(n, bl);
            }
        } else {
            this.checkprotocol(n, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(NetOutputStream netOutputStream) throws NetworkException {
        try {
            IIOPRequest iIOPRequest;
            int n;
            SPDUConnect sPDUConnect;
            try {
                this.firstChannel = this.channelOpen();
            }
            catch (NetworkException networkException) {
                this.providerAbort(3, networkException);
                throw this.getException(7771, networkException);
            }
            this.protocol(1, false);
            InetAddress inetAddress = this.firstChannel.getLocalAddress();
            InetAddress inetAddress2 = this.firstChannel.getRemoteAddress();
            int n2 = this.firstChannel.getLocalPort();
            int n3 = this.firstChannel.getRemotePort();
            this.setCallingSelector(inetAddress, n2);
            this.calledSelector = new byte[0];
            int n4 = netOutputStream.getSize();
            ++this.reqIdCnt;
            try {
                sPDUConnect = new SPDUConnect(this.fuReq, this.protocolOptions, this.callingSelector, this.calledSelector, this.maxSendTduSize, this.maxRecvTduSize, n4);
                n = SPDUConnectEncoder.getLen(sPDUConnect);
            }
            catch (NetworkException networkException) {
                this.providerAbort(2, 43);
                throw this.getException(7773, networkException);
            }
            try {
                iIOPRequest = new IIOPRequest(this.reqIdCnt, n + n4, this.iiopObjectKey, this.iiopOperationTarget);
            }
            catch (NetworkException networkException) {
                this.providerAbort(2, 43);
                throw this.getException(7772, networkException);
            }
            this.protocol(6, true);
            this.send(netOutputStream, iIOPRequest, sPDUConnect, n4, this.firstChannel);
        }
        finally {
            netOutputStream.close();
        }
        this.recv(BufferManager.GetBuffer(), this.firstChannel, this.reqIdCnt);
        this.protocol(7, false);
    }

    private void disconnect() throws NetworkException {
        IIOPRequest iIOPRequest;
        int n;
        SPDU sPDU;
        ++this.reqIdCnt;
        try {
            sPDU = new SPDU(15, this.sessionKey);
            n = SPDUEncoder.getLen(sPDU);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7772, networkException);
        }
        try {
            iIOPRequest = new IIOPRequest(this.reqIdCnt, n, this.iiopObjectKey, this.iiopOperationTarget);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7772, networkException);
        }
        this.protocol(14, true);
        this.send(iIOPRequest, sPDU, 0, this.firstChannel);
        this.recv(this.buffer, this.firstChannel, this.reqIdCnt);
        this.protocol(15, false);
        this.protocol(2, true);
        try {
            this.channelClose(this.firstChannel);
        }
        catch (NetworkException networkException) {
            this.providerAbort(3, networkException);
            throw this.getException(7771, networkException);
        }
    }

    private int sendCancel() throws NetworkException {
        try {
            this.secondChannel = this.channelOpen();
        }
        catch (NetworkException networkException) {
            throw this.getNaException(7771, networkException);
        }
        byte[] byArray = new byte[5];
        this.encodeCancel(byArray, this.reqIdCnt);
        this.expDataRequest(byArray, 1);
        return this.reqIdCnt;
    }

    private int recvCancel() throws NetworkException {
        IIOP iIOP = this.recv(this.buffer, this.secondChannel);
        this.channelClose(this.secondChannel);
        if (iIOP.getMsgType() != 1) {
            throw this.getNaException(2208);
        }
        if (iIOP.getReplyStatus() != 0) {
            throw this.getNaException(2208);
        }
        return this.decodeCancel(this.expData);
    }

    private void accept(InputStream inputStream, SPDU sPDU) throws NetworkException {
        this.sessionKey = sPDU.getSessionKey();
        SPDUAccept sPDUAccept = this.decodeAccept(inputStream, sPDU);
        int n = sPDUAccept.getFuReq();
        int n2 = sPDUAccept.getProtocolOptions();
        int n3 = sPDUAccept.getMaxSendTduSize();
        int n4 = sPDUAccept.getMaxRecvTduSize();
        this.negotiateAttributes(n, n2, n3, n4);
        this.calledSelector = sPDUAccept.getCalledSelector();
    }

    private void refuse(InputStream inputStream, SPDU sPDU) throws NetworkException {
        SPDURefuse sPDURefuse = this.decodeRefuse(inputStream, sPDU);
        this.abortSource = 6;
        this.abortReason = sPDURefuse.getRefuseReason();
        this.protocol(8, false);
        try {
            this.firstChannel.close();
        }
        catch (NetworkException networkException) {
            // empty catch block
        }
        throw this.getException(7776);
    }

    private synchronized void providerAbort(InputStream inputStream, SPDU sPDU) throws NetworkException {
        SPDUPAbort sPDUPAbort = this.decodePAbort(inputStream, sPDU);
        this.abortSource = 1;
        this.abortReason = sPDUPAbort.getAbortReason();
        this.protocol(4, false);
        try {
            this.firstChannel.close();
        }
        catch (NetworkException networkException) {
            // empty catch block
        }
        throw this.getException(7778);
    }

    private synchronized void providerAbort(int n, int n2) {
        this.abortSource = n;
        this.abortReason = n2;
        try {
            this.protocol(4, false);
        }
        catch (NetworkException networkException) {
            // empty catch block
        }
        if (n != 3) {
            try {
                this.firstChannel.close();
            }
            catch (NetworkException networkException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private synchronized void providerAbort(int n, NetworkException networkException) {
        int n2 = networkException.getErrorCode();
        this.abortSource = n;
        block0 : switch (n) {
            case 3: {
                switch (n2) {
                    case 7627: {
                        this.abortReason = 13;
                        break block0;
                    }
                    case 7628: {
                        this.abortReason = 9;
                        break block0;
                    }
                    case 7622: {
                        this.abortSource = 5;
                        this.abortReason = 46;
                        break block0;
                    }
                    case 7726: {
                        this.abortReason = 20;
                        break block0;
                    }
                    case 7722: {
                        this.abortSource = 5;
                        this.abortReason = 47;
                        break block0;
                    }
                    case 7955: {
                        this.abortReason = 63;
                        break block0;
                    }
                    case 7929: 
                    case 7930: 
                    case 7931: {
                        this.abortReason = 64;
                        break block0;
                    }
                }
                this.abortReason = 21;
            }
        }
    }

    private void userAbort() throws NetworkException {
        this.protocol(3, false);
        this.abortSource = 4;
        this.abortReason = 4;
        try {
            this.firstChannel.close();
        }
        catch (NetworkException networkException) {
            // empty catch block
        }
        throw this.getException(7777);
    }

    private void systemException(InputStream inputStream, IIOP iIOP) throws NetworkException {
        IIOPReply iIOPReply = this.decodeIIOPReplyBody(inputStream, iIOP);
        NetworkException networkException = new NetworkException("Vendor minor codeset id = " + iIOPReply.getVmcid() + "\n" + "Vendor exception = " + iIOPReply.getVendorException() + "\n" + "Completion status = " + iIOPReply.getCompletionStatus() + "\n" + "Exception id = " + iIOPReply.getExceptionId() + "\n");
        this.abortSource = 4;
        this.abortReason = 51;
        throw this.getException(7782, networkException);
    }

    private void userException() throws NetworkException {
        this.abortSource = 4;
        this.abortReason = 50;
        throw this.getException(7781);
    }

    private void excRpt(InputStream inputStream, SPDU sPDU) throws NetworkException {
        SPDUExcRpt sPDUExcRpt = this.decodeExcRpt(inputStream, sPDU);
        this.abortSource = 1;
        this.abortReason = sPDUExcRpt.getReportCode();
        throw this.getException(7779);
    }

    private void expData(InputStream inputStream, SPDU sPDU) throws NetworkException {
        SPDUExpData sPDUExpData = this.decodeExpData(inputStream, sPDU);
        this.protocol(11, false);
        this.expData = sPDUExpData.getUserData();
    }

    private void dead() throws NetworkException {
        IIOPRequest iIOPRequest;
        int n;
        SPDU sPDU;
        ++this.reqIdCnt;
        try {
            sPDU = new SPDU(20, this.sessionKey);
            n = SPDUEncoder.getLen(sPDU);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7773, networkException);
        }
        try {
            iIOPRequest = new IIOPRequest(this.reqIdCnt, n, this.iiopObjectKey, this.iiopOperationTarget);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7772, networkException);
        }
        this.protocol(10, true);
        this.send(iIOPRequest, sPDU, 0, this.firstChannel);
        this.deadReqId = this.reqIdCnt;
    }

    private void expDataRequest(byte[] byArray, int n) throws NetworkException {
        IIOPRequest iIOPRequest;
        int n2;
        SPDUExpData sPDUExpData;
        try {
            sPDUExpData = new SPDUExpData(this.sessionKey, byArray);
            n2 = SPDUExpDataEncoder.getLen(sPDUExpData);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7773, networkException);
        }
        try {
            iIOPRequest = new IIOPRequest(n, n2, this.iiopObjectKey, this.iiopOperationTarget);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7772, networkException);
        }
        this.protocol(11, true);
        this.send(iIOPRequest, sPDUExpData, 0, this.secondChannel);
    }

    private void send(TrEndPoint trEndPoint, byte[] byArray, int n) throws NetworkException {
        try {
            this.channelSend(trEndPoint, byArray, n);
        }
        catch (NetworkException networkException) {
            if (trEndPoint == this.firstChannel) {
                this.providerAbort(3, networkException);
                throw this.getException(7771, networkException);
            }
            throw this.getNaException(7771, networkException);
        }
    }

    private void send(NetOutputStream netOutputStream, IIOPRequest iIOPRequest, SPDU sPDU, int n, TrEndPoint trEndPoint) throws NetworkException {
        int n2;
        int n3;
        OutputStream outputStream = netOutputStream.getCurrentHeader();
        try {
            n3 = iIOPRequest.encode(outputStream);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7772, networkException);
        }
        try {
            n2 = sPDU.encode(outputStream);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7773, networkException);
        }
        try {
            this.channelSend(trEndPoint, netOutputStream.getCurrentBuffer(), n3 + n2 + n);
        }
        catch (NetworkException networkException) {
            this.providerAbort(3, networkException);
            throw this.getException(7771, networkException);
        }
    }

    private void send(IIOPRequest iIOPRequest, SPDU sPDU, int n, TrEndPoint trEndPoint) throws NetworkException {
        int n2;
        int n3;
        OutputStreamOnByteArray outputStreamOnByteArray = new OutputStreamOnByteArray(this.buffer);
        try {
            n3 = iIOPRequest.encode(outputStreamOnByteArray);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7772, networkException);
        }
        try {
            n2 = sPDU.encode(outputStreamOnByteArray);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7773, networkException);
        }
        try {
            this.channelSend(trEndPoint, this.buffer, n3 + n2 + n);
        }
        catch (NetworkException networkException) {
            this.providerAbort(3, networkException);
            throw this.getException(7771, networkException);
        }
    }

    private void skip(TrEndPoint trEndPoint, byte[] byArray) throws NetworkException {
        while (trEndPoint.available() > 0) {
            this.recv(this.buffer, trEndPoint, this.deadReqId);
        }
    }

    private void skip(TrEndPoint trEndPoint) throws NetworkException {
        this.skip(trEndPoint, this.buffer);
    }

    private void recv(byte[] byArray, TrEndPoint trEndPoint, int n) throws NetworkException {
        int n2;
        do {
            IIOP iIOP = this.recv(byArray, trEndPoint);
            n2 = iIOP.getRequestId();
        } while (this.deadEnabled && n2 == this.deadReqId && n != this.deadReqId);
    }

    private void recv(TrEndPoint trEndPoint, byte[] byArray, int n, int n2) throws NetworkException {
        try {
            this.channelRecv(trEndPoint, byArray, n, n2);
        }
        catch (NetworkException networkException) {
            if (trEndPoint == this.firstChannel) {
                this.providerAbort(3, networkException);
                throw this.getException(7771, networkException);
            }
            throw this.getNaException(7771, networkException);
        }
    }

    private IIOPFormat recvIIOPHeader(byte[] byArray, TrEndPoint trEndPoint) throws NetworkException {
        int n = IIOPFormat.getHeaderLen();
        if (byArray.length < n) {
            this.providerAbort(2, 3);
            throw this.getException(7774);
        }
        this.recv(trEndPoint, byArray, 0, n);
        NetInputStream netInputStream = new NetInputStream(byArray, 0, n);
        IIOPDecoder iIOPDecoder = this.decodeIIOPHeader(netInputStream);
        IIOPFormat iIOPFormat = iIOPDecoder.getIIOPFormat();
        return iIOPFormat;
    }

    private NetInputStream recvIIOPMessage(byte[] byArray, int n, TrEndPoint trEndPoint) throws NetworkException {
        int n2 = IIOPFormat.getHeaderLen();
        if (n > 0) {
            if (byArray.length < n2 + n) {
                byArray = BufferManager.GetBiggerBuffer(byArray, n2 + n);
            }
            this.recv(trEndPoint, byArray, n2, n);
        }
        this.nis = new NetInputStream(byArray, n2, n);
        return this.nis;
    }

    private IIOP recv(byte[] byArray, TrEndPoint trEndPoint) throws NetworkException {
        int n = IIOPFormat.getHeaderLen();
        IIOPFormat iIOPFormat = this.recvIIOPHeader(byArray, trEndPoint);
        int n2 = iIOPFormat.getMsgLen();
        IIOP iIOP = iIOPFormat.getIIOP();
        NetInputStream netInputStream = this.recvIIOPMessage(byArray, n2, trEndPoint);
        this.decodeReply(netInputStream, iIOP);
        if (trEndPoint == this.firstChannel) {
            this.nis = netInputStream;
        }
        return iIOP;
    }

    private void decodeReply(NetInputStream netInputStream, IIOP iIOP) throws NetworkException {
        if ((iIOP = this.decodeIIOPMessage(netInputStream, iIOP)).getMsgType() == 1) {
            int n = IIOPFormat.getHeaderLen();
            switch (iIOP.getReplyStatus()) {
                case 1: {
                    this.userException();
                    break;
                }
                case 2: {
                    this.systemException(netInputStream, iIOP);
                }
            }
            SPDU sPDU = this.decodeSpdu(netInputStream);
            switch (sPDU.getSpduType()) {
                case 2: {
                    this.accept(netInputStream, sPDU);
                    break;
                }
                case 3: {
                    this.refuse(netInputStream, sPDU);
                    break;
                }
                case 13: {
                    this.providerAbort(netInputStream, sPDU);
                    break;
                }
                case 22: {
                    this.excRpt(netInputStream, sPDU);
                    break;
                }
                case 19: {
                    this.expData(netInputStream, sPDU);
                }
            }
            if (this.crypto != null) {
                netInputStream.decrypt(this.crypto);
            }
        } else {
            switch (iIOP.getMsgType()) {
                case 3: {
                    this.userAbort();
                    break;
                }
                case 4: {
                    this.abortSource = 4;
                    this.abortReason = 52;
                    throw this.getException(7783);
                }
                case 0: 
                case 1: {
                    throw this.getException(7772);
                }
            }
        }
    }

    private SPDU decodeSpdu(InputStream inputStream) throws NetworkException {
        SPDUDecoder sPDUDecoder;
        try {
            sPDUDecoder = new SPDUDecoder(inputStream);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7773, networkException);
        }
        return sPDUDecoder.getSpdu();
    }

    private SPDUAccept decodeAccept(InputStream inputStream, SPDU sPDU) throws NetworkException {
        SPDUAcceptDecoder sPDUAcceptDecoder;
        try {
            sPDUAcceptDecoder = new SPDUAcceptDecoder(sPDU, inputStream);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7773, networkException);
        }
        return sPDUAcceptDecoder.getSPDUAccept();
    }

    private SPDURefuse decodeRefuse(InputStream inputStream, SPDU sPDU) throws NetworkException {
        SPDURefuseDecoder sPDURefuseDecoder;
        try {
            sPDURefuseDecoder = new SPDURefuseDecoder(sPDU, inputStream);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7773, networkException);
        }
        return sPDURefuseDecoder.getSPDURefuse();
    }

    private SPDUPAbort decodePAbort(InputStream inputStream, SPDU sPDU) throws NetworkException {
        SPDUPAbortDecoder sPDUPAbortDecoder;
        try {
            sPDUPAbortDecoder = new SPDUPAbortDecoder(sPDU, inputStream);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7773, networkException);
        }
        return sPDUPAbortDecoder.getSPDUPAbort();
    }

    private SPDUExcRpt decodeExcRpt(InputStream inputStream, SPDU sPDU) throws NetworkException {
        SPDUExcRptDecoder sPDUExcRptDecoder;
        try {
            sPDUExcRptDecoder = new SPDUExcRptDecoder(sPDU, inputStream);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7773, networkException);
        }
        return sPDUExcRptDecoder.getSPDUExcRpt();
    }

    private SPDUExpData decodeExpData(InputStream inputStream, SPDU sPDU) throws NetworkException {
        SPDUExpDataDecoder sPDUExpDataDecoder;
        try {
            sPDUExpDataDecoder = new SPDUExpDataDecoder(sPDU, inputStream);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7773, networkException);
        }
        return sPDUExpDataDecoder.getExpDataSpdu();
    }

    private IIOPDecoder decodeIIOPHeader(InputStream inputStream) throws NetworkException {
        IIOPDecoder iIOPDecoder;
        try {
            iIOPDecoder = new IIOPDecoder(inputStream);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7772, networkException);
        }
        return iIOPDecoder;
    }

    private IIOP decodeIIOPMessage(InputStream inputStream, IIOP iIOP) throws NetworkException {
        IIOPDecoder iIOPDecoder;
        try {
            iIOPDecoder = new IIOPDecoder(inputStream, iIOP);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7772, networkException);
        }
        return iIOPDecoder.getIIOP();
    }

    private IIOPReply decodeIIOPReplyBody(InputStream inputStream, IIOP iIOP) throws NetworkException {
        IIOPReplyDecoder iIOPReplyDecoder;
        try {
            iIOPReplyDecoder = new IIOPReplyDecoder(inputStream, iIOP);
        }
        catch (NetworkException networkException) {
            this.providerAbort(2, 43);
            throw this.getException(7772, networkException);
        }
        return iIOPReplyDecoder.getIIOPReply();
    }

    private void encodeCancel(byte[] byArray, int n) throws NetworkException {
        int n2 = NetByteOrder.htonl(n, true);
        OutputStreamOnByteArray outputStreamOnByteArray = new OutputStreamOnByteArray(byArray);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStreamOnByteArray);
        try {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt(n2);
        }
        catch (IOException iOException) {
            throw this.getException(7775, iOException.getMessage());
        }
    }

    private int decodeCancel(byte[] byArray) throws NetworkException {
        InputStreamOnByteArray inputStreamOnByteArray = new InputStreamOnByteArray(byArray);
        DataInputStream dataInputStream = new DataInputStream(inputStreamOnByteArray);
        try {
            byte by = dataInputStream.readByte();
            if (by == 1) {
                int n = dataInputStream.readInt();
                return NetByteOrder.ntohl(n, true);
            }
            if (by == 2) {
                int n = dataInputStream.readInt();
                int n2 = this.abortParamsToDiagCode(1, NetByteOrder.ntohl(n, true));
                throw this.getNaException(n2);
            }
            throw this.getException(2208);
        }
        catch (IOException iOException) {
            throw this.getException(7775, iOException.getMessage());
        }
    }

    private byte[] convertStringToByteArray(String string) throws NetworkException {
        byte[] byArray;
        try {
            byArray = string.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw IIOP.getException(7538, unsupportedEncodingException.getMessage());
        }
        return byArray;
    }

    private int abortParamsToDiagCode(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < gDiagAbort.length; ++i) {
            if (gDiagAbort[i][1] != n || gDiagAbort[i][2] != n2) continue;
            return gDiagAbort[i][0];
        }
        return n3;
    }

    private NetworkException addDiagCode(NetworkException networkException) {
        int n = this.abortParamsToDiagCode(this.abortSource, this.abortReason);
        NetworkException networkException2 = NetMessage.Message.getNetworkException(n);
        networkException2.setNextException(networkException);
        return networkException2;
    }

    private NetworkException getException(int n) {
        return this.addDiagCode(NetMessage.Message.getNetworkException(n));
    }

    private NetworkException getException(int n, String string) {
        return this.addDiagCode(NetMessage.Message.getNetworkException(n, string));
    }

    private NetworkException getException(int n, NetworkException networkException) {
        NetworkException networkException2 = NetMessage.Message.getNetworkException(n);
        networkException2.setNextException(networkException);
        return this.addDiagCode(networkException2);
    }

    private NetworkException getNaException(int n) {
        return NetMessage.Message.getNetworkException(n);
    }

    private NetworkException getNaException(int n, NetworkException networkException) {
        NetworkException networkException2 = NetMessage.Message.getNetworkException(n);
        networkException2.setNextException(networkException);
        return networkException2;
    }

    static class ProtoTable {
        ProtoEntry[] entry = new ProtoEntry[27];

        ProtoTable() {
            this.entry[0] = new ProtoEntry(4, true, 17, true, 4, false, 1);
            this.entry[1] = new ProtoEntry(4, false, 17, false, 4, true, 1);
            this.entry[2] = new ProtoEntry(1, true, 1, false, 2, true, 1);
            this.entry[3] = new ProtoEntry(2, true, 6, true, 3, false, 1);
            this.entry[4] = new ProtoEntry(3, false, 7, false, 4, true, 1);
            this.entry[5] = new ProtoEntry(3, false, 8, false, 6, true, 1);
            this.entry[6] = new ProtoEntry(3, false, 20, false, 6, true, 1);
            this.entry[7] = new ProtoEntry(4, true, 14, true, 5, false, 1);
            this.entry[8] = new ProtoEntry(5, false, 15, false, 6, true, 1);
            this.entry[9] = new ProtoEntry(6, true, 2, true, 7, false, 1);
            this.entry[10] = new ProtoEntry(4, true, 3, false, 6, true, 1);
            this.entry[11] = new ProtoEntry(4, false, 3, false, 6, true, 1);
            this.entry[12] = new ProtoEntry(5, false, 3, false, 6, true, 1);
            this.entry[13] = new ProtoEntry(4, false, 10, true, 4, false, 32);
            this.entry[14] = new ProtoEntry(4, true, 10, true, 4, true, 32);
            this.entry[15] = new ProtoEntry(4, false, 10, false, 4, false, 32);
            this.entry[16] = new ProtoEntry(4, true, 10, false, 4, true, 32);
            this.entry[17] = new ProtoEntry(5, false, 10, false, 5, false, 32);
            this.entry[18] = new ProtoEntry(4, false, 11, true, 4, false, 4);
            this.entry[19] = new ProtoEntry(4, true, 11, true, 4, true, 4);
            this.entry[20] = new ProtoEntry(4, false, 11, false, 4, false, 4);
            this.entry[21] = new ProtoEntry(4, true, 11, false, 4, true, 4);
            this.entry[22] = new ProtoEntry(4, false, 19, false, 4, true, 16);
            this.entry[23] = new ProtoEntry(4, false, 18, true, 9, false, 16);
            this.entry[24] = new ProtoEntry(9, false, 17, false, 4, true, 16);
            this.entry[25] = new ProtoEntry(9, false, 9, false, 9, false, 16);
            this.entry[26] = new ProtoEntry(9, false, 13, false, 9, false, 16);
        }

        ProtoEntry protocol(int n, boolean bl, int n2, boolean bl2, int n3) {
            for (int i = 0; i <= 26; ++i) {
                if (this.entry[i].state != n || this.entry[i].ownsDataToken != bl || this.entry[i].indication != n2 || this.entry[i].outgoing != bl2 || (this.entry[i].fuReq & n3) <= 0) continue;
                return this.entry[i];
            }
            return null;
        }
    }

    static class ProtoEntry {
        int state;
        boolean ownsDataToken;
        int indication;
        boolean outgoing;
        int newState;
        boolean ownerDataToken;
        int fuReq;

        ProtoEntry(int n, boolean bl, int n2, boolean bl2, int n3, boolean bl3, int n4) {
            this.state = n;
            this.ownsDataToken = bl;
            this.indication = n2;
            this.outgoing = bl2;
            this.newState = n3;
            this.ownerDataToken = bl3;
            this.fuReq = n4;
        }
    }
}

