/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.net.SPDU;
import macromedia.sequelink.net.SPDUFormat;

public class SPDUEncoder
extends SPDUFormat {
    protected OutputStream os;
    protected DataOutputStream dos;
    protected SPDU spdu;

    SPDUEncoder(OutputStream outputStream, SPDU sPDU) throws NetworkException {
        this.os = outputStream;
        this.dos = new DataOutputStream(outputStream);
        this.spdu = sPDU;
        this.encodeSessionKey();
        this.encodeSpduType();
    }

    public int size() {
        return this.dos.size();
    }

    public static int getLen(SPDU sPDU) {
        byte[] byArray = sPDU.getSessionKey();
        return 2 + byArray.length;
    }

    private void encodeSessionKey() throws NetworkException {
        byte[] byArray = this.spdu.getSessionKey();
        try {
            this.dos.writeByte((byte)byArray.length);
            if (byArray.length > 0) {
                this.dos.write(byArray);
            }
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }

    private void encodeSpduType() throws NetworkException {
        byte by = SPDUEncoder.getToken(this.spdu.getSpduType());
        try {
            this.dos.write(by);
        }
        catch (IOException iOException) {
            throw SPDU.getException(7578, iOException.getMessage());
        }
    }
}

