/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import macromedia.sequelink.net.IIOP;
import macromedia.sequelink.net.IIOPOctetSequence;
import macromedia.sequelink.net.IIOPString;
import macromedia.sequelink.net.NetByteOrder;
import macromedia.sequelink.net.NetworkException;

public class IIOPFormat {
    private static final byte kMSG_REQUEST = 0;
    private static final byte kMSG_REPLY = 1;
    private static final byte kMSG_CANCEL = 2;
    private static final byte kMSG_LOCATEREQUEST = 3;
    private static final byte kMSG_LOCATEREPLY = 4;
    private static final byte kMSG_CLOSE = 5;
    private static final byte kMSG_ERROR = 6;
    private static final byte kMSG_FRAGMENT = 7;
    private static final int kPROTO_LEN = 4;
    private static final int kHEADER_LEN = 8;
    private static final int kREPLY_LEN = 17;
    private static final int kCANCEL_LEN = 0;
    private static final int kCLOSE_LEN = 0;
    private static final int kERROR_LEN = 0;
    protected static final byte kBIG_ENDIAN = 0;
    protected static final byte kLITTLE_ENDIAN = 1;
    private static final byte kNOMORE_FRAGMENTS = 0;
    private static final byte kMORE_FRAGMENTS = 2;
    private static final byte kNOREPLY = 0;
    private static final byte kMUSTREPLY = 1;
    protected byte majorVersion;
    protected byte minorVersion;
    protected byte msgType;
    protected byte flag;
    protected int msgLen;
    protected byte reply;
    protected int serviceContext;
    protected int principal;
    private IIOP iiop;

    IIOPFormat(IIOP iIOP) throws NetworkException {
        this.iiop = iIOP;
        this.IIOPHeaderFormat();
        this.IIOPMessageFormat();
    }

    IIOPFormat(byte by, byte by2, byte by3, byte by4, int n) throws NetworkException {
        this.IIOPHeaderFormat(by, by2, by3, by4, n);
        this.IIOPMessageFormat();
    }

    IIOPFormat(IIOP iIOP, int n, int n2, int n3) throws NetworkException {
        if (iIOP.getMsgType() != 1) {
            throw IIOP.getException(7524);
        }
        this.iiop = iIOP;
        this.IIOPHeaderFormat();
        this.IIOPMessageFormat();
        boolean bl = iIOP.isBigEndian();
        if (n != 0) {
            throw IIOP.getException(7530);
        }
        iIOP.setRequestId(NetByteOrder.ntohl(n2, bl));
        iIOP.setReplyStatus(NetByteOrder.ntohl(n3, bl));
    }

    IIOPFormat(IIOP iIOP, int n, int n2, byte by, IIOPOctetSequence iIOPOctetSequence, IIOPString iIOPString, int n3, int n4, byte by2) throws NetworkException {
        boolean bl = iIOP.isBigEndian();
        this.iiop = iIOP;
        this.IIOPHeaderFormat();
        this.IIOPMessageFormat();
        if (n != 0) {
            throw IIOP.getException(7530);
        }
        if (n3 != 0) {
            throw IIOP.getException(7536);
        }
        if (by != 0 && by != 1) {
            throw IIOP.getException(7537);
        }
        iIOP.setRequestId(NetByteOrder.ntohl(n2, bl));
        iIOP.setObjectKey(iIOPOctetSequence.getOctetSequence());
        iIOP.setOperation(iIOPString.getJavaString());
        iIOP.setDataLen(NetByteOrder.ntohl(n4, bl));
    }

    public static final int getRequestLen(byte[] byArray, byte[] byArray2) {
        return 12 + IIOPFormat.calculateMsgLenRequest(0, byArray, byArray2);
    }

    public static final int getReplyLen() {
        return 29;
    }

    public static final int getHeaderLen() {
        return 12;
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public byte getMsgTypeByte() {
        return this.msgType;
    }

    public int getMsgLen() {
        return this.msgLen;
    }

    public byte getFlag() {
        return this.flag;
    }

    public byte getReply() {
        return this.reply;
    }

    public int getServiceContext() {
        return this.serviceContext;
    }

    public int getPrincipal() {
        return this.principal;
    }

    public IIOP getIIOP() {
        return this.iiop;
    }

    public static final void validateProtoId(byte[] byArray) throws NetworkException {
        byte[] byArray2 = IIOP.protoId;
        if (byArray2[0] != byArray[0] || byArray2[1] != byArray[1] || byArray2[2] != byArray[2] || byArray2[3] != byArray[3]) {
            throw IIOP.getException(7529);
        }
    }

    private int calculateMsgLen(int n, int n2, byte[] byArray, byte[] byArray2) throws NetworkException {
        int n3;
        if (n2 < 0) {
            throw IIOP.getException(7527);
        }
        switch (n) {
            case 0: {
                n3 = IIOPFormat.calculateMsgLenRequest(n2, byArray, byArray2);
                break;
            }
            case 1: {
                n3 = 17 + n2;
                break;
            }
            case 2: {
                n3 = 0 + n2;
                break;
            }
            case 3: {
                if (n2 > 0) {
                    throw IIOP.getException(7527);
                }
                n3 = 0 + n2;
                break;
            }
            case 4: {
                if (n2 > 0) {
                    throw IIOP.getException(7527);
                }
                n3 = 0 + n2;
                break;
            }
            default: {
                throw IIOP.getException(7524);
            }
        }
        return n3;
    }

    private void validateVersion() throws NetworkException {
        Byte by = new Byte(this.majorVersion);
        Byte by2 = new Byte(this.minorVersion);
        if (1 != by.intValue()) {
            throw IIOP.getException(7528);
        }
        if (by2.intValue() != 0 && by2.intValue() != 1) {
            throw IIOP.getException(7528);
        }
    }

    private void setVersion() {
        this.majorVersion = 1;
        this.minorVersion = 1;
    }

    private void setMsgType() throws NetworkException {
        switch (this.iiop.getMsgType()) {
            case 0: {
                this.msgType = 0;
                break;
            }
            case 1: {
                this.msgType = 1;
                break;
            }
            case 2: {
                this.msgType = (byte)2;
                break;
            }
            case 3: {
                this.msgType = (byte)5;
                break;
            }
            case 4: {
                this.msgType = (byte)6;
                break;
            }
            default: {
                throw IIOP.getException(7524);
            }
        }
    }

    private int getMsgType() throws NetworkException {
        switch (this.msgType & 0xFF) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 1;
            }
        }
        throw IIOP.getException(7524);
    }

    private void setFlag() {
        boolean bl = this.iiop.isBigEndian();
        int n = this.iiop.getFragment();
        int n2 = bl ? 0 : 1;
        int n3 = n == 1 || n == 2 ? 2 : 0;
        this.flag = (byte)(n2 | n3);
    }

    private boolean isBigEndian() {
        return (this.flag & 1) != 1;
    }

    private boolean moreFragments() {
        return (this.flag & 2) == 2;
    }

    private int getFragment(int n, byte by, boolean bl) {
        if (n == 1) {
            if (by == 1 && bl) {
                return 1;
            }
            if (by == 7 && bl) {
                return 2;
            }
            if (by == 7 && !bl) {
                return 3;
            }
        }
        return 0;
    }

    private void setReply() {
        boolean bl = this.iiop.getReply();
        this.reply = !bl ? (byte)0 : 1;
    }

    private static int calculateMsgLenRequest(int n, byte[] byArray, byte[] byArray2) {
        int n2 = IIOPOctetSequence.getLengthIIOPOctetSequence(byArray);
        int n3 = IIOPString.getLengthIIOPString(byArray2);
        int n4 = 4;
        int n5 = 4;
        int n6 = 1;
        int n7 = 3;
        int n8 = 4;
        int n9 = 4;
        int n10 = 1;
        return n2 + n3 + n4 + n5 + n6 + n7 + n8 + n9 + n10 + n;
    }

    private void IIOPHeaderFormat() throws NetworkException {
        this.majorVersion = 1;
        this.minorVersion = 1;
        this.setFlag();
        this.setMsgType();
        this.msgLen = this.calculateMsgLen(this.iiop.getMsgType(), this.iiop.getDataLen(), this.iiop.getObjectKey(), this.iiop.getOperation());
    }

    private void IIOPHeaderFormat(byte by, byte by2, byte by3, byte by4, int n) throws NetworkException {
        this.majorVersion = by;
        this.minorVersion = by2;
        this.msgType = by3;
        this.flag = by4;
        this.validateVersion();
        int n2 = this.getMsgType();
        boolean bl = this.isBigEndian();
        boolean bl2 = this.moreFragments();
        this.msgLen = NetByteOrder.ntohl(n, bl);
        this.iiop = new IIOP(n2);
        int n3 = this.getFragment(n2, by3, bl2);
        if (n3 != 0) {
            this.iiop.setFragment(n3);
        }
        if (!bl) {
            this.iiop.setLittleEndian();
        }
    }

    private void IIOPMessageFormat() {
        this.setReply();
        this.serviceContext = 0;
        this.principal = 0;
    }
}

