/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import macromedia.jdbc.slbase.BaseCharacterStreamWrapper;
import macromedia.jdbc.slbase.BaseColumns;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseImplResultSet;
import macromedia.jdbc.slbase.BaseInputStreamWrapper;
import macromedia.jdbc.slbase.BasePreparedStatement;
import macromedia.jdbc.slbase.BaseStatement;
import macromedia.jdbc.slbase.BaseTimestamp;
import macromedia.jdbc.slbase.BaseWarnings;
import macromedia.slutil.UtilVectorUnsynced;

public final class BaseResultSet
implements ResultSet {
    BaseWarnings warnings;
    private BaseExceptions exceptions;
    BaseStatement statement;
    BaseConnection connection;
    boolean databaseMetaDataResultSet = false;
    private int resultSetType;
    private int resultSetConcurrency;
    private boolean lastGetWasNull;
    BaseColumns columns;
    private int lastColumnOrdinal;
    private int rowsFetchSize;
    private int fetchDirection = 1002;
    BaseImplResultSet implResultSet;
    private boolean onInsertRow;
    int lastColumnAccessed = -1;
    private UtilVectorUnsynced streamsReturned;
    private int maxFieldSize = Integer.MAX_VALUE;
    private Object synchronizer;
    private boolean forwardReadOnly_Opt = false;
    private boolean inOrderFieldAccessOnly;
    private boolean inOrderFieldAccessOnlyIsNotSet = true;
    private boolean validateCursorPosition = true;

    public BaseResultSet(BaseStatement baseStatement, BaseColumns baseColumns, BaseImplResultSet baseImplResultSet) throws SQLException {
        this.exceptions = baseStatement.exceptions;
        this.statement = baseStatement;
        this.columns = baseColumns;
        this.lastColumnOrdinal = baseColumns.count(1);
        if (baseImplResultSet.warnings == null) {
            this.warnings = new BaseWarnings(this.exceptions.getMessages());
            baseImplResultSet.setWarnings(this.warnings);
        } else {
            this.warnings = baseImplResultSet.warnings;
        }
        this.implResultSet = baseImplResultSet;
        if (baseStatement.maxRows > 0) {
            baseImplResultSet.setMaxCursorPosition(baseStatement.maxRows);
        }
        this.rowsFetchSize = baseStatement.getFetchSize();
        this.resultSetType = baseImplResultSet.getScrollType();
        this.resultSetConcurrency = baseImplResultSet.getConcurrency();
        if (this.resultSetType == 1003 && this.resultSetConcurrency == 1007) {
            this.forwardReadOnly_Opt = true;
        }
        this.fetchDirection = baseStatement.getFetchDirection();
        this.connection = baseStatement.connection;
        baseImplResultSet.postSetupInitialize();
        this.synchronizer = this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.implResultSet == null || this.connection.implConnection == null;
        }
    }

    void validateScrollable(String string) throws SQLException {
        if (this.resultSetType == 1003) {
            String[] stringArray = new String[]{string};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    void validateUpdateable(int n) throws SQLException {
        if (this.resultSetConcurrency != 1008) {
            throw this.connection.exceptions.getException(6054);
        }
        if (n != -1 && !this.columns.get((int)n).isWritable) {
            throw this.connection.exceptions.getException(6055);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.streamsReturned != null) {
                this.closeStreams(false);
            }
            if (this.implResultSet != null) {
                this.implResultSet.close();
                this.implResultSet = null;
            }
            this.statement.resultSetClosed(this);
        }
    }

    private void closeStreams(boolean bl) {
        if (this.streamsReturned == null) {
            return;
        }
        if (this.inOrderFieldAccessOnlyIsNotSet) {
            this.inOrderFieldAccessOnlyIsNotSet = false;
            boolean bl2 = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
        }
        if (bl && !this.inOrderFieldAccessOnly) {
            return;
        }
        int n = this.streamsReturned.size();
        for (int i = 0; i < n; ++i) {
            Object object = this.streamsReturned.elementAt(i);
            try {
                if (object instanceof InputStream) {
                    ((InputStream)object).close();
                    continue;
                }
                ((Reader)object).close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.streamsReturned = null;
    }

    private void commonFetchInitialize() throws SQLException {
        if (this.implResultSet == null || this.connection.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.warnings.clear();
        if (this.streamsReturned != null) {
            this.closeStreams(false);
        }
        this.lastColumnAccessed = 0;
    }

    public void cancelPendingUpdates() throws SQLException {
        if (this.resultSetConcurrency == 1008) {
            this.implResultSet.cancelUpdates();
            if (this.onInsertRow) {
                this.moveToCurrentRow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.lastGetWasNull;
        }
    }

    void validateCursorPosition() throws SQLException {
        if (!this.onInsertRow) {
            if (!this.implResultSet.isCursorPositionValid()) {
                throw this.exceptions.getException(6004, "24000");
            }
            if (this.implResultSet.onDeletedRow()) {
                throw this.exceptions.getException(6089, "24000");
            }
        }
    }

    void validateCursorPositionForUpdate() throws SQLException {
        if (!this.onInsertRow) {
            if (!this.implResultSet.isCursorPositionValid()) {
                throw this.exceptions.getException(6004, "24000");
            }
            if (this.implResultSet.onDeletedRow()) {
                throw this.exceptions.getException(6089, "24000");
            }
        }
    }

    void validateInsertRow() throws SQLException {
        if (this.onInsertRow) {
            throw this.exceptions.getException(6058);
        }
    }

    int getColumnOrdinal(String string) throws SQLException {
        int n = this.columns.getOrdinal(string);
        if (n == 0) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6005, stringArray, "42S22");
        }
        return n;
    }

    private void throwBadOrdinal(int n) throws SQLException {
        Integer n2 = new Integer(n);
        String[] stringArray = new String[]{n2.toString()};
        throw this.exceptions.getException(6006, stringArray, "42S22");
    }

    private void throwBadOrdinalReRead(int n) throws SQLException {
        Integer n2 = new Integer(n);
        String[] stringArray = new String[]{n2.toString()};
        throw this.exceptions.getException(6007, stringArray, "HY010");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 10);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getString(this.maxFieldSize, this.exceptions);
        }
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 9);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getBoolean(this.exceptions);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 1);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getByte(this.exceptions);
        }
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 3);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getShort(this.exceptions);
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 4);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getInteger(this.exceptions);
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 5);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getLong(this.exceptions);
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 6);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getFloat(this.exceptions);
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 7);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getDouble(this.exceptions);
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 8);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getBigDecimal(this.exceptions);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 8);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getBigDecimal(n2, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 2);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getBytes(this.maxFieldSize, this.columns.get(n).getTransliterator(), this.exceptions);
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 11);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getDate(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 12);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getTime(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 13);
            this.lastGetWasNull = baseData.isNull;
            BaseTimestamp baseTimestamp = baseData.getTimestamp(this.exceptions);
            if (baseTimestamp == null) {
                return null;
            }
            return baseTimestamp.getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseData baseData;
            InputStream inputStream;
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if ((inputStream = (baseData = this.implResultSet.getData(n, 15)).getASCIIStream(this.maxFieldSize, this.connection, this.exceptions, true)) != null) {
                if (this.streamsReturned == null) {
                    this.streamsReturned = new UtilVectorUnsynced();
                }
                this.streamsReturned.addElement(inputStream);
                this.lastGetWasNull = false;
            } else {
                this.lastGetWasNull = true;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getUnicodeStream(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseData baseData;
            InputStream inputStream;
            if (!this.connection.implConnection.shouldExposeGetSetUnicodeStream()) {
                String[] stringArray = new String[]{"ResultSet.getUnicodeStream"};
                throw this.connection.exceptions.getException(6003, stringArray);
            }
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if ((inputStream = (baseData = this.implResultSet.getData(n, 17)).getUCS2InputStream(this.maxFieldSize, this.connection, this.exceptions)) != null) {
                if (this.streamsReturned == null) {
                    this.streamsReturned = new UtilVectorUnsynced();
                }
                this.streamsReturned.addElement(inputStream);
                this.lastGetWasNull = false;
            } else {
                this.lastGetWasNull = true;
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseData baseData;
            InputStream inputStream;
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if ((inputStream = (baseData = this.implResultSet.getData(n, 14)).getBinaryStream(this.maxFieldSize, this.connection, this.exceptions, true)) != null) {
                if (this.streamsReturned == null) {
                    this.streamsReturned = new UtilVectorUnsynced();
                }
                this.streamsReturned.addElement(inputStream);
                this.lastGetWasNull = false;
            } else {
                this.lastGetWasNull = true;
            }
            return inputStream;
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.getColumnOrdinal(string), n);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColumnOrdinal(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColumnOrdinal(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColumnOrdinal(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColumnOrdinal(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColumnOrdinal(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.warnings.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.warnings.clear();
        }
    }

    public String getCursorName() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            String[] stringArray = new String[]{"ResultSet.getCursorName"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.connection.implConnection.createResultSetMetaData(this, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            int n2 = BaseData.mapJDBCTypeToJavaObjectType(this.columns.get((int)n).type);
            BaseData baseData = this.implResultSet.getData(n, n2);
            this.lastGetWasNull = baseData.isNull;
            if (this.lastGetWasNull) {
                return null;
            }
            return baseData.getObject(n2, this.maxFieldSize, this.connection, this.exceptions);
        }
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            int n = this.columns.getOrdinal(string);
            if (n == 0) {
                throw this.exceptions.getException(6005, "42S22");
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseData baseData;
            Reader reader;
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if ((reader = (baseData = this.implResultSet.getData(n, 18)).getCharacterStreamReader(this.maxFieldSize, this.connection, this.exceptions, true)) != null) {
                this.lastGetWasNull = false;
                if (this.streamsReturned == null) {
                    this.streamsReturned = new UtilVectorUnsynced();
                }
                this.streamsReturned.addElement(reader);
            } else {
                this.lastGetWasNull = true;
            }
            return reader;
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getColumnOrdinal(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            boolean bl = this.implResultSet.next();
            if (this.forwardReadOnly_Opt) {
                this.validateCursorPosition = !bl;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.previous");
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            return this.implResultSet.previous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.absolute");
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            return this.implResultSet.absolute(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.relative");
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            return this.implResultSet.relative(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.first");
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            return this.implResultSet.first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.last");
            this.commonFetchInitialize();
            this.cancelPendingUpdates();
            return this.implResultSet.last();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.beforeFirst");
            this.commonFetchInitialize();
            this.implResultSet.beforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateScrollable("ResultSet.afterLast");
            this.commonFetchInitialize();
            this.implResultSet.afterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateScrollable("ResultSet.isFirst");
            return this.implResultSet.isFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateScrollable("ResultSet.isLast");
            return this.implResultSet.isLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateScrollable("ResultSet.isBeforeFirst");
            return this.implResultSet.isBeforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateScrollable("ResultSet.isAfterLast");
            return this.implResultSet.isAfterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.implResultSet.getRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxFieldSize(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.maxFieldSize = n == 0 ? Integer.MAX_VALUE : n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateScrollable("ResultSet.setFetchDirection");
            this.fetchDirection = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.fetchDirection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n < 0 || this.statement.maxRows > 0 && n > this.statement.maxRows) {
                String[] stringArray = new String[]{"setFetchSize"};
                throw this.exceptions.getException(6002, stringArray);
            }
            this.rowsFetchSize = n;
            this.implResultSet.setFetchSize(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.rowsFetchSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.resultSetType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrency() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.resultSetConcurrency;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowUpdated() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowInserted() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rowDeleted() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.implResultSet.onDeletedRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNull(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(BaseData.mapJDBCTypeToJavaObjectType(this.columns.get((int)n).type), null, this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoolean(int n, boolean bl) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(9, new Boolean(bl), this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByte(int n, byte by) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(1, new Byte(by), this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShort(int n, short s) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(3, new Short(s), this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInt(int n, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(4, new Integer(n2), this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLong(int n, long l) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(5, new Long(l), this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFloat(int n, float f) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(6, new Float(f), this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDouble(int n, double d) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(7, new Double(d), this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(8, bigDecimal, this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(int n, String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(10, string, this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(2, byArray, this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDate(int n, Date date) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(11, date, this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTime(int n, Time time) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(12, time, this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = timestamp == null ? new BaseData(13, null, this.connection) : new BaseData(13, new BaseTimestamp(timestamp, null), this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(15, new BaseInputStreamWrapper(inputStream, n2, this.connection, this.exceptions), this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(14, new BaseInputStreamWrapper(inputStream, n2, this.connection, this.exceptions), this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(18, new BaseCharacterStreamWrapper(reader, n2, this.connection, this.exceptions), this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int n, Object object, int n2) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(object, this.connection);
            BigDecimal bigDecimal = baseData.getBigDecimal(n2, this.exceptions);
            baseData.setBigDecimal(bigDecimal);
            this.implResultSet.updateData(n, baseData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int n, Object object) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(object, this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColumnOrdinal(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.getColumnOrdinal(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.getColumnOrdinal(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.getColumnOrdinal(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.getColumnOrdinal(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.getColumnOrdinal(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.getColumnOrdinal(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.getColumnOrdinal(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColumnOrdinal(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColumnOrdinal(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColumnOrdinal(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getColumnOrdinal(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColumnOrdinal(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColumnOrdinal(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.getColumnOrdinal(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.getColumnOrdinal(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.getColumnOrdinal(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.getColumnOrdinal(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.getColumnOrdinal(string), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateUpdateable(-1);
            if (!this.onInsertRow) {
                throw this.exceptions.getException(6061);
            }
            this.implResultSet.insertRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateUpdateable(-1);
            this.validateCursorPosition();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            this.implResultSet.updateRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateUpdateable(-1);
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateInsertRow();
            this.implResultSet.deleteRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateInsertRow();
            this.validateScrollable("ResultSet.refreshRow");
            if (this.implResultSet.isBeforeFirst() || this.implResultSet.isAfterLast()) {
                throw this.exceptions.getException(6004);
            }
            this.implResultSet.refreshRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateUpdateable(-1);
            this.validateCursorPositionForUpdate();
            this.implResultSet.cancelUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToInsertRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.onInsertRow = true;
            this.implResultSet.prepareInsertRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.onInsertRow = false;
            this.implResultSet.cancelInsertRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (!this.databaseMetaDataResultSet) {
                if (this.statement instanceof BasePreparedStatement) {
                    return ((BasePreparedStatement)this.statement).getExternalReference();
                }
                return this.statement;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n, Map map) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.getObject(n);
        }
    }

    public Ref getRef(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"ResultSet.getRef"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            int n2;
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if (!((n2 = this.columns.get((int)n).type) == 2004 || n2 == -4 && this.connection.implConnection.enableXlobOnLongVarX())) {
                throw this.exceptions.getException(6008);
            }
            BaseData baseData = this.implResultSet.getData(n, 19);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getBlob(this.connection, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            int n2;
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            if (!((n2 = this.columns.get((int)n).type) == 2005 || n2 == -1 && this.connection.implConnection.enableXlobOnLongVarX())) {
                throw this.exceptions.getException(6008);
            }
            BaseData baseData = this.implResultSet.getData(n, 20);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getClob(this.connection, this.exceptions);
        }
    }

    public Array getArray(int n) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"ResultSet.getArray"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string, Map map) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.getObject(string);
        }
    }

    public Ref getRef(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"ResultSet.getRef"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getColumnOrdinal(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getColumnOrdinal(string));
    }

    public Array getArray(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"ResultSet.getArray"};
            throw this.connection.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 11);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getDate(calendar, this.exceptions);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getColumnOrdinal(string), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 12);
            this.lastGetWasNull = baseData.isNull;
            return baseData.getTime(calendar, this.exceptions);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getColumnOrdinal(string), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            if (this.inOrderFieldAccessOnlyIsNotSet) {
                this.inOrderFieldAccessOnlyIsNotSet = false;
                boolean bl = this.inOrderFieldAccessOnly = this.implResultSet.getColumnAccess() == 1;
            }
            if (n <= this.lastColumnAccessed && this.inOrderFieldAccessOnly) {
                this.throwBadOrdinalReRead(n);
            }
            this.lastColumnAccessed = n;
            if (this.validateCursorPosition) {
                this.validateCursorPosition();
            }
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = this.implResultSet.getData(n, 13);
            this.lastGetWasNull = baseData.isNull;
            this.lastGetWasNull = baseData.isNull;
            BaseTimestamp baseTimestamp = baseData.getTimestamp(calendar, this.exceptions);
            if (baseTimestamp == null) {
                return null;
            }
            return baseTimestamp.getTimestamp();
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColumnOrdinal(string), calendar);
    }

    public URL getURL(int n) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.getURL"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public URL getURL(String string) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.getURL"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.updateRef"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.updateRef"};
        throw this.exceptions.getException(6003, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlob(int n, Blob blob) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(19, blob, this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.getColumnOrdinal(string), blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClob(int n, Clob clob) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implResultSet == null || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n <= 0 || n > this.lastColumnOrdinal) {
                this.throwBadOrdinal(n);
            }
            this.validateUpdateable(n);
            this.validateCursorPositionForUpdate();
            if (this.streamsReturned != null) {
                this.closeStreams(true);
            }
            BaseData baseData = new BaseData(20, clob, this.connection);
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.getColumnOrdinal(string), clob);
    }

    public void updateArray(int n, Array array) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.updateArray"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public void updateArray(String string, Array array) throws SQLException {
        String[] stringArray = new String[]{"ResultSet.updateArray"};
        throw this.exceptions.getException(6003, stringArray);
    }
}

