/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.slutil.UtilCharacterReaderToUCS2InputStream;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilPagedTempBuffer;
import macromedia.slutil.UtilUCS2InputStreamToCharacterReader;

public class BaseCharacterStreamWrapper
extends Reader {
    BaseConnection connection;
    Object synchronizer;
    Reader rdr;
    boolean closed;
    long numTotalCharsInReader;
    long numCharsReturned;
    long maxCharsToReturn = Long.MAX_VALUE;
    BaseExceptions exceptions;
    boolean isOutputStream = true;
    UtilPagedTempBuffer cachedData;

    BaseCharacterStreamWrapper(Reader reader, long l, BaseConnection baseConnection, BaseExceptions baseExceptions) {
        this.rdr = reader;
        this.exceptions = baseExceptions;
        this.numTotalCharsInReader = l;
        this.numCharsReturned = 0L;
        this.closed = false;
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    void setIsInputStream() {
        this.isOutputStream = false;
    }

    void validateClosedState() throws IOException {
        if (this.closed || this.connection != null && this.connection.implConnection == null) {
            throw new IOException(this.exceptions.getException(6009).getMessage());
        }
    }

    void setConnection(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.synchronizer = baseConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.rdr.close();
                this.closed = true;
                if (this.cachedData != null) {
                    try {
                        this.cachedData.truncate(true);
                        this.cachedData = null;
                    }
                    catch (UtilException utilException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mark(int n) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.rdr.mark(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markSupported() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                return this.rdr.markSupported();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numCharsReturned == this.maxCharsToReturn) {
                return -1;
            }
            int n = this.rdr.read();
            if (this.numTotalCharsInReader != -1L) {
                boolean bl = false;
                if (n != -1) {
                    ++this.numCharsReturned;
                    if (this.numCharsReturned > this.numTotalCharsInReader) {
                        bl = true;
                    }
                } else if (this.numCharsReturned != this.numTotalCharsInReader) {
                    bl = true;
                }
                if (bl) {
                    throw new IOException(this.exceptions.baseMessages.getBaseLocalMessages().getString(6031, null));
                }
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            if (this.numCharsReturned == this.maxCharsToReturn) {
                return -1;
            }
            if (cArray.length - n < n2) {
                throw new IOException(this.exceptions.getException(6065).getMessage());
            }
            if (this.numCharsReturned + (long)n2 > this.maxCharsToReturn) {
                n2 = new Long(this.maxCharsToReturn - this.numCharsReturned).intValue();
            }
            int n3 = this.rdr.read(cArray, n, n2);
            if (this.numTotalCharsInReader != -1L) {
                boolean bl = false;
                if (n3 != -1) {
                    this.numCharsReturned += (long)n3;
                    if (this.numCharsReturned > this.numTotalCharsInReader) {
                        bl = true;
                    }
                } else if (this.numCharsReturned != this.numTotalCharsInReader) {
                    bl = true;
                }
                if (bl) {
                    throw new IOException(this.exceptions.baseMessages.getBaseLocalMessages().getString(6031, null));
                }
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.read(cArray, 0, cArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            this.rdr.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.isOutputStream) {
                this.validateClosedState();
            }
            return this.rdr.skip(l);
        }
    }

    public long length() {
        return this.numTotalCharsInReader;
    }

    public long determineLength() throws SQLException {
        if (this.numTotalCharsInReader == -1L) {
            this.cache();
        }
        return this.numTotalCharsInReader;
    }

    public long cache() throws SQLException {
        try {
            UtilCharacterReaderToUCS2InputStream utilCharacterReaderToUCS2InputStream = new UtilCharacterReaderToUCS2InputStream(this.rdr);
            this.cachedData = new UtilPagedTempBuffer(2048);
            long l = 0L;
            byte[] byArray = new byte[1024];
            int n = 0;
            while (n != -1) {
                n = utilCharacterReaderToUCS2InputStream.read(byArray);
                if (n == -1) continue;
                this.cachedData.write(l, byArray, 0, n);
                l += (long)n;
            }
            ((InputStream)utilCharacterReaderToUCS2InputStream).close();
            this.rdr.close();
            this.rdr = new UtilUCS2InputStreamToCharacterReader(this.cachedData.getInputStream());
            this.numTotalCharsInReader = l / 2L;
        }
        catch (IOException iOException) {
            throw this.exceptions.getException(iOException);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
        return this.numTotalCharsInReader;
    }
}

