/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink.columns;

import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import macromedia.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import macromedia.jdbc.sequelink.columns.SequeLinkDateTimeColumn;
import macromedia.jdbc.sequelink.utilities.BooleanArray;
import macromedia.jdbc.sequelink.utilities.IntArray;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseTimestamp;
import macromedia.sequelink.ctxt.stmt.StatementContext;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.slutil.UtilException;

public class SequeLinkDateColumn
extends SequeLinkDateTimeColumn {
    private IntArray array;
    private BooleanArray isNull;

    public SequeLinkDateColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe, int n) throws SQLException {
        super(statementContext, sequeLinkColumnDescribe, n, 11);
        this.out = new char[19];
        this.array = new IntArray();
        this.isNull = new BooleanArray();
    }

    protected void setBindInfo() {
        this.sqlnkType = 9;
        this.sqlnkSize = 4;
    }

    protected void readDataFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        int n = sspInputStream.readSSPInt16() - 1900;
        n <<= 4;
        n |= sspInputStream.readSSPInt8() - 1;
        n <<= 5;
        this.array.add(n |= sspInputStream.readSSPInt8());
        this.isNull.add(false);
    }

    protected void readNull() {
        this.array.add(0);
        this.isNull.add(true);
    }

    public void clearData() {
        this.array.reset();
        this.isNull.reset();
    }

    public BaseData getData(int n, int n2, DiagnosticList diagnosticList) throws SQLException {
        if (this.isNull.get(n2)) {
            this.myBaseData.setNull(this.baseDataType);
            return this.myBaseData;
        }
        int n3 = this.array.get(n2);
        int n4 = n3 & 0x1F;
        int n5 = (n3 >>= 5) & 0xF;
        int n6 = n3 >>= 4;
        switch (n) {
            case 11: {
                Date date = new Date(n6, n5, n4);
                this.myBaseData.setDate(date);
                break;
            }
            case 10: {
                String string = this.getDateString(n6, n5, n4);
                this.myBaseData.setString(string);
                break;
            }
            case 13: {
                BaseTimestamp baseTimestamp = new BaseTimestamp(n6 + 1900, n5, n4, 0, 0, 0, 0, null);
                this.myBaseData.setTimestamp(baseTimestamp);
                break;
            }
            default: {
                Date date = new Date(n6, n5, n4);
                this.myBaseData.setDate(date);
            }
        }
        return this.myBaseData;
    }

    private String getDateString(int n, int n2, int n3) throws SQLException {
        this.pos = 0;
        this.writeInt(n + 1900, 4);
        this.out[this.pos++] = 45;
        this.writeInt(n2 + 1, 2);
        this.out[this.pos++] = 45;
        this.writeInt(n3, 2);
        return new String(this.out, 0, this.pos);
    }
}

