/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink;

import java.io.IOException;
import java.sql.SQLException;
import macromedia.jdbc.sequelink.SequeLinkImplConnection;
import macromedia.jdbc.slbase.BaseImplBlob;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.sequelink.ssp.SspLob;
import macromedia.sequelink.ssp.SspOutputStream;

public class SequeLinkImplBlob
extends BaseImplBlob
implements SspLob {
    private SequeLinkImplConnection implCon;
    private byte[] locator;
    private long lobLength;
    private boolean moreToCome;
    private int lobOptions;

    public SequeLinkImplBlob(SequeLinkImplConnection sequeLinkImplConnection, byte[] byArray) {
        super(sequeLinkImplConnection.exceptions);
        this.implCon = sequeLinkImplConnection;
        this.locator = byArray;
        this.lobLength = -1L;
        try {
            this.lobOptions = sequeLinkImplConnection.conCtxt.supportsLobs(DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            throw new InternalError("SequeLinkImplBlob ctor " + sQLException.toString());
        }
    }

    public long getMaxChunkSize() {
        return 30000L;
    }

    public int readData(byte[] byArray, int n, long l, int n2) throws SQLException {
        if ((this.lobOptions & 1) == 0) {
            String[] stringArray = new String[]{"Blob.readData"};
            throw this.exceptions.getException(6003, stringArray);
        }
        return this.implCon.getLobData(this, byArray, n, l - 1L, n2);
    }

    public int writeData(long l, byte[] byArray, int n, int n2) throws SQLException {
        if ((this.lobOptions & 4) == 0) {
            String[] stringArray = new String[]{"Blob.writeData"};
            throw this.exceptions.getException(6003, stringArray);
        }
        int n3 = this.implCon.setLobData(this, byArray, n, l - 1L, n2);
        if (this.lobLength != -1L) {
            this.lobLength = Math.max(this.lobLength, l - 1L + (long)n3);
        }
        return n3;
    }

    public long getLength() throws SQLException {
        if (this.lobLength != -1L) {
            return this.lobLength;
        }
        this.implCon.getLobLength(this);
        return this.lobLength;
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(byte[] byArray, long l) throws SQLException {
        return this.implCon.getLobPosition(this, byArray, l);
    }

    public void truncate(long l) throws SQLException {
        if ((this.lobOptions & 4) == 0) {
            String[] stringArray = new String[]{"Blob.truncate"};
            throw this.exceptions.getException(6003, stringArray);
        }
        if (this.lobLength != -1L && l >= this.lobLength) {
            return;
        }
        this.implCon.lobTruncate(this, l);
        if (this.lobLength != -1L) {
            this.lobLength = l;
        }
    }

    public void close() throws SQLException {
        this.implCon = null;
    }

    public void setLocator(byte[] byArray) {
        this.locator = byArray;
    }

    public byte[] getLocator() {
        return this.locator;
    }

    public int getLobType() {
        return 1;
    }

    public void setLobLength(long l) {
        this.lobLength = l;
    }

    public void setMoreToCome(boolean bl) {
        this.moreToCome = bl;
    }

    public String getEncoding() {
        return "";
    }

    public int readLobData(SspInputStream sspInputStream, byte[] byArray, int n, int n2) throws IOException {
        return sspInputStream.readSSPLongVarBinary(byArray, n, n2);
    }

    public int writeLobData(SspOutputStream sspOutputStream, byte[] byArray, int n, int n2) throws IOException {
        sspOutputStream.writeSSPLongVarBinary(byArray, n, n2);
        return n2;
    }
}

