/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds.handler;

import coldfusion.debugger.CFDebuggerExceptions;
import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.CFJVMDebugManager;
import coldfusion.debugger.events.CFBreakpointEvent;
import coldfusion.debugger.events.CFBreakpointSetEvent;
import coldfusion.debugger.events.CFDebugEvent;
import coldfusion.debugger.events.CFDisconnectEvent;
import coldfusion.debugger.events.CFExceptionBreakpointEvent;
import coldfusion.debugger.events.CFExceptionEvent;
import coldfusion.debugger.events.CFStepEvent;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.rds.WddxUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DebugEventsHandler {
    public static final int EVENT_TIMEOUT = 0;
    private static Map defaultEventFlagMap = DebugEventsHandler.getDefaultFetchFlags();

    public static int handleRequest(RdsRequest req, RdsResponse resp, CFJVMDebugManager dbgMgr) {
        CFDebuggerLogger.log(req);
        String sessionId = req.getMetaString(1);
        int metaCount = req.getMetaCount();
        Map flagMap = null;
        if (metaCount > 2) {
            String wddxString = req.getMetaString(2);
            try {
                Object obj = WddxUtils.readObject((String)wddxString);
                if (obj instanceof Map) {
                    flagMap = (Map)obj;
                }
            }
            catch (Exception obj) {
                // empty catch block
            }
        }
        if (flagMap == null) {
            flagMap = defaultEventFlagMap;
        }
        try {
            ArrayList evts = dbgMgr.getDebuggerEvents(sessionId, flagMap, 0);
            if (evts == null) {
                return 0;
            }
            Vector<Map> vec = new Vector<Map>();
            for (CFDebugEvent evt : evts) {
                if (evt instanceof CFStepEvent || evt instanceof CFBreakpointEvent) {
                    vec.add(DebugEventsHandler.wrapBasicEvent(evt));
                    continue;
                }
                if (evt instanceof CFDisconnectEvent) {
                    vec.add(DebugEventsHandler.wrapDisconnectEvent((CFDisconnectEvent)evt));
                    continue;
                }
                if (evt instanceof CFExceptionEvent) {
                    vec.add(DebugEventsHandler.wrapExceptionEvent((CFExceptionEvent)evt));
                    continue;
                }
                if (evt instanceof CFBreakpointSetEvent) {
                    vec.add(DebugEventsHandler.wrapBreakpointSetEvent((CFBreakpointSetEvent)evt));
                    continue;
                }
                if (!(evt instanceof CFExceptionBreakpointEvent)) continue;
                vec.add(DebugEventsHandler.wrapExceptionBreakpointEvent((CFExceptionBreakpointEvent)evt));
            }
            if (vec.size() == 0) {
                DebugEventsHandler.handleRequest(req, resp, dbgMgr);
            }
            String wddxString = WddxUtils.writeObject(vec);
            resp.addMetaData(wddxString);
        }
        catch (Throwable e) {
            CFDebuggerLogger.log(e);
            resp.setError("Error getting debug events", e);
        }
        CFDebuggerLogger.log(resp);
        return 1;
    }

    private static Map getDefaultFetchFlags() {
        HashMap<String, Boolean> flagMap = new HashMap<String, Boolean>();
        flagMap.put("SCOPES", Boolean.TRUE);
        flagMap.put("CF_TRACE", Boolean.TRUE);
        return flagMap;
    }

    public static Map wrapBasicEvent(CFDebugEvent evt) {
        Object[] statckTrace;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (evt instanceof CFBreakpointEvent) {
            map.put("EVENT", "BREAKPOINT");
        } else if (evt instanceof CFStepEvent) {
            map.put("EVENT", "STEP");
        } else if (evt instanceof CFExceptionBreakpointEvent) {
            map.put("EVENT", "EXCEPTION_BREAKPOINT");
        }
        map.put("THREAD", evt.getThreadName());
        map.put("SOURCE", evt.getSourcePath());
        map.put("LINE", new Integer(evt.getLineNumber()));
        HashMap scopes = evt.getScopes();
        HashMap watchVars = evt.getWatchVariables();
        List threads = evt.getVmThreads();
        if (scopes != null) {
            map.put("SCOPES", scopes);
        }
        if (watchVars != null) {
            map.put("WATCH", watchVars);
        }
        if (threads != null) {
            map.put("THREADS", threads);
        }
        if ((statckTrace = evt.getJavaStackTrace()) != null) {
            if (statckTrace[0] != null) {
                map.put("JAVA_TRACE", statckTrace[0]);
            }
            map.put("CF_TRACE", statckTrace[1]);
        }
        return map;
    }

    public static Map wrapDisconnectEvent(CFDisconnectEvent evt) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("EVENT", "CF_DISCONNECT");
        return map;
    }

    public static Map wrapExceptionEvent(CFExceptionEvent evt) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EVENT", "CF_DEBUGGER_EXCEPTION");
        Exception expObj = evt.getException();
        if (expObj instanceof CFDebuggerExceptions.SetBreakpointFailedException) {
            CFDebuggerExceptions.SetBreakpointFailedException e = (CFDebuggerExceptions.SetBreakpointFailedException)expObj;
            if (expObj instanceof CFDebuggerExceptions.InvalidBreakpointLocationException) {
                map.put("EXCEPTION_TYPE", "InvalidBreakpointLocationException");
            } else if (expObj instanceof CFDebuggerExceptions.UnresolvedBreakpointLocationException) {
                map.put("EXCEPTION_TYPE", "UnresolvedBreakpointLocationException");
            } else {
                map.put("EXCEPTION_TYPE", "SetBreakpointFailedException");
            }
            map.put("CFML_PATH", e.getCfmlPath());
            map.put("REQ_LINE_NUM", new Integer(e.getRequestedLineNum()));
            map.put("ACTUAL_LINE_NUM", new Integer(e.getActualBPLineNumber()));
        } else {
            map.put("EXCEPTION_TYPE", expObj.getClass().getName());
        }
        map.put("ERROR", expObj.getMessage());
        return map;
    }

    public static Map wrapBreakpointSetEvent(CFBreakpointSetEvent evt) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EVENT", "CF_BREAKPOINT_SET");
        map.put("CFML_PATH", evt.getCfmlPath());
        map.put("REQ_LINE_NUM", new Integer(evt.getRequestedLineNum()));
        map.put("ACTUAL_LINE_NUM", new Integer(evt.getActualLinenumber()));
        return map;
    }

    public static Map wrapExceptionBreakpointEvent(CFExceptionBreakpointEvent evt) {
        Map eventMap = DebugEventsHandler.wrapBasicEvent(evt);
        eventMap.put("EVENT", "EXCEPTION_BREAKPOINT");
        Map exceptionInfo = evt.getExceptionInfo();
        eventMap.put("EXCEPTION_CLASS", exceptionInfo.get("EXCEPTION_CLASS"));
        eventMap.put("EXCEPTION_MESSAGE", exceptionInfo.get("EXCEPTION_MESSAGE"));
        return eventMap;
    }
}

