/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds.handler;

import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.CFJVMDebugManager;
import coldfusion.debugger.events.CFDebugEvent;
import coldfusion.debugger.events.CFStepEvent;
import coldfusion.debugger.rds.handler.DebugEventsHandler;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.rds.WddxUtils;
import coldfusion.security.ESAPIUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DebugCommandHandler {
    public static final int STEP_INTO = 1;
    public static final int STEP_OVER = 2;
    public static final int STEP_OUT = 3;

    public static int handleRequest(RdsRequest req, RdsResponse resp, CFJVMDebugManager dbgMgr) {
        CFDebuggerLogger.log(req);
        String sessionId = req.getMetaString(1);
        String wddxString = req.getMetaString(2);
        Object wddxObject = null;
        try {
            wddxObject = WddxUtils.readObject((String)wddxString);
            Vector objs = (Vector)wddxObject;
            for (Map commandStruct : objs) {
                DebugCommandHandler.executeCommand(sessionId, commandStruct, resp, dbgMgr);
            }
        }
        catch (Throwable e) {
            resp.setError(e);
        }
        CFDebuggerLogger.log(resp);
        return 1;
    }

    public static void executeCommand(String sessionId, Map commandStruct, RdsResponse resp, CFJVMDebugManager dbgMgr) throws Throwable {
        String commandType = (String)commandStruct.get("COMMAND");
        if (commandType.equals("SET_BREAKPOINT")) {
            DebugCommandHandler.setBreakPoint(sessionId, commandStruct, dbgMgr);
        } else if (commandType.equals("UNSET_BREAKPOINT")) {
            DebugCommandHandler.unsetBreakPoint(sessionId, commandStruct, dbgMgr);
        } else if (commandType.equals("STEP_OVER")) {
            DebugCommandHandler.stepOver(sessionId, commandStruct, dbgMgr);
        } else if (commandType.equals("STEP_IN")) {
            DebugCommandHandler.stepInto(sessionId, commandStruct, dbgMgr);
        } else if (commandType.equals("STEP_OUT")) {
            DebugCommandHandler.stepOut(sessionId, commandStruct, dbgMgr);
        } else if (commandType.equals("CONTINUE")) {
            DebugCommandHandler.continueExecution(sessionId, commandStruct, dbgMgr);
        } else if (commandType.equals("SET_SCOPE_FILTER")) {
            DebugCommandHandler.setScopeFilter(sessionId, commandStruct, dbgMgr);
        } else if (commandType.equals("SET_VARIABLE_VALUE")) {
            DebugCommandHandler.setCFVariableValue(sessionId, commandStruct, dbgMgr);
        } else if (commandType.equals("GET_CF_VARIABLES")) {
            DebugCommandHandler.getCFVariables(sessionId, commandStruct, dbgMgr, resp);
        } else if (commandType.equals("GET_SINGLE_CF_VARIABLE")) {
            DebugCommandHandler.getSingleCFVariable(sessionId, commandStruct, dbgMgr, resp);
        } else if (commandType.equals("SET_WATCH_VARIABLES")) {
            DebugCommandHandler.setWatchVariableNames(sessionId, commandStruct, dbgMgr);
        } else if (commandType.equals("UNSET_ALL_BREAKPOINTS")) {
            DebugCommandHandler.unsetAllBreakpoints(sessionId, dbgMgr);
        } else if (commandType.equals("GET_OUTPUT")) {
            DebugCommandHandler.getCFOutput(sessionId, commandStruct, dbgMgr, resp);
        } else if (commandType.equals("SYNC_STEP_OVER")) {
            DebugCommandHandler.syncStep(sessionId, commandStruct, dbgMgr, 2, resp);
        } else if (commandType.equals("SYNC_STEP_IN")) {
            DebugCommandHandler.syncStep(sessionId, commandStruct, dbgMgr, 1, resp);
        } else if (commandType.equals("SYNC_STEP_OUT")) {
            DebugCommandHandler.syncStep(sessionId, commandStruct, dbgMgr, 3, resp);
        } else if (commandType.equals("GLOBAL_BREAK_ON_EXCEPTION")) {
            DebugCommandHandler.setGlobalBreakOnException(commandStruct, dbgMgr, resp);
        } else if (commandType.equals("SESSION_BREAK_ON_EXCEPTION")) {
            DebugCommandHandler.setSessionBreakOnException(sessionId, commandStruct, dbgMgr, resp);
        } else {
            throw new NoSuchMethodException(ESAPIUtils.encodeForHTML((String)commandType, (boolean)false));
        }
    }

    private static void setScopeFilter(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr) {
        String scopeNames = (String)commandStruct.remove("FILTER");
        dbgMgr.setScopeFilter(sessionId, scopeNames);
    }

    public static void setBreakPoint(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr) throws Throwable {
        String rdsFilePath = (String)commandStruct.remove("FILE");
        Double lineNum = (Double)commandStruct.remove("Y");
        dbgMgr.setBreakPoint(sessionId, rdsFilePath, lineNum.intValue());
    }

    public static void stepOver(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr) throws Throwable {
        String threadName = (String)commandStruct.remove("THREAD");
        dbgMgr.step(threadName, sessionId, 2);
    }

    public static void stepInto(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr) throws Throwable {
        String threadName = (String)commandStruct.remove("THREAD");
        dbgMgr.step(threadName, sessionId, 1);
    }

    public static void stepOut(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr) throws Throwable {
        String threadName = (String)commandStruct.remove("THREAD");
        dbgMgr.step(threadName, sessionId, 3);
    }

    public static void syncStep(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr, int depth, RdsResponse resp) throws Throwable {
        String threadName = (String)commandStruct.remove("THREAD");
        ArrayList stepEvents = dbgMgr.step(threadName, sessionId, depth, true, 0L);
        if (stepEvents == null) {
            return;
        }
        Vector<Map> vec = new Vector<Map>();
        for (CFDebugEvent evt : stepEvents) {
            if (!(evt instanceof CFStepEvent)) continue;
            vec.add(DebugEventsHandler.wrapBasicEvent(evt));
        }
        if (vec.size() == 0) {
            return;
        }
        String wddxString = WddxUtils.writeObject(vec);
        resp.addMetaData(wddxString);
    }

    private static void continueExecution(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr) throws Throwable {
        String threadName = (String)commandStruct.remove("THREAD");
        dbgMgr.resumeExecution(sessionId, threadName);
    }

    private static void setCFVariableValue(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr) throws Throwable {
        String threadName = (String)commandStruct.remove("THREAD");
        String varName = (String)commandStruct.remove("VARIABLE_NAME");
        String value = (String)commandStruct.remove("VARIABLE_VALUE");
        dbgMgr.setCFVariableValue(sessionId, threadName, varName, value);
    }

    private static void getCFVariables(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr, RdsResponse resp) throws Throwable {
        String threadName = (String)commandStruct.remove("THREAD");
        HashMap cfVars = dbgMgr.getCFVariables(sessionId, threadName);
        Vector<HashMap> vec = new Vector<HashMap>();
        vec.add(cfVars);
        String wddxString = WddxUtils.writeObject(vec);
        resp.addMetaData(wddxString);
    }

    private static void getSingleCFVariable(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr, RdsResponse resp) throws Throwable {
        String threadName = (String)commandStruct.remove("THREAD");
        String varName = (String)commandStruct.remove("VARIABLE_NAME");
        HashMap cfVars = dbgMgr.getSingleCFVariable(sessionId, threadName, varName);
        Vector<HashMap> vec = new Vector<HashMap>();
        vec.add(cfVars);
        String wddxString = WddxUtils.writeObject(vec);
        resp.addMetaData(wddxString);
    }

    private static void setWatchVariableNames(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr) throws Throwable {
        Vector watchVarsObj = (Vector)commandStruct.remove("WATCH");
        String[] watchVars = new String[watchVarsObj.size()];
        for (int i = 0; i < watchVarsObj.size(); ++i) {
            watchVars[i] = watchVarsObj.get(i).toString();
        }
        commandStruct.clear();
        dbgMgr.setWatchVariables(sessionId, watchVars);
    }

    private static void unsetBreakPoint(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr) throws Throwable {
        String rdsFilePath = (String)commandStruct.remove("FILE");
        Double lineNum = (Double)commandStruct.remove("Y");
        dbgMgr.removeBreakpoint(sessionId, rdsFilePath, lineNum.intValue());
    }

    private static void unsetAllBreakpoints(String sessionId, CFJVMDebugManager dbgMgr) throws Throwable {
        dbgMgr.removeallBreakpoints(sessionId);
    }

    private static void getCFOutput(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr, RdsResponse resp) throws Throwable {
        String threadName = (String)commandStruct.remove("THREAD");
        Object obj = commandStruct.remove("BODY_ONLY");
        boolean bodyOnly = false;
        if (obj != null && ((Boolean)obj).booleanValue()) {
            bodyOnly = true;
        }
        String cfOutput = dbgMgr.getCFOutput(sessionId, threadName, bodyOnly);
        Vector vec = new Vector();
        HashMap<String, String> outputMap = new HashMap<String, String>();
        outputMap.put("CF_OUTPUT", cfOutput);
        vec.add(outputMap);
        String wddxString = WddxUtils.writeObject(vec);
        resp.addMetaData(wddxString);
    }

    private static void setSessionBreakOnException(String sessionId, Map commandStruct, CFJVMDebugManager dbgMgr, RdsResponse resp) throws Throwable {
        Object obj = commandStruct.remove("BREAK_ON_EXCEPTION");
        boolean doBreak = false;
        if (obj != null && ((Boolean)obj).booleanValue()) {
            doBreak = true;
        }
        dbgMgr.setBreakOnException(sessionId, doBreak);
    }

    private static void setGlobalBreakOnException(Map commandStruct, CFJVMDebugManager dbgMgr, RdsResponse resp) throws Throwable {
        Object obj = commandStruct.remove("BREAK_ON_EXCEPTION");
        boolean doBreak = false;
        if (obj != null && ((Boolean)obj).booleanValue()) {
            doBreak = true;
        }
        dbgMgr.setBreakOnException(doBreak);
    }
}

