/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds;

import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.rds.DebuggerServlet;
import coldfusion.debugger.rds.IdeDefaultServlet;
import coldfusion.debugger.rds.RdsHttpResponseFormatter;
import coldfusion.rds.RdsGlobals;
import coldfusion.security.ESAPIUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RdsFrontEndServlet
extends HttpServlet
implements RdsGlobals {
    private static final boolean debug = false;
    private Map _servlets = new HashMap();
    private static final String DEBUGGER_SERVLET_NAME = "DBGREQUEST";
    private Thread shutDownHandlerThread = new Thread(){

        @Override
        public void run() {
            RdsFrontEndServlet.this.stopDebugger(false);
        }
    };

    public void init() throws ServletException {
        this.loadServlet("IDE_DEFAULT", IdeDefaultServlet.class);
        this.loadServlet(DEBUGGER_SERVLET_NAME, DebuggerServlet.class);
        Runtime.getRuntime().addShutdownHook(this.shutDownHandlerThread);
    }

    private void stopDebugger(boolean cfShutdown) {
        Servlet svr = this.getServlet(DEBUGGER_SERVLET_NAME);
        if (svr != null) {
            DebuggerServlet dbgSer = (DebuggerServlet)svr;
            dbgSer.stopDebugger(cfShutdown);
        } else {
            System.exit(1);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String cmd = req.getParameter("cmd");
        if (cmd != null && cmd.equals("CLOSE")) {
            String cfShutdownStr = req.getParameter("cfshutdown");
            cfShutdownStr = cfShutdownStr == null ? "false" : cfShutdownStr;
            boolean cfShutdown = false;
            if (cfShutdownStr.equalsIgnoreCase("true")) {
                cfShutdown = true;
            }
            this.stopDebugger(cfShutdown);
        } else {
            System.exit(1);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.debug("enter RdsFrontEndServlet.service()");
        try {
            Map qString;
            String[] str;
            String action = req.getParameter("ACTION");
            if (action == null && (str = (String[])(qString = (Map)req.getAttribute("__cfmx__query_string")).get("ACTION")) != null) {
                action = str[0];
            }
            if (action == null) {
                throw new ServletException("Could not locate Action attribute in request, RDS operation not defined");
            }
            Servlet servlet = this.getServlet(action = action.toUpperCase());
            if (servlet == null) {
                throw new ServletException("Operation not supported: " + ESAPIUtils.encodeForHTML((String)action, (boolean)false));
            }
            servlet.service((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            Throwable tmpRoot = e;
            ServletException root = null;
            while (root == null) {
                if (tmpRoot instanceof ServletException) {
                    Throwable se = tmpRoot;
                    if (se.getRootCause() == null) {
                        root = se;
                        continue;
                    }
                    tmpRoot = se.getRootCause();
                    continue;
                }
                root = tmpRoot;
            }
            RdsHttpResponseFormatter rl = new RdsHttpResponseFormatter();
            rl.setError(e.getMessage(), root);
            resp.getOutputStream().write(rl.getMessageBytes());
        }
        catch (Throwable th) {
            CFDebuggerLogger.log(th);
            RdsHttpResponseFormatter rl = new RdsHttpResponseFormatter();
            rl.setError(th.getMessage(), th);
            resp.getOutputStream().write(rl.getMessageBytes());
            this.log("Error occurred!:" + new String(rl.getMessageBytes()));
        }
        this.debug("exit dsFrontEndServlet.service()");
    }

    void debug(String message) {
    }

    public String getInitParameter(String name) {
        String value = this.getServletConfig().getInitParameter(name);
        if (value == null) {
            value = this.getServletContext().getInitParameter(name);
        }
        return value;
    }

    public void destroy() {
        for (String name : this._servlets.keySet()) {
            Servlet s = (Servlet)this._servlets.get(name);
            s.destroy();
        }
    }

    private Servlet getServlet(String action) {
        return (Servlet)this._servlets.get(action);
    }

    private void loadServlet(String name, Class cls) throws ServletException {
        try {
            Servlet s = (Servlet)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            s.init(this.getServletConfig());
            this._servlets.put(name, s);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void log(String msg) {
    }

    public void log(String msg, Throwable t) {
        CFDebuggerLogger.log(t);
    }
}

