/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.test;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.smpp.ServerPDUEvent;
import org.smpp.ServerPDUEventListener;
import org.smpp.Session;
import org.smpp.SmppObject;
import org.smpp.TCPIPConnection;
import org.smpp.debug.Debug;
import org.smpp.debug.Event;
import org.smpp.debug.FileDebug;
import org.smpp.debug.FileEvent;
import org.smpp.pdu.Address;
import org.smpp.pdu.AddressRange;
import org.smpp.pdu.BindReceiver;
import org.smpp.pdu.BindRequest;
import org.smpp.pdu.BindResponse;
import org.smpp.pdu.BindTransciever;
import org.smpp.pdu.BindTransmitter;
import org.smpp.pdu.CancelSM;
import org.smpp.pdu.CancelSMResp;
import org.smpp.pdu.DataSM;
import org.smpp.pdu.DataSMResp;
import org.smpp.pdu.DestinationAddress;
import org.smpp.pdu.EnquireLink;
import org.smpp.pdu.EnquireLinkResp;
import org.smpp.pdu.PDU;
import org.smpp.pdu.QuerySM;
import org.smpp.pdu.QuerySMResp;
import org.smpp.pdu.ReplaceSM;
import org.smpp.pdu.ReplaceSMResp;
import org.smpp.pdu.Request;
import org.smpp.pdu.Response;
import org.smpp.pdu.SubmitMultiSM;
import org.smpp.pdu.SubmitMultiSMResp;
import org.smpp.pdu.SubmitSM;
import org.smpp.pdu.SubmitSMResp;
import org.smpp.pdu.UnbindResp;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.Queue;

public class SMPPTest {
    static final String copyright = "Copyright (c) 1996-2001 Logica Mobile Networks Limited\nThis product includes software developed by Logica by whom copyright\nand know-how are retained, all rights reserved.\n";
    static final String version = "SMPP Open Source test & demonstration application, version 1.1\n";
    static final String dbgDir = "./";
    static Debug debug;
    static Event event;
    static String propsFilePath;
    static BufferedReader keyboard;
    static Session session;
    Properties properties = new Properties();
    boolean bound = false;
    private boolean keepRunning = true;
    String ipAddress = null;
    int port = 0;
    String systemId = null;
    String password = null;
    String bindOption = "t";
    boolean asynchronous = false;
    SMPPTestPDUEventListener pduListener = null;
    AddressRange addressRange = new AddressRange();
    String systemType = "";
    String serviceType = "";
    Address sourceAddress = new Address();
    Address destAddress = new Address();
    String scheduleDeliveryTime = "";
    String validityPeriod = "";
    String shortMessage = "";
    String phoneNum = "";
    byte ton = 1;
    byte npi = 1;
    int numberOfDestination = 1;
    String messageId = "";
    byte esmClass = 0;
    byte protocolId = 0;
    byte priorityFlag = 0;
    byte registeredDelivery = 0;
    byte replaceIfPresentFlag = 0;
    byte dataCoding = 0;
    byte smDefaultMsgId = 0;
    long receiveTimeout = -1L;

    public SMPPTest() throws IOException {
        this.loadProperties(propsFilePath);
    }

    public static void main(String[] args) {
        System.out.println("Initialising...");
        debug.activate();
        event.activate();
        SmppObject.setDebug(debug);
        SmppObject.setEvent(event);
        SMPPTest test = null;
        try {
            test = new SMPPTest();
        }
        catch (IOException e) {
            event.write(e, "");
            debug.write("exception initialising SMPPTest " + e);
            System.out.println("Exception initialising SMPPTest " + e);
        }
        if (test != null) {
            test.menu();
        }
    }

    public void menu() {
        this.keepRunning = true;
        String option = "1";
        block16: while (this.keepRunning) {
            System.out.println();
            System.out.println("-  1 bind");
            System.out.println("-  2 submit (t/tr)");
            System.out.println("-  3 submit multi (t/tr)");
            System.out.println("-  4 data (t/tr)");
            System.out.println("-  5 query (t/tr)");
            System.out.println("-  6 replace (t/tr)");
            System.out.println("-  7 cancel (t/tr)");
            System.out.println("-  8 enquire link (t/tr)");
            System.out.println("-  9 unbind");
            System.out.println("- 10 receive message (tr/r)");
            System.out.println("-  0 exit");
            System.out.print("> ");
            int optionInt = -1;
            try {
                option = keyboard.readLine();
                optionInt = Integer.parseInt(option);
            }
            catch (Exception e) {
                debug.write("exception reading keyboard " + e);
                optionInt = -1;
            }
            switch (optionInt) {
                case 1: {
                    this.bind();
                    continue block16;
                }
                case 2: {
                    this.submit();
                    continue block16;
                }
                case 3: {
                    this.submitMulti();
                    continue block16;
                }
                case 4: {
                    this.data();
                    continue block16;
                }
                case 5: {
                    this.query();
                    continue block16;
                }
                case 6: {
                    this.replace();
                    continue block16;
                }
                case 7: {
                    this.cancel();
                    continue block16;
                }
                case 8: {
                    this.enquireLink();
                    continue block16;
                }
                case 9: {
                    this.unbind();
                    continue block16;
                }
                case 10: {
                    this.receive();
                    continue block16;
                }
                case 0: {
                    this.exit();
                    continue block16;
                }
                case -1: {
                    continue block16;
                }
            }
            System.out.println("Invalid option. Choose between 0 and 10.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind() {
        debug.enter(this, "SMPPTest.bind()");
        try {
            if (this.bound) {
                System.out.println("Already bound, unbind first.");
                return;
            }
            BindRequest request = null;
            BindResponse response = null;
            String syncMode = this.asynchronous ? "a" : "s";
            if ((syncMode = this.getParam("Asynchronous/Synchronnous Session? (a/s)", syncMode)).compareToIgnoreCase("a") == 0) {
                this.asynchronous = true;
            } else if (syncMode.compareToIgnoreCase("s") == 0) {
                this.asynchronous = false;
            } else {
                System.out.println("Invalid mode async/sync, expected a or s, got " + syncMode + ". Operation canceled.");
                return;
            }
            this.bindOption = this.getParam("Transmitter/Receiver/Transciever (t/r/tr)", this.bindOption);
            if (this.bindOption.compareToIgnoreCase("t") == 0) {
                request = new BindTransmitter();
            } else if (this.bindOption.compareToIgnoreCase("r") == 0) {
                request = new BindReceiver();
            } else if (this.bindOption.compareToIgnoreCase("tr") == 0) {
                request = new BindTransciever();
            } else {
                System.out.println("Invalid bind mode, expected t, r or tr, got " + this.bindOption + ". Operation canceled.");
                return;
            }
            this.ipAddress = this.getParam("IP address of SMSC", this.ipAddress);
            this.port = this.getParam("Port number", this.port);
            TCPIPConnection connection = new TCPIPConnection(this.ipAddress, this.port);
            connection.setReceiveTimeout(20000L);
            session = new Session(connection);
            this.systemId = this.getParam("Your system ID", this.systemId);
            this.password = this.getParam("Your password", this.password);
            this.phoneNum = this.getParam("Your phone number", this.phoneNum);
            request.setSystemId(this.systemId);
            request.setPassword(this.password);
            request.setSystemType(this.systemType);
            request.setInterfaceVersion((byte)52);
            this.addressRange.setTon(this.ton);
            this.addressRange.setNpi(this.npi);
            this.addressRange.setAddressRange(this.phoneNum);
            request.setAddressRange(this.addressRange);
            System.out.println("Bind request " + request.debugString());
            if (this.asynchronous) {
                this.pduListener = new SMPPTestPDUEventListener(session);
                response = session.bind(request, this.pduListener);
            } else {
                response = session.bind(request);
            }
            System.out.println("Bind response " + response.debugString());
            if (response.getCommandStatus() == 0) {
                this.bound = true;
            }
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Bind operation failed. " + e);
            System.out.println("Bind operation failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() {
        debug.enter(this, "SMPPTest.unbind()");
        try {
            if (!this.bound) {
                System.out.println("Not bound, cannot unbind.");
                return;
            }
            System.out.println("Going to unbind.");
            if (session.getReceiver().isReceiver()) {
                System.out.println("It can take a while to stop the receiver.");
            }
            UnbindResp response = session.unbind();
            System.out.println("Unbind response " + response.debugString());
            this.bound = false;
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Unbind operation failed. " + e);
            System.out.println("Unbind operation failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit() {
        debug.enter(this, "SMPPTest.submit()");
        try {
            SubmitSM request = new SubmitSM();
            this.serviceType = this.getParam("Service type", this.serviceType);
            this.sourceAddress = this.getAddress("Source", this.sourceAddress);
            this.destAddress = this.getAddress("Destination", this.destAddress);
            this.replaceIfPresentFlag = this.getParam("Replace if present flag", this.replaceIfPresentFlag);
            this.shortMessage = this.getParam("The short message", this.shortMessage);
            this.scheduleDeliveryTime = this.getParam("Schedule delivery time", this.scheduleDeliveryTime);
            this.validityPeriod = this.getParam("Validity period", this.validityPeriod);
            this.esmClass = this.getParam("Esm class", this.esmClass);
            this.protocolId = this.getParam("Protocol id", this.protocolId);
            this.priorityFlag = this.getParam("Priority flag", this.priorityFlag);
            this.registeredDelivery = this.getParam("Registered delivery", this.registeredDelivery);
            this.dataCoding = this.getParam("Data encoding", this.dataCoding);
            this.smDefaultMsgId = this.getParam("Sm default msg id", this.smDefaultMsgId);
            request.setServiceType(this.serviceType);
            request.setSourceAddr(this.sourceAddress);
            request.setDestAddr(this.destAddress);
            request.setReplaceIfPresentFlag(this.replaceIfPresentFlag);
            request.setShortMessage(this.shortMessage);
            request.setScheduleDeliveryTime(this.scheduleDeliveryTime);
            request.setValidityPeriod(this.validityPeriod);
            request.setEsmClass(this.esmClass);
            request.setProtocolId(this.protocolId);
            request.setPriorityFlag(this.priorityFlag);
            request.setRegisteredDelivery(this.registeredDelivery);
            request.setDataCoding(this.dataCoding);
            request.setSmDefaultMsgId(this.smDefaultMsgId);
            int count = 1;
            System.out.println();
            count = this.getParam("How many times to submit this message (load test)", count);
            for (int i = 0; i < count; ++i) {
                request.assignSequenceNumber(true);
                System.out.print("#" + i + "  ");
                System.out.println("Submit request " + request.debugString());
                if (this.asynchronous) {
                    session.submit(request);
                    System.out.println();
                    continue;
                }
                SubmitSMResp response = session.submit(request);
                System.out.println("Submit response " + response.debugString());
                this.messageId = response.getMessageId();
            }
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Submit operation failed. " + e);
            System.out.println("Submit operation failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitMulti() {
        debug.enter(this, "SMPPTest.submitMulti()");
        try {
            SubmitMultiSM request = new SubmitMultiSM();
            this.serviceType = this.getParam("Service type", this.serviceType);
            this.sourceAddress = this.getAddress("Source", this.sourceAddress);
            this.numberOfDestination = this.getParam("Number of destinations", this.numberOfDestination);
            for (int i = 0; i < this.numberOfDestination; ++i) {
                request.addDestAddress(new DestinationAddress(this.getAddress("Destination", this.destAddress)));
            }
            this.replaceIfPresentFlag = this.getParam("Replace if present flag", this.replaceIfPresentFlag);
            this.shortMessage = this.getParam("The short message", this.shortMessage);
            this.scheduleDeliveryTime = this.getParam("Schdule delivery time", this.scheduleDeliveryTime);
            this.validityPeriod = this.getParam("Validity period", this.validityPeriod);
            this.esmClass = this.getParam("Esm class", this.esmClass);
            this.protocolId = this.getParam("Protocol id", this.protocolId);
            this.priorityFlag = this.getParam("Priority flag", this.priorityFlag);
            this.registeredDelivery = this.getParam("Registered delivery", this.registeredDelivery);
            this.dataCoding = this.getParam("Data encoding", this.dataCoding);
            this.smDefaultMsgId = this.getParam("Sm default msg id", this.smDefaultMsgId);
            request.setServiceType(this.serviceType);
            request.setSourceAddr(this.sourceAddress);
            request.setReplaceIfPresentFlag(this.replaceIfPresentFlag);
            request.setShortMessage(this.shortMessage);
            request.setScheduleDeliveryTime(this.scheduleDeliveryTime);
            request.setValidityPeriod(this.validityPeriod);
            request.setEsmClass(this.esmClass);
            request.setProtocolId(this.protocolId);
            request.setPriorityFlag(this.priorityFlag);
            request.setRegisteredDelivery(this.registeredDelivery);
            request.setDataCoding(this.dataCoding);
            request.setSmDefaultMsgId(this.smDefaultMsgId);
            System.out.println("Submit Multi request " + request.debugString());
            if (this.asynchronous) {
                session.submitMulti(request);
            } else {
                SubmitMultiSMResp response = session.submitMulti(request);
                System.out.println("Submit Multi response " + response.debugString());
                this.messageId = response.getMessageId();
            }
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Submit Multi operation failed. " + e);
            System.out.println("Submit Multi operation failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replace() {
        debug.enter(this, "SMPPTest.replace()");
        try {
            ReplaceSM request = new ReplaceSM();
            this.messageId = this.getParam("Message id", this.messageId);
            this.sourceAddress = this.getAddress("Source", this.sourceAddress);
            this.shortMessage = this.getParam("The short message", this.shortMessage);
            this.scheduleDeliveryTime = this.getParam("Schedule delivery time", this.scheduleDeliveryTime);
            this.validityPeriod = this.getParam("Validity period", this.validityPeriod);
            this.registeredDelivery = this.getParam("Registered delivery", this.registeredDelivery);
            this.smDefaultMsgId = this.getParam("Sm default msg id", this.smDefaultMsgId);
            request.setMessageId(this.messageId);
            request.setSourceAddr(this.sourceAddress);
            request.setShortMessage(this.shortMessage);
            request.setScheduleDeliveryTime(this.scheduleDeliveryTime);
            request.setValidityPeriod(this.validityPeriod);
            request.setRegisteredDelivery(this.registeredDelivery);
            request.setSmDefaultMsgId(this.smDefaultMsgId);
            System.out.println("Replace request " + request.debugString());
            if (this.asynchronous) {
                session.replace(request);
            } else {
                ReplaceSMResp response = session.replace(request);
                System.out.println("Replace response " + response.debugString());
            }
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Replace operation failed. " + e);
            System.out.println("Replace operation failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        debug.enter(this, "SMPPTest.cancel()");
        try {
            CancelSM request = new CancelSM();
            this.serviceType = this.getParam("Service type", this.serviceType);
            this.messageId = this.getParam("Message id", this.messageId);
            this.sourceAddress = this.getAddress("Source", this.sourceAddress);
            this.destAddress = this.getAddress("Destination", this.destAddress);
            request.setServiceType(this.serviceType);
            request.setMessageId(this.messageId);
            request.setSourceAddr(this.sourceAddress);
            request.setDestAddr(this.destAddress);
            System.out.println("Cancel request " + request.debugString());
            if (this.asynchronous) {
                session.cancel(request);
            } else {
                CancelSMResp response = session.cancel(request);
                System.out.println("Cancel response " + response.debugString());
            }
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Cancel operation failed. " + e);
            System.out.println("Cancel operation failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void data() {
        debug.enter(this, "SMPPTest.data()");
        try {
            DataSM request = new DataSM();
            this.serviceType = this.getParam("Service type", this.serviceType);
            this.sourceAddress = this.getAddress("Source", this.sourceAddress, 65);
            this.destAddress = this.getAddress("Destination", this.destAddress, 65);
            this.esmClass = this.getParam("Esm class", this.esmClass);
            this.registeredDelivery = this.getParam("Registered delivery", this.registeredDelivery);
            this.dataCoding = this.getParam("Data encoding", this.dataCoding);
            request.setServiceType(this.serviceType);
            request.setSourceAddr(this.sourceAddress);
            request.setDestAddr(this.destAddress);
            request.setEsmClass(this.esmClass);
            request.setRegisteredDelivery(this.registeredDelivery);
            request.setDataCoding(this.dataCoding);
            System.out.println("Data request " + request.debugString());
            if (this.asynchronous) {
                session.data(request);
            } else {
                DataSMResp response = session.data(request);
                System.out.println("Data response " + response.debugString());
                this.messageId = response.getMessageId();
            }
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Data operation failed. " + e);
            System.out.println("Data operation failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void query() {
        debug.enter(this, "SMPPTest.query()");
        try {
            QuerySM request = new QuerySM();
            this.messageId = this.getParam("Message id", this.messageId);
            this.sourceAddress = this.getAddress("Source", this.sourceAddress);
            request.setMessageId(this.messageId);
            request.setSourceAddr(this.sourceAddress);
            System.out.println("Query request " + request.debugString());
            if (this.asynchronous) {
                session.query(request);
            } else {
                QuerySMResp response = session.query(request);
                System.out.println("Query response " + response.debugString());
                this.messageId = response.getMessageId();
            }
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Query operation failed. " + e);
            System.out.println("Query operation failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enquireLink() {
        debug.enter(this, "SMPPTest.enquireLink()");
        try {
            EnquireLink request = new EnquireLink();
            System.out.println("Enquire Link request " + request.debugString());
            if (this.asynchronous) {
                session.enquireLink(request);
            } else {
                EnquireLinkResp response = session.enquireLink(request);
                System.out.println("Enquire Link response " + response.debugString());
            }
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Enquire Link operation failed. " + e);
            System.out.println("Enquire Link operation failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive() {
        debug.enter(this, "SMPPTest.receive()");
        try {
            PDU pdu = null;
            System.out.print("Going to receive a PDU. ");
            if (this.receiveTimeout == -1L) {
                System.out.print("The receive is blocking, i.e. the application will stop until a PDU will be received.");
            } else {
                System.out.print("The receive timeout is " + this.receiveTimeout / 1000L + " sec.");
            }
            System.out.println();
            if (this.asynchronous) {
                ServerPDUEvent pduEvent = this.pduListener.getRequestEvent(this.receiveTimeout);
                if (pduEvent != null) {
                    pdu = pduEvent.getPDU();
                }
            } else {
                pdu = session.receive(this.receiveTimeout);
            }
            if (pdu != null) {
                System.out.println("Received PDU " + pdu.debugString());
                if (pdu.isRequest()) {
                    Response response = ((Request)pdu).getResponse();
                    System.out.println("Going to send default response to request " + response.debugString());
                    session.respond(response);
                }
            } else {
                System.out.println("No PDU received this time.");
            }
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Receiving failed. " + e);
            System.out.println("Receiving failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    private void exit() {
        debug.enter(this, "SMPPTest.exit()");
        if (this.bound) {
            this.unbind();
        }
        this.keepRunning = false;
        debug.exit(this);
    }

    private String getParam(String prompt, String defaultValue) {
        String value = "";
        String promptFull = prompt;
        promptFull = promptFull + (defaultValue == null ? "" : " [" + defaultValue + "] ");
        System.out.print(promptFull);
        try {
            value = keyboard.readLine();
        }
        catch (IOException e) {
            event.write(e, "");
            debug.write("Got exception getting a param. " + e);
        }
        if (value.compareTo("") == 0) {
            return defaultValue;
        }
        return value;
    }

    private byte getParam(String prompt, byte defaultValue) {
        return Byte.parseByte(this.getParam(prompt, Byte.toString(defaultValue)));
    }

    private int getParam(String prompt, int defaultValue) {
        return Integer.parseInt(this.getParam(prompt, Integer.toString(defaultValue)));
    }

    private Address getAddress(String type, Address address, int maxAddressLength) throws WrongLengthOfStringException {
        byte ton = this.getParam(type + " address TON", address.getTon());
        byte npi = this.getParam(type + " address NPI", address.getNpi());
        String addr = this.getParam(type + " address", address.getAddress());
        address.setTon(ton);
        address.setNpi(npi);
        address.setAddress(addr, maxAddressLength);
        return address;
    }

    private Address getAddress(String type, Address address) throws WrongLengthOfStringException {
        return this.getAddress(type, address, 21);
    }

    private void loadProperties(String fileName) throws IOException {
        System.out.println("Reading configuration file " + fileName + "...");
        FileInputStream propsFile = new FileInputStream(fileName);
        this.properties.load(propsFile);
        propsFile.close();
        System.out.println("Setting default parameters...");
        this.ipAddress = this.properties.getProperty("ip-address");
        this.port = this.getIntProperty("port", this.port);
        this.systemId = this.properties.getProperty("system-id");
        this.password = this.properties.getProperty("password");
        byte ton = this.getByteProperty("addr-ton", this.addressRange.getTon());
        byte npi = this.getByteProperty("addr-npi", this.addressRange.getNpi());
        String addr = this.properties.getProperty("address-range", this.addressRange.getAddressRange());
        this.addressRange.setTon(ton);
        this.addressRange.setNpi(npi);
        try {
            this.addressRange.setAddressRange(addr);
        }
        catch (WrongLengthOfStringException e) {
            System.out.println("The length of address-range parameter is wrong.");
        }
        ton = this.getByteProperty("source-ton", this.sourceAddress.getTon());
        npi = this.getByteProperty("source-npi", this.sourceAddress.getNpi());
        addr = this.properties.getProperty("source-address", this.sourceAddress.getAddress());
        this.setAddressParameter("source-address", this.sourceAddress, ton, npi, addr);
        ton = this.getByteProperty("destination-ton", this.destAddress.getTon());
        npi = this.getByteProperty("destination-npi", this.destAddress.getNpi());
        addr = this.properties.getProperty("destination-address", this.destAddress.getAddress());
        this.setAddressParameter("destination-address", this.destAddress, ton, npi, addr);
        this.serviceType = this.properties.getProperty("service-type", this.serviceType);
        this.systemType = this.properties.getProperty("system-type", this.systemType);
        String bindMode = this.properties.getProperty("bind-mode", this.bindOption);
        if (bindMode.equalsIgnoreCase("transmitter")) {
            bindMode = "t";
        } else if (bindMode.equalsIgnoreCase("receiver")) {
            bindMode = "r";
        } else if (bindMode.equalsIgnoreCase("transciever")) {
            bindMode = "tr";
        } else if (!(bindMode.equalsIgnoreCase("t") || bindMode.equalsIgnoreCase("r") || bindMode.equalsIgnoreCase("tr"))) {
            System.out.println("The value of bind-mode parameter in the configuration file " + fileName + " is wrong. " + "Setting the default");
            bindMode = "t";
        }
        this.bindOption = bindMode;
        int rcvTimeout = this.receiveTimeout == -1L ? -1 : (int)this.receiveTimeout / 1000;
        rcvTimeout = this.getIntProperty("receive-timeout", rcvTimeout);
        this.receiveTimeout = rcvTimeout == -1 ? -1L : (long)(rcvTimeout * 1000);
        String syncMode = this.properties.getProperty("sync-mode", this.asynchronous ? "async" : "sync");
        this.asynchronous = syncMode.equalsIgnoreCase("sync") ? false : syncMode.equalsIgnoreCase("async");
    }

    private byte getByteProperty(String propName, byte defaultValue) {
        return Byte.parseByte(this.properties.getProperty(propName, Byte.toString(defaultValue)));
    }

    private int getIntProperty(String propName, int defaultValue) {
        return Integer.parseInt(this.properties.getProperty(propName, Integer.toString(defaultValue)));
    }

    private void setAddressParameter(String descr, Address address, byte ton, byte npi, String addr) {
        address.setTon(ton);
        address.setNpi(npi);
        try {
            address.setAddress(addr);
        }
        catch (WrongLengthOfStringException e) {
            System.out.println("The length of " + descr + " parameter is wrong.");
        }
    }

    static {
        System.out.println(copyright);
        System.out.println(version);
        debug = new FileDebug(dbgDir, "test.dbg");
        event = new FileEvent(dbgDir, "test.evt");
        propsFilePath = "./etc/smpptest.cfg";
        keyboard = new BufferedReader(new InputStreamReader(System.in));
        session = null;
    }

    private class SMPPTestPDUEventListener
    extends SmppObject
    implements ServerPDUEventListener {
        Session session;
        Queue requestEvents = new Queue();

        public SMPPTestPDUEventListener(Session session) {
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ServerPDUEvent event) {
            PDU pdu = event.getPDU();
            if (pdu.isRequest()) {
                System.out.println("async request received, enqueuing " + pdu.debugString());
                Queue queue = this.requestEvents;
                synchronized (queue) {
                    this.requestEvents.enqueue(event);
                    this.requestEvents.notify();
                }
            } else if (pdu.isResponse()) {
                System.out.println("async response received " + pdu.debugString());
            } else {
                System.out.println("pdu of unknown class (not request nor response) received, discarding " + pdu.debugString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServerPDUEvent getRequestEvent(long timeout) {
            ServerPDUEvent pduEvent = null;
            Queue queue = this.requestEvents;
            synchronized (queue) {
                if (this.requestEvents.isEmpty()) {
                    try {
                        this.requestEvents.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!this.requestEvents.isEmpty()) {
                    pduEvent = (ServerPDUEvent)this.requestEvents.dequeue();
                }
            }
            return pduEvent;
        }
    }
}

