/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.smscsim.util;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.smpp.smscsim.util.Attribute;

public class Record {
    private List attributes = new LinkedList();

    public synchronized void set(String name, String value) {
        Attribute attr = this.get(name);
        if (attr == null) {
            attr = new Attribute(name);
            this.attributes.add(attr);
        }
        attr.setValue(value);
    }

    public synchronized void add(Attribute attr) {
        Attribute existing = this.get(attr.getName());
        if (existing != null) {
            existing.setValue(attr.getValue());
        } else {
            this.attributes.add(new Attribute(attr.getName(), attr.getValue()));
        }
    }

    public synchronized Attribute get(String name) {
        ListIterator iter = this.attributes.listIterator(0);
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            if (!attr.nameEquals(name)) continue;
            return attr;
        }
        return null;
    }

    public synchronized String getValue(String name) {
        Attribute attr = this.get(name);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public Attribute get(int i) {
        return (Attribute)this.attributes.get(i);
    }

    public int count() {
        return this.attributes.size();
    }

    public synchronized void remove(String name) {
        Attribute toRemove = this.get(name);
        if (toRemove != null) {
            this.attributes.remove(toRemove);
        }
    }
}

