/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.smscsim;

import java.util.Enumeration;
import java.util.Hashtable;
import org.smpp.pdu.SubmitSM;
import org.smpp.smscsim.ShortMessageValue;

public class ShortMessageStore {
    private Hashtable messages = new Hashtable();

    public synchronized void submit(SubmitSM message, String messageId, String systemId) {
        this.messages.put(messageId, new ShortMessageValue(systemId, message));
    }

    public synchronized void cancel(String messageId) {
        this.messages.remove(messageId);
    }

    public synchronized void replace(String messageId, String newMessage) {
        ShortMessageValue sMV = (ShortMessageValue)this.messages.get(messageId);
        if (sMV != null) {
            sMV.shortMessage = newMessage;
        }
    }

    public synchronized ShortMessageValue getMessage(String messageId) {
        return (ShortMessageValue)this.messages.get(messageId);
    }

    public synchronized void print() {
        if (this.messages.size() != 0) {
            Enumeration keys = this.messages.keys();
            System.out.println("------------------------------------------------------------------------");
            System.out.println("| Msg Id   |Sender     |ServT|Source address |Dest address   |Message   ");
            System.out.println("------------------------------------------------------------------------");
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                ShortMessageValue sMV = (ShortMessageValue)this.messages.get(key);
                this.printMessage(key, sMV);
            }
        } else {
            System.out.println("There is no message in the message store.");
        }
    }

    private void printMessage(Object key, ShortMessageValue sMV) {
        String messageId = key.toString();
        String systemId = this.pad(sMV.systemId, 11);
        String serviceType = sMV.serviceType.equals("") ? "null" : sMV.serviceType;
        serviceType = this.pad(serviceType, 5);
        String sourceAddr = this.pad(sMV.sourceAddr, 15);
        String destAddr = this.pad(sMV.destinationAddr, 15);
        String shortMessage = sMV.shortMessage;
        System.out.println("- " + messageId + " |" + systemId + "|" + serviceType + "|" + sourceAddr + "|" + destAddr + "|" + shortMessage);
    }

    private String pad(String data, int length) {
        String result;
        if (data == null) {
            data = "";
        }
        if (data.length() > length) {
            result = data.substring(1, length + 1);
        } else {
            int padCount = length - data.length();
            result = data;
            for (int i = 1; i <= padCount; ++i) {
                result = result + " ";
            }
        }
        return result;
    }
}

