/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.smscsim;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.smpp.SmppObject;
import org.smpp.debug.Debug;
import org.smpp.pdu.DeliverSM;
import org.smpp.pdu.SubmitSM;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.smscsim.PDUProcessor;
import org.smpp.util.ProcessingThread;
import org.smpp.util.Queue;

public class DeliveryInfoSender
extends ProcessingThread {
    public static final int DELIVERED = 0;
    public static final int EXPIRED = 1;
    public static final int DELETED = 2;
    public static final int UNDELIVERABLE = 3;
    public static final int ACCEPTED = 4;
    public static final int UNKNOWN = 5;
    public static final int REJECTED = 6;
    private static final String DLVR_INFO_SENDER_NAME = "DlvrInfoSender";
    private static int dlvrInfoSenderIndex = 0;
    private static final String DELIVERY_RCPT_DATE_FORMAT = "yyMMddHHmm";
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyMMddHHmm");
    private long waitForQueueInterval = 5000L;
    private Debug debug = SmppObject.getDebug();
    private static String[] states = new String[7];
    private Queue submitRequests = new Queue();

    public void submit(PDUProcessor processor, SubmitSM submitRequest, String messageId, int stat, int err) {
        DeliveryInfoEntry entry = new DeliveryInfoEntry(processor, submitRequest, stat, err, messageId);
        this.submitRequests.enqueue(entry);
    }

    public void submit(PDUProcessor processor, SubmitSM submitRequest, String messageId) {
        this.submit(processor, submitRequest, messageId, 0, 0);
    }

    private void deliver(DeliveryInfoEntry entry) {
        this.debug.enter(this, "deliver");
        SubmitSM submit = entry.submit;
        DeliverSM deliver = new DeliverSM();
        deliver.setSourceAddr(submit.getDestAddr());
        deliver.setDestAddr(submit.getDestAddr());
        String msg = "";
        msg = msg + "id:" + entry.messageId + " ";
        msg = msg + "sub:" + entry.sub + " ";
        msg = msg + "dlvrd:" + entry.dlvrd + " ";
        msg = msg + "submit date:" + this.formatDate(entry.submitted) + " ";
        msg = msg + "done date:" + this.formatDate(System.currentTimeMillis()) + " ";
        msg = msg + "stat:" + entry.stat + " ";
        msg = msg + "err:" + entry.err + " ";
        String shortMessage = submit.getShortMessage();
        int msgLen = shortMessage.length();
        msg = msg + "text:" + shortMessage.substring(0, msgLen > 20 ? 20 : msgLen);
        try {
            deliver.setShortMessage(msg);
            deliver.setServiceType(submit.getServiceType());
        }
        catch (WrongLengthOfStringException e) {
            // empty catch block
        }
        try {
            entry.processor.serverRequest(deliver);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.debug.exit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (this.submitRequests.isEmpty()) {
            try {
                Queue queue = this.submitRequests;
                synchronized (queue) {
                    this.submitRequests.wait(this.waitForQueueInterval);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            while (!this.submitRequests.isEmpty()) {
                this.deliver((DeliveryInfoEntry)this.submitRequests.dequeue());
            }
        }
    }

    public String getThreadName() {
        return DLVR_INFO_SENDER_NAME;
    }

    public int getThreadIndex() {
        return ++dlvrInfoSenderIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDate(long ms) {
        SimpleDateFormat simpleDateFormat = this.dateFormatter;
        synchronized (simpleDateFormat) {
            return this.dateFormatter.format(new Date(ms));
        }
    }

    static {
        DeliveryInfoSender.states[0] = "DELIVRD";
        DeliveryInfoSender.states[1] = "EXPIRED";
        DeliveryInfoSender.states[2] = "DELETED";
        DeliveryInfoSender.states[3] = "UNDELIV";
        DeliveryInfoSender.states[4] = "ACCEPTD";
        DeliveryInfoSender.states[5] = "UNKNOWN";
        DeliveryInfoSender.states[6] = "REJECTD";
    }

    protected class DeliveryInfoEntry {
        public PDUProcessor processor;
        public SubmitSM submit;
        public int sub = 1;
        public int dlvrd = 1;
        public int stat;
        public int err;
        public String messageId;
        public long submitted = System.currentTimeMillis();

        public DeliveryInfoEntry(PDUProcessor processor, SubmitSM submit, int stat, int err, String messageId) {
            this.processor = processor;
            this.submit = submit;
            this.stat = stat;
            this.err = err;
            this.messageId = messageId;
        }
    }
}

