/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu;

import org.smpp.pdu.ByteData;
import org.smpp.pdu.ByteDataList;
import org.smpp.pdu.PDUException;
import org.smpp.pdu.Response;
import org.smpp.pdu.TooManyValuesException;
import org.smpp.pdu.UnsuccessSME;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;
import org.smpp.util.TerminatingZeroNotFoundException;

public class SubmitMultiSMResp
extends Response {
    private String messageId = "";
    private UnsuccessSMEsList unsuccessSMEs = new UnsuccessSMEsList();

    public SubmitMultiSMResp() {
        super(-2147483615);
    }

    public void setBody(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TerminatingZeroNotFoundException, PDUException {
        this.setMessageId(buffer.removeCString());
        this.unsuccessSMEs.setData(buffer);
    }

    public ByteBuffer getBody() throws ValueNotSetException {
        ByteBuffer buffer = new ByteBuffer();
        buffer.appendCString(this.messageId);
        buffer.appendBuffer(this.unsuccessSMEs.getData());
        return buffer;
    }

    public void setMessageId(String value) throws WrongLengthOfStringException {
        SubmitMultiSMResp.checkString(value, 64);
        this.messageId = value;
    }

    public void addUnsuccessSME(UnsuccessSME unsuccessSME) throws TooManyValuesException {
        this.unsuccessSMEs.addValue(unsuccessSME);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public short getNoUnsuccess() {
        return (short)this.unsuccessSMEs.getCount();
    }

    public UnsuccessSME getUnsuccessSME(int i) {
        return (UnsuccessSME)this.unsuccessSMEs.getValue(i);
    }

    public String debugString() {
        String dbgs = "(submitmulti_resp: ";
        dbgs = dbgs + super.debugString();
        dbgs = dbgs + this.getMessageId();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.unsuccessSMEs.debugString();
        dbgs = dbgs + " ";
        dbgs = dbgs + this.debugStringOptional();
        dbgs = dbgs + ") ";
        return dbgs;
    }

    private class UnsuccessSMEsList
    extends ByteDataList {
        public UnsuccessSMEsList() {
            super(254, 1);
        }

        public ByteData createValue() {
            return new UnsuccessSME();
        }

        public String debugString() {
            return "(unsuccess_addr_list: " + super.debugString() + ")";
        }
    }
}

