/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.debug;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.smpp.debug.Event;
import org.smpp.debug.FileLog;

public class FileEvent
implements Event {
    private FileLog log = null;

    public FileEvent(String dir, String name) {
        this.log = new FileLog(dir, name);
        this.activate();
    }

    public void write(String msg) {
        if (this.isActive()) {
            this.log.genericWrite(msg == null ? "" : msg);
        }
    }

    public void write(Exception e, String msg) {
        if (this.isActive()) {
            StringWriter stackOutString = new StringWriter();
            PrintWriter stackOut = new PrintWriter(stackOutString);
            e.printStackTrace(stackOut);
            try {
                if (msg != null) {
                    this.write(msg);
                }
                this.write("Exception: " + stackOutString.toString());
            }
            catch (Exception ex) {
                System.err.println("Event log failure " + ex);
            }
        }
    }

    public void activate() {
        if (this.log != null) {
            this.log.activate();
        }
    }

    public void deactivate() {
        if (this.log != null) {
            this.log.deactivate();
        }
    }

    public boolean isActive() {
        return this.log != null ? this.log.isActive() : false;
    }
}

