/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.debug.Debug;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class SourceFrame
extends Frame
implements WindowListener,
ActionListener,
Runnable {
    private TextArea info;
    private String enc;
    private Thread thread;
    private char[] buf;
    private MenuItem msaveas;

    public SourceFrame(Frame parent, char[] buf) {
        this(buf, null);
    }

    public SourceFrame(char[] buf, String enc) {
        super("Page Source");
        this.enc = enc;
        this.buf = buf;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void run() {
        this.info = new TextArea();
        this.info.append(new String(this.buf));
        this.info.setEditable(false);
        this.info.setFont(new Font("Monospaced", 0, 12));
        this.add(this.info);
        this.msaveas = this.createMenuItem("Save as...");
        MenuBar mb = new MenuBar();
        this.setMenuBar(mb);
        Menu mfile = new Menu("File");
        mb.add(mfile);
        mfile.add(this.msaveas);
        this.addWindowListener(this);
        this.setSize(300, 300);
        this.setVisible(true);
    }

    private MenuItem createMenuItem(String label) {
        MenuItem m = new MenuItem(label);
        m.addActionListener(this);
        return m;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.msaveas) {
            this.save();
        }
    }

    private void save() {
        File pDir;
        String target = this.chooseFile();
        if (target == null || this.buf == null) {
            return;
        }
        File f = new File(target);
        if (f.getParent() != null && !(pDir = new File(f.getParent())).exists()) {
            pDir.mkdirs();
        }
        if (f != null) {
            this.do_save(this.enc, f);
        }
    }

    private void do_save(String encoding, File f) {
        block8: {
            try {
                OutputStreamWriter fw = null;
                if (encoding == null) {
                    fw = new FileWriter(f);
                } else {
                    FileOutputStream fu = new FileOutputStream(f);
                    fw = new OutputStreamWriter((OutputStream)fu, encoding);
                }
                fw.write(this.buf, 0, this.buf.length);
                fw.flush();
                fw.close();
            }
            catch (UnsupportedEncodingException uee) {
                if (Debug.ex) {
                    Debug.ex((Throwable)uee);
                }
                if (Debug.trace) {
                    Debug.trace((String)("Unsupported encoding: " + encoding + ". Saving with default encoding."));
                }
                this.do_save(null, f);
            }
            catch (Exception e) {
                if (Debug.ex) {
                    Debug.ex((Throwable)e);
                }
                if (!Debug.trace) break block8;
                Debug.trace((String)"Could not save file...");
            }
        }
    }

    private String chooseFile() {
        FileDialog d = new FileDialog(new Frame(), "Select file to Save:", 1);
        d.show();
        if (d.getFile() == null) {
            return null;
        }
        String pathAndFile = new String(d.getDirectory() + d.getFile());
        return pathAndFile;
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }
}

