/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.ri.common.dialog.awt.TitledBorderPanel;
import ice.ri.common.search.SearchHelper;
import ice.ri.common.search.SearchStatusEventAdapter;
import ice.storm.Viewport;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class SearchDialog
extends Dialog
implements ItemListener,
ActionListener,
TextListener {
    private final Frame frame;
    private SearchHelper searchHelper;
    private TextField searchText;
    private Checkbox highlight;
    private Checkbox matchCase;
    private Checkbox wholeWord;
    private Button findPrevious;
    private Button findNext;
    private Button close;
    private Label messageLabel;
    private boolean preFoundTextSet = false;

    public SearchDialog(Frame parent, Viewport viewport) {
        super(parent, "Find", true);
        this.frame = parent;
        this.searchHelper = new SearchHelper(viewport);
        this.buildGUI();
        this.addListeners();
        this.packAndShowDialog();
    }

    private void buildGUI() {
        TitledBorderPanel searchPanel = new TitledBorderPanel(TitledBorderPanel.ETCHED_TYPE_RAISED);
        searchPanel.setLayout(new FlowLayout(0));
        this.searchText = new TextField(20);
        searchPanel.add(this.searchText);
        this.findNext = new Button("Find Next");
        this.findNext.setEnabled(false);
        searchPanel.add(this.findNext);
        this.findPrevious = new Button("Find Previous");
        this.findPrevious.setEnabled(false);
        searchPanel.add(this.findPrevious);
        this.highlight = new Checkbox("Highlight");
        searchPanel.add(this.highlight);
        this.matchCase = new Checkbox("Match case");
        searchPanel.add(this.matchCase);
        this.wholeWord = new Checkbox("Whole word");
        searchPanel.add(this.wholeWord);
        this.close = new Button("Close");
        searchPanel.add(this.close);
        this.add((Component)searchPanel, "North");
        this.messageLabel = new Label();
        this.add((Component)this.messageLabel, "South");
    }

    private void addListeners() {
        this.searchText.addActionListener(this);
        this.searchText.addTextListener(this);
        this.findNext.addActionListener(this);
        this.findPrevious.addActionListener(this);
        this.highlight.addItemListener(this);
        this.matchCase.addItemListener(this);
        this.wholeWord.addItemListener(this);
        this.close.addActionListener(this);
        this.addESCKeyListener();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SearchDialog.this.close();
            }
        });
        this.searchHelper.addSearchStatusEventListener(new SearchStatusEventAdapter(){

            public void setSearchStatusMessage(int status, int nMatches) {
                if (status == SearchHelper.MATCH_FOUND) {
                    if (nMatches > 1) {
                        SearchDialog.this.messageLabel.setText(Integer.toString(nMatches) + ' ' + " matches found");
                    } else if (nMatches == 1) {
                        SearchDialog.this.messageLabel.setText("1 match found");
                    } else if (!SearchDialog.this.preFoundTextSet) {
                        SearchDialog.this.messageLabel.setText("");
                    }
                    SearchDialog.this.preFoundTextSet = true;
                } else if (status == SearchHelper.NO_MATCH_FOUND) {
                    SearchDialog.this.messageLabel.setText("No matches found");
                    SearchDialog.this.preFoundTextSet = false;
                } else if (status == SearchHelper.END_OF_SEARCH) {
                    SearchDialog.this.messageLabel.setText("Reached end of page, continued from top/bottom");
                    SearchDialog.this.preFoundTextSet = false;
                }
            }
        });
    }

    private void addESCKeyListener() {
        KeyListener escKeyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SearchDialog.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        };
        this.searchText.addKeyListener(escKeyListener);
        this.findNext.addKeyListener(escKeyListener);
        this.findPrevious.addKeyListener(escKeyListener);
        this.highlight.addKeyListener(escKeyListener);
        this.matchCase.addKeyListener(escKeyListener);
        this.wholeWord.addKeyListener(escKeyListener);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.close) {
            this.close();
        } else if (!this.isTextSet()) {
            this.searchHelper.setSearchText(this.searchText.getText().trim());
        } else if (source == this.findNext) {
            this.searchHelper.findNext();
        } else if (source == this.findPrevious) {
            this.searchHelper.findPrevious();
        }
    }

    private boolean isTextSet() {
        String textInHelper = this.searchHelper.getSearchText();
        return textInHelper != null && this.searchText.getText().equals(textInHelper);
    }

    private void packAndShowDialog() {
        int y;
        this.searchHelper.init();
        this.pack();
        Point p = this.frame.getLocation();
        Dimension fd = this.frame.getSize();
        Dimension dd = this.getSize();
        int x = p.x + (fd.width - dd.width) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = p.y + (fd.height - dd.height) / 2) < 0) {
            y = 0;
        }
        this.setLocation(x, y);
        this.setResizable(false);
        this.show();
    }

    private void close() {
        this.searchHelper.dispose();
        this.setVisible(false);
        this.dispose();
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.matchCase) {
            this.searchHelper.setCaseSensitiveEnabled(this.matchCase.getState());
        } else if (source == this.wholeWord) {
            this.searchHelper.setWordSearchEnabled(this.wholeWord.getState());
        } else if (source == this.highlight) {
            boolean state = this.highlight.getState();
            String currentText = this.searchText.getText().trim();
            if (!this.isTextSet() && currentText.length() != 0) {
                this.searchHelper.setSearchText(currentText);
            }
            this.searchHelper.setHighlighted(state);
        }
    }

    public void textValueChanged(TextEvent e) {
        TextComponent sText = (TextComponent)e.getSource();
        if (sText.getText().trim().length() > 0) {
            if (!this.findNext.isEnabled()) {
                this.findNext.setEnabled(true);
            }
            if (!this.findPrevious.isEnabled()) {
                this.findPrevious.setEnabled(true);
            }
        } else {
            if (this.findNext.isEnabled()) {
                this.findNext.setEnabled(false);
            }
            if (this.findPrevious.isEnabled()) {
                this.findPrevious.setEnabled(false);
            }
        }
    }
}

