/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.debug.Debug;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ThePilot;
import ice.storm.Pilot;
import ice.storm.Viewport;
import ice.util.Defs;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

public class ParseTreePrinter
implements Runnable,
PropertyChangeListener {
    private OutputStream output;
    private DDocument doc;

    ParseTreePrinter(String theFile) {
        try {
            if (theFile == null) {
                File dir = new File(Defs.sysProperty((String)"user.dir"));
                this.output = new FileOutputStream(new File(dir, "ice_output.txt"));
            } else {
                this.output = new FileOutputStream(theFile);
            }
        }
        catch (Exception ex) {
            if (Debug.ex) {
                Debug.ex((Throwable)ex);
            }
            if (Debug.trace) {
                Debug.trace((String)"Cannot create file for parse tree output...aborting");
            }
            this.output = null;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        Pilot p;
        Viewport v = (Viewport)e.getSource();
        if (v.getParent() != null) {
            return;
        }
        String name = e.getPropertyName();
        Object val = e.getNewValue();
        if (name.equals("contentLoading") && val instanceof String && val.equals("end") && (p = v.getPilot()) instanceof ThePilot) {
            ThePilot pp = (ThePilot)p;
            this.doc = (DDocument)pp.getDocument();
            new Thread(this).start();
        }
    }

    public void run() {
        if (this.output != null) {
            DElement root = (DElement)this.doc.getDocumentElement();
            this.writeln("", false);
            this.writeln("******************", false);
            this.writeln("Document source is " + this.doc.getURL(), false);
            this.writeln("******************", false);
            this.writeln("", false);
            this.printAll(root, 0);
        }
    }

    private void writeln(String s, boolean upper) {
        if (upper) {
            s = s.toUpperCase();
        }
        try {
            this.output.write((s + "\n").getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printAll(DElement e, int tab) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < tab; ++i) {
            buf.append("  ");
        }
        String temp = buf.toString();
        String nodeName = e.getNodeName();
        String attr = "";
        NamedNodeMap list = e.getAttributes();
        for (int i = 0; i < list.getLength(); ++i) {
            Attr a = (Attr)list.item(i);
            attr = attr + " " + a.getName() + "=\"" + a.getValue() + "\"";
        }
        this.writeln(temp + "<" + nodeName + attr + ">", true);
        for (DNode n = (DNode)e.getFirstChild(); n != null; n = (DNode)n.getNextSibling()) {
            if (n instanceof DElement) {
                this.printAll((DElement)n, tab + 1);
                continue;
            }
            if (!(n instanceof DTextNode)) continue;
            this.writeln(temp + "  " + n, false);
        }
        this.writeln(temp + "</" + nodeName + ">", true);
    }
}

