/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.BrowserDialog;
import ice.browser.BrowserFrame;
import ice.browser.CallbackImplBase;
import ice.browser.Main;
import ice.browser.MultiLabel;
import ice.storm.Viewport;
import ice.storm.ViewportGuiParams;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;

public class MyCallback_awt
extends CallbackImplBase {
    public String okText = "Ok";
    public String cancelText = "Cancel";
    protected Hashtable windows = new Hashtable();
    static final int ACTION_CLOSE = 1;
    static final int ACTION_SET_TRUE = 2;

    public Container createTopLevelContainer(Viewport viewport) {
        boolean dialogType = false;
        ViewportGuiParams params = viewport.getGuiParams();
        if (params != null) {
            dialogType = params.dialog;
        }
        if (dialogType) {
            BrowserDialog f = new BrowserDialog(this.base, viewport);
            this.windows.put(viewport.getId(), f);
            return f.getPanel();
        }
        BrowserFrame f = new BrowserFrame(this.base, viewport);
        this.windows.put(viewport.getId(), f);
        f.setVisible(true);
        return f.getPanel();
    }

    public void disposeTopLevelContainer(Viewport viewport) {
        Window w = (Window)this.windows.get(viewport.getId());
        if (w != null) {
            this.windows.remove(viewport.getId());
            w.setVisible(false);
            w.dispose();
            if (this.windows.isEmpty()) {
                Main.exit(this.base);
            }
        }
    }

    private Frame findFrame(Viewport vp) {
        Container x = vp.getTopLevelContainer();
        if (x instanceof Frame) {
            return (Frame)x;
        }
        Viewport vp_top = null;
        Viewport vp_parent = vp.getParent();
        while (vp_parent != null) {
            vp_top = vp_parent;
            vp_parent = vp_top.getParent();
        }
        x = vp_top.getTopLevelContainer();
        if (x instanceof Frame) {
            return (Frame)x;
        }
        return null;
    }

    private Dialog createDialog(Frame top, String title) {
        final Dialog dlg = new Dialog(top, title, true);
        dlg.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                dlg.setVisible(false);
            }
        });
        return dlg;
    }

    private void packAndShow(Dialog d, Frame f) {
        int y;
        d.pack();
        Point p = f.getLocation();
        Dimension fd = f.getSize();
        Dimension dd = d.getSize();
        int x = p.x + (fd.width - dd.width) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = p.y + (fd.height - dd.height) / 2) < 0) {
            y = 0;
        }
        d.setLocation(x, y);
        d.show();
        d.dispose();
    }

    void showMessage(Viewport vp, String title, String message) {
        Frame f = this.findFrame(vp);
        if (f == null) {
            return;
        }
        Dialog dlg = this.createDialog(f, title);
        Panel body = new Panel();
        body.add(new MultiLabel(message, 100));
        Button btn_ok = new Button(this.okText);
        btn_ok.addActionListener(new Action(dlg, 1, null));
        dlg.add((Component)body, "North");
        dlg.add((Component)btn_ok, "South");
        this.packAndShow(dlg, f);
    }

    boolean showConfirmation(Viewport vp, String title, String message) {
        boolean[] result = new boolean[]{false};
        Frame f = this.findFrame(vp);
        if (f == null) {
            return false;
        }
        Dialog dlg = this.createDialog(f, title);
        Panel body = new Panel();
        body.add(new MultiLabel(message, 100));
        Button btn_ok = new Button(this.okText);
        btn_ok.addActionListener(new Action(dlg, 2, result));
        Button btn_cancel = new Button(this.cancelText);
        btn_cancel.addActionListener(new Action(dlg, 1, null));
        Panel buttons = new Panel();
        buttons.add(btn_ok);
        buttons.add(btn_cancel);
        dlg.add((Component)body, "North");
        dlg.add((Component)buttons, "South");
        this.packAndShow(dlg, f);
        return result[0];
    }

    String showPrompt(Viewport vp, String title, String message, String defaultValue) {
        boolean[] result = new boolean[]{false};
        Frame f = this.findFrame(vp);
        if (f == null) {
            return "";
        }
        Dialog dlg = this.createDialog(f, title);
        Panel body = new Panel();
        body.setLayout(new GridLayout(2, 1));
        body.add(new MultiLabel(message, 100));
        TextField text = new TextField(defaultValue, 30);
        text.addActionListener(new Action(dlg, 2, result));
        body.add(text);
        Button btn_ok = new Button(this.okText);
        btn_ok.addActionListener(new Action(dlg, 2, result));
        Button btn_cancel = new Button(this.cancelText);
        btn_cancel.addActionListener(new Action(dlg, 1, null));
        Panel buttons = new Panel();
        buttons.add(btn_ok);
        buttons.add(btn_cancel);
        dlg.add((Component)body, "North");
        dlg.add((Component)buttons, "South");
        this.packAndShow(dlg, f);
        return result[0] ? text.getText() : null;
    }

    private static final class Action
    implements ActionListener {
        private Dialog dialog;
        private int actionId;
        private Object result;

        Action(Dialog dialog, int actionId, Object result) {
            this.dialog = dialog;
            this.actionId = actionId;
            this.result = result;
        }

        public void actionPerformed(ActionEvent e) {
            switch (this.actionId) {
                case 1: {
                    this.dialog.setVisible(false);
                    break;
                }
                case 2: {
                    ((boolean[])this.result)[0] = true;
                    this.dialog.setVisible(false);
                }
            }
        }
    }
}

