/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.webkit;

import coldfusion.document.DocumentProcessTimeOutException;
import coldfusion.document.webkit.PDFgServiceManager;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.RequestMonitor;
import coldfusion.util.RB;

public class PDFgErrorHandler {
    private static final String REASON = ".Reason: ";
    private static final String REGISTRATION_ERROR_NEW = "REGISTRATION_ERROR_NEW";
    public static String UNSUPPORTED_ACTION = "UNSUPPORTED_ACTION";
    public static String SESSION_GENERATE_ERROR = "SESSION_GENERATE_ERROR";
    public static String FAILED_REGISTRATION = "FAILED_REGISTRATION";
    public static String REGISTRATION_FAILED = "REGISTRATION_FAILED";
    public static String ERROR_DURING_INIT = "ERROR_DURING_INIT";
    public static String SERVER_AUTH_FAILED = "SERVER_AUTH_FAILED";
    public static String NO_REGISTER_ENTRY = "NO_REGISTER_ENTRY";
    public static String SERVICEMGR_BUSY = "SERVICEMGR_BUSY";
    public static String QUEUE_WAITING_TIMEOUT = "QUEUE_WAITING_TIMEOUT";
    public static String FAILED_CONNECTING_SERVICE = "FAILED_CONNECTING_SERVICE";
    public static String NO_CONVERSIONDATA = "NO_CONVERSIONDATA";
    public static final String VERIFY_ERROR = "VERIFY_ERROR";
    public static final String CONVERSION_TIMEOUT = "CONVERSION_TIMEOUT";
    public static final String ERROR_PDF_CONVERSION = "ERROR_PDF_CONVERSION";
    public static int TIMEOUT_ERROR_CODE = 408;

    public static void handleVerifyError(String errorMessage, String url) {
        if (errorMessage != null) {
            CFLogs.SERVER_LOG.error((Object)errorMessage);
            throw new ConnectionVerificationFailedException(errorMessage + " " + url);
        }
    }

    public static void handleRegisterError(int errorCode, String errorMessage, String url) {
        if (errorMessage != null) {
            if ((errorMessage = errorMessage.toUpperCase()).equals(UNSUPPORTED_ACTION)) {
                CFLogs.SERVER_LOG.error((Object)RB.getString(PDFgErrorHandler.class, (String)errorMessage));
            } else if (errorMessage.equals(SESSION_GENERATE_ERROR) || errorMessage.equals(FAILED_REGISTRATION) || errorMessage.equals(REGISTRATION_FAILED) || errorMessage.equals(ERROR_DURING_INIT)) {
                CFLogs.SERVER_LOG.error((Object)RB.getString(PDFgErrorHandler.class, (String)errorMessage, (Object)url));
            } else {
                try {
                    String msg = RB.getString(PDFgErrorHandler.class, (String)errorMessage);
                    if (msg != null) {
                        CFLogs.SERVER_LOG.error((Object)msg);
                    } else {
                        CFLogs.SERVER_LOG.error((Object)(RB.getString(PDFgErrorHandler.class, (String)REGISTRATION_ERROR_NEW) + url + REASON + errorMessage));
                    }
                }
                catch (Exception e) {
                    CFLogs.SERVER_LOG.error((Object)(RB.getString(PDFgErrorHandler.class, (String)REGISTRATION_ERROR_NEW) + url + REASON + errorMessage));
                }
            }
        }
    }

    public static void handleConversionError(int errorCode, String errorMessage, String url, PDFgServiceManager serviceManager) {
        if (errorCode == TIMEOUT_ERROR_CODE) {
            throw new DocumentProcessTimeOutException(RequestMonitor.getRequestTimeout());
        }
        if (errorMessage != null) {
            if ((errorMessage = errorMessage.toUpperCase()).equals(UNSUPPORTED_ACTION)) {
                CFLogs.SERVER_LOG.error((Object)RB.getString(PDFgErrorHandler.class, (String)errorMessage));
            } else {
                if (errorMessage.equals(SERVER_AUTH_FAILED) || errorMessage.equals(NO_REGISTER_ENTRY)) {
                    CFLogs.SERVER_LOG.error((Object)RB.getString(PDFgErrorHandler.class, (String)errorMessage, (Object)url));
                    throw new ServiceManagerReRegisterException(RB.getString(PDFgErrorHandler.class, (String)errorMessage, (Object)url), url);
                }
                if (errorMessage.equals(SERVICEMGR_BUSY) || errorMessage.equals(QUEUE_WAITING_TIMEOUT) || errorMessage.equals(FAILED_CONNECTING_SERVICE) || errorMessage.equals(ERROR_PDF_CONVERSION)) {
                    CFLogs.SERVER_LOG.error((Object)RB.getString(PDFgErrorHandler.class, (String)errorMessage, (Object)url));
                    throw new ServiceManagerRetryException(RB.getString(PDFgErrorHandler.class, (String)errorMessage, (Object)url), url);
                }
                if (errorMessage.equals(NO_CONVERSIONDATA)) {
                    CFLogs.SERVER_LOG.error((Object)RB.getString(PDFgErrorHandler.class, (String)errorMessage));
                } else {
                    if (errorMessage.equals(CONVERSION_TIMEOUT)) {
                        String tmp = RB.getString(PDFgErrorHandler.class, (String)errorMessage, (Object)url);
                        CFLogs.SERVER_LOG.error((Object)tmp);
                        throw new ServiceManagerConversionException(tmp);
                    }
                    try {
                        String msg = RB.getString(PDFgErrorHandler.class, (String)errorMessage);
                        CFLogs.SERVER_LOG.error((Object)msg);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new ServiceManagerConversionException(errorMessage, url);
                }
            }
        }
    }

    public static class ConnectionVerificationFailedException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String msg = RB.getString((Object)((Object)this), (String)"VERIFY_ERROR");

        public ConnectionVerificationFailedException() {
        }

        public ConnectionVerificationFailedException(String msg) {
            this.msg = msg;
        }
    }

    public static class ServiceManagerConversionException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String message = "";
        public String url = "";
        public Throwable e;

        public ServiceManagerConversionException(String message) {
            this.message = message;
        }

        public ServiceManagerConversionException(String message, String url) {
            this.message = message;
            this.url = url;
        }

        public ServiceManagerConversionException(Throwable e, String url) {
            this.e = e;
            this.message = e.getMessage();
            this.url = url;
        }
    }

    public static class ServiceManagerReRegisterException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String message = "";
        public String url = "";

        public ServiceManagerReRegisterException(String message, String url) {
            this.message = message;
            this.url = url;
        }
    }

    public static class ServiceManagerRetryException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String message = "";
        public String url = "";

        public ServiceManagerRetryException(String message, String url) {
            this.message = message;
            this.url = url;
        }
    }
}

