/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.utils;

import coldfusion.cloud.aws.dynamodb.casesensitive.CFHandleCaseSensitiveReturn;
import coldfusion.cloud.aws.dynamodb.exceptions.CFDynamoDbUnrecognizedAWSAttributeException;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFBigDecimal;
import coldfusion.runtime.CaseSensitiveStruct;
import coldfusion.runtime.Cast;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateProxy;
import coldfusion.util.Key;
import coldfusion.wddx.Base64Encoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;

public class CFDynamoDbCustomizeResponse {
    public static final void customizeHttpHeader(Map customizedResponseStruct) {
        customizedResponseStruct.put("HttpResponse", customizedResponseStruct.get("SdkHttpResponse"));
        customizedResponseStruct.remove("SdkHttpResponse");
    }

    public static final void addCustomizedBatchGetItemResponse(Map rawMap, Map customMap) {
        rawMap.remove("Responses");
        rawMap.put("Responses", customMap);
    }

    public static final void customizeBatchGetItem(BatchGetItemResponse batchGetItemResponse, Map rawMap, Map options) {
        Map customizedResponseMap = CFHandleCaseSensitiveReturn.getReturnObject();
        Map batchResponse = batchGetItemResponse.responses();
        for (Map.Entry entry : batchResponse.entrySet()) {
            String tableName = (String)entry.getKey();
            List tableItems = (List)entry.getValue();
            Array customizedResponseArray = CFDynamoDbCustomizeResponse.itemsResponseCustomization(tableItems, options);
            customizedResponseMap.put(tableName, customizedResponseArray);
        }
        CFDynamoDbCustomizeResponse.addCustomizedBatchGetItemResponse(rawMap, customizedResponseMap);
        CFDynamoDbCustomizeResponse.customizeHttpHeader(rawMap);
    }

    public static final void addCustomizedTransactGetItemsmResponse(Map rawMap, Array customArray) {
        rawMap.remove("Responses");
        rawMap.put("Responses", customArray);
    }

    public static final void customizeTransactGetItems(TransactGetItemsResponse transactGetItemsResponse, Map rawMap, Map options) {
        Array customizedResponseArray = null;
        List transactResponse = transactGetItemsResponse.responses();
        ArrayList<Map<String, AttributeValue>> itemsList = new ArrayList<Map<String, AttributeValue>>();
        for (ItemResponse itemResponse : transactResponse) {
            itemsList.add(itemResponse.item());
        }
        customizedResponseArray = CFDynamoDbCustomizeResponse.itemsResponseCustomization(itemsList, options);
        CFDynamoDbCustomizeResponse.addCustomizedTransactGetItemsmResponse(rawMap, customizedResponseArray);
        CFDynamoDbCustomizeResponse.customizeHttpHeader(rawMap);
    }

    public static void addCustomizedGetItemResponse(Map rawMap, Map customMap) {
        rawMap.remove("Item");
        rawMap.put("Item", customMap);
    }

    public static final void customizeGetItem(GetItemResponse getItemResponse, Map rawMap, Map options) {
        Map item = getItemResponse.item();
        Map customizedResponseMap = CFDynamoDbCustomizeResponse.itemResponseCustomization(item, options);
        CFDynamoDbCustomizeResponse.addCustomizedGetItemResponse(rawMap, customizedResponseMap);
        CFDynamoDbCustomizeResponse.customizeHttpHeader(rawMap);
    }

    public static void addCustomizedQueryResponse(Map rawMap, Array customArray, Map customLastEvalustedKey) {
        rawMap.remove("Items");
        rawMap.remove("LastEvaluatedKey");
        rawMap.put("Items", customArray);
        rawMap.put("LastEvaluatedKey", customLastEvalustedKey);
    }

    public static final void customizeQuery(QueryResponse queryResponse, Map rawMap, Map options) {
        Array customizedResponseArray = null;
        Map customizedLastEvaluatedKey = null;
        List items = queryResponse.items();
        Map lastEvaluatedKey = queryResponse.lastEvaluatedKey();
        customizedResponseArray = CFDynamoDbCustomizeResponse.itemsResponseCustomization(items, options);
        customizedLastEvaluatedKey = CFDynamoDbCustomizeResponse.itemResponseCustomization(lastEvaluatedKey, options);
        CFDynamoDbCustomizeResponse.addCustomizedQueryResponse(rawMap, customizedResponseArray, customizedLastEvaluatedKey);
        CFDynamoDbCustomizeResponse.customizeHttpHeader(rawMap);
    }

    public static void addCustomizedScanResponse(Map rawMap, Array customArray, Map customLastEvalustedKey) {
        rawMap.remove("Items");
        rawMap.remove("LastEvaluatedKey");
        rawMap.put("Items", customArray);
        rawMap.put("LastEvaluatedKey", customLastEvalustedKey);
    }

    public static final void customizeScan(ScanResponse scanResponse, Map rawMap, Map options) {
        Array customizedResponseArray = null;
        Map customizedLastEvaluatedKey = null;
        List items = scanResponse.items();
        Map lastEvaluatedKey = scanResponse.lastEvaluatedKey();
        customizedResponseArray = CFDynamoDbCustomizeResponse.itemsResponseCustomization(items, options);
        customizedLastEvaluatedKey = CFDynamoDbCustomizeResponse.itemResponseCustomization(lastEvaluatedKey, options);
        CFDynamoDbCustomizeResponse.addCustomizedScanResponse(rawMap, customizedResponseArray, customizedLastEvaluatedKey);
        CFDynamoDbCustomizeResponse.customizeHttpHeader(rawMap);
    }

    public static void addCustomizedPutItemResponse(Map rawMap, Map customMap, String customizeValueForKey) {
        rawMap.remove(customizeValueForKey);
        rawMap.put(customizeValueForKey, customMap);
    }

    public static void customizePutItem(PutItemResponse putItemResponse, Map rawMap, Map options) {
        Map customizedResponseMap = null;
        Map customizedCollectionKey = null;
        Map attributes = putItemResponse.attributes();
        if (!attributes.isEmpty()) {
            customizedResponseMap = CFDynamoDbCustomizeResponse.itemResponseCustomization(attributes, options);
            CFDynamoDbCustomizeResponse.addCustomizedPutItemResponse(rawMap, customizedResponseMap, "Attributes");
        }
        CFDynamoDbCustomizeResponse.customizeHttpHeader(rawMap);
        try {
            ItemCollectionMetrics itemCollectionMetrics = putItemResponse.itemCollectionMetrics();
            Map itemCollectionKey = itemCollectionMetrics.itemCollectionKey();
            if (!itemCollectionKey.isEmpty()) {
                customizedCollectionKey = CFDynamoDbCustomizeResponse.itemResponseCustomization(itemCollectionKey, options);
                Map collectionKey = (Map)rawMap.get("ItemCollectionMetrics");
                CFDynamoDbCustomizeResponse.addCustomizedPutItemResponse(collectionKey, customizedCollectionKey, "ItemCollectionKey");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addCustomizedDeleteItemResponse(Map rawMap, Map customMap, String customizeValueForKey) {
        rawMap.remove(customizeValueForKey);
        rawMap.put(customizeValueForKey, customMap);
    }

    public static void customizeDeleteItem(DeleteItemResponse deleteItemResponse, Map rawMap, Map options) {
        Map customizedResponseMap = null;
        Map customizedCollectionKey = null;
        Map attributes = deleteItemResponse.attributes();
        if (!attributes.isEmpty()) {
            customizedResponseMap = CFDynamoDbCustomizeResponse.itemResponseCustomization(attributes, options);
            CFDynamoDbCustomizeResponse.addCustomizedDeleteItemResponse(rawMap, customizedResponseMap, "Attributes");
        }
        CFDynamoDbCustomizeResponse.customizeHttpHeader(rawMap);
        try {
            ItemCollectionMetrics itemCollectionMetrics = deleteItemResponse.itemCollectionMetrics();
            Map itemCollectionKey = itemCollectionMetrics.itemCollectionKey();
            if (!itemCollectionKey.isEmpty()) {
                customizedCollectionKey = CFDynamoDbCustomizeResponse.itemResponseCustomization(itemCollectionKey, options);
                Map collectionKey = (Map)rawMap.get("ItemCollectionMetrics");
                CFDynamoDbCustomizeResponse.addCustomizedDeleteItemResponse(collectionKey, customizedCollectionKey, "ItemCollectionKey");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void customizeUnprocessedItems(Map<String, AttributeValue> item, Map unprocessedItem, Map options) {
        Map customizedResponseMap = CFDynamoDbCustomizeResponse.itemResponseCustomization(item, options);
        unprocessedItem.remove("Item");
        unprocessedItem.put("Item", customizedResponseMap);
    }

    public static void addCustomizedUpdateItemResponse(Map rawMap, Map customMap, String customizeValueForKey) {
        rawMap.remove(customizeValueForKey);
        rawMap.put(customizeValueForKey, customMap);
    }

    public static void customizeUpdateItem(UpdateItemResponse updateItemResponse, Map rawMap, Map options) {
        Map customizedResponseMap = null;
        Map customizedCollectionKey = null;
        Map attributes = updateItemResponse.attributes();
        if (!attributes.isEmpty()) {
            customizedResponseMap = CFDynamoDbCustomizeResponse.itemResponseCustomization(attributes, options);
            CFDynamoDbCustomizeResponse.addCustomizedUpdateItemResponse(rawMap, customizedResponseMap, "Attributes");
        }
        CFDynamoDbCustomizeResponse.customizeHttpHeader(rawMap);
        try {
            ItemCollectionMetrics itemCollectionMetrics = updateItemResponse.itemCollectionMetrics();
            Map itemCollectionKey = itemCollectionMetrics.itemCollectionKey();
            if (!itemCollectionKey.isEmpty()) {
                customizedCollectionKey = CFDynamoDbCustomizeResponse.itemResponseCustomization(itemCollectionKey, options);
                Map collectionKey = (Map)rawMap.get("ItemCollectionMetrics");
                CFDynamoDbCustomizeResponse.addCustomizedUpdateItemResponse(collectionKey, customizedCollectionKey, "ItemCollectionKey");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addCustomizedBatchWriteItemResponse(Map rawMap, Map customMap, String customizeValueForKey) {
        rawMap.remove(customizeValueForKey);
        rawMap.put(customizeValueForKey, customMap);
    }

    public static void customizeBatchWriteItem(BatchWriteItemResponse batchWriteItemResponse, Map rawMap, Map options) {
        Map customizedResponseMap = CFHandleCaseSensitiveReturn.getReturnObject();
        Map customizedItemCollectionMetricsMap = CFHandleCaseSensitiveReturn.getReturnObject();
        Map unprocessedItems = batchWriteItemResponse.unprocessedItems();
        for (Map.Entry entry : unprocessedItems.entrySet()) {
            customizedResponseMap.put(entry.getKey(), ((List)entry.getValue()).toString());
        }
        CFDynamoDbCustomizeResponse.addCustomizedBatchWriteItemResponse(rawMap, customizedResponseMap, "UnprocessedItems");
        CFDynamoDbCustomizeResponse.customizeHttpHeader(rawMap);
        try {
            Map itemCollectionMetricsMap = batchWriteItemResponse.itemCollectionMetrics();
            for (Map.Entry entry : itemCollectionMetricsMap.entrySet()) {
                List itemCollectionMetricsList = (List)entry.getValue();
                Array customizedItemCollectionMetricsList = new Array();
                for (ItemCollectionMetrics itemCollectionMetrics : itemCollectionMetricsList) {
                    customizedItemCollectionMetricsList.add((Object)CFDynamoDbCustomizeResponse.itemResponseCustomization(itemCollectionMetrics.itemCollectionKey(), options));
                }
                customizedItemCollectionMetricsMap.put(entry.getKey(), customizedItemCollectionMetricsList);
            }
            CFDynamoDbCustomizeResponse.addCustomizedBatchWriteItemResponse(rawMap, customizedItemCollectionMetricsMap, "ItemCollectionMetrics");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final boolean returnCustomResponse(Map options) {
        if (options == null) {
            return false;
        }
        if (options != null && options.get(Key.getInstance((String)"customResponse")) == null) {
            return false;
        }
        return Cast._boolean(options.get(Key.getInstance((String)"customResponse")));
    }

    public static final boolean returnBinaryFormatResponse(Map options) {
        if (options == null) {
            return false;
        }
        if (options != null && options.get(Key.getInstance((String)"binaryFormat")) == null) {
            return false;
        }
        return Cast._boolean(options.get(Key.getInstance((String)"binaryFormat")));
    }

    public static Map getReturnMap(Map options) {
        boolean caseSensitiveReturn = false;
        if (options.containsKey("caseSensitiveReturn")) {
            caseSensitiveReturn = Cast._boolean(options.get("caseSensitiveReturn"));
        }
        if (caseSensitiveReturn) {
            return new CaseSensitiveStruct();
        }
        return new Struct();
    }

    public static final Map itemResponseCustomization(Map<String, AttributeValue> item, Map options) {
        Map customResponseMap = CFDynamoDbCustomizeResponse.getReturnMap(options);
        CFDynamoDbCustomizeResponse.buildCustomResponse(item, customResponseMap, options);
        return customResponseMap;
    }

    public static Array itemsResponseCustomization(List<Map<String, AttributeValue>> items, Map options) {
        Iterator<Map<String, AttributeValue>> iterator = items.iterator();
        Array responseArray = new Array();
        while (iterator.hasNext()) {
            responseArray.add((Object)CFDynamoDbCustomizeResponse.itemResponseCustomization(iterator.next(), options));
        }
        return responseArray;
    }

    public static final Map buildCustomResponse(Map<String, AttributeValue> rawResponse, Map outputMap, Map options) {
        for (Map.Entry<String, AttributeValue> entry : rawResponse.entrySet()) {
            AttributeValue attr = entry.getValue();
            outputMap.put(entry.getKey(), CFDynamoDbCustomizeResponse.attributeIterator(attr, options));
        }
        return outputMap;
    }

    public static final Object attributeIterator(AttributeValue attr, Map options) {
        if (!attr.bs().isEmpty()) {
            List binSetList = attr.bs();
            Iterator iterator = binSetList.iterator();
            Array array = new Array();
            while (iterator.hasNext()) {
                SdkBytes temp = (SdkBytes)iterator.next();
                if (CFDynamoDbCustomizeResponse.returnBinaryFormatResponse(options)) {
                    array.add((Object)temp.asByteArray());
                    continue;
                }
                array.add((Object)Base64Encoder.encode((byte[])temp.asByteArray()));
            }
            return array;
        }
        if (!attr.ns().isEmpty()) {
            List numberList = attr.ns();
            Iterator iterator = numberList.iterator();
            Array array = new Array();
            while (iterator.hasNext()) {
                array.add((Object)new CFBigDecimal((String)iterator.next()));
            }
            return array;
        }
        if (!attr.ss().isEmpty()) {
            List stringList = attr.ss();
            Iterator iterator = stringList.iterator();
            Array array = new Array();
            while (iterator.hasNext()) {
                String str = (String)iterator.next();
                Object templateProxy = CFDynamoDbCustomizeResponse.deserializeTemplateProxy(str, options);
                if (templateProxy != null) {
                    array.add(templateProxy);
                    continue;
                }
                array.add((Object)str);
            }
            return array;
        }
        if (!attr.l().isEmpty()) {
            List attrList = attr.l();
            Iterator iterator = attrList.iterator();
            Array array = new Array();
            while (iterator.hasNext()) {
                array.add(CFDynamoDbCustomizeResponse.attributeIterator((AttributeValue)iterator.next(), options));
            }
            return array;
        }
        if (attr.n() != null) {
            return new CFBigDecimal(attr.n());
        }
        if (attr.s() != null) {
            Object templateProxy = CFDynamoDbCustomizeResponse.deserializeTemplateProxy(attr.s(), options);
            if (templateProxy != null) {
                return templateProxy;
            }
            return attr.s();
        }
        if (attr.b() != null) {
            if (CFDynamoDbCustomizeResponse.returnBinaryFormatResponse(options)) {
                return attr.b().asByteArray();
            }
            return Base64Encoder.encode((byte[])attr.b().asByteArray());
        }
        if (attr.bool() != null) {
            return attr.bool();
        }
        if (attr.nul() != null) {
            return attr.nul();
        }
        if (!attr.m().isEmpty()) {
            Map customResponseMap = CFDynamoDbCustomizeResponse.getReturnMap(options);
            return CFDynamoDbCustomizeResponse.buildCustomResponse(attr.m(), customResponseMap, options);
        }
        if (attr.l().isEmpty()) {
            Array array = new Array();
            return array;
        }
        throw new CFDynamoDbUnrecognizedAWSAttributeException();
    }

    private static Object deserializeTemplateProxy(Object value, Map options) {
        Object templateProxy = null;
        try {
            if (CFDynamoDbCustomizeResponse.deserializeTemplateProxyNeeded(options) && JSONUtils.isJSON((Object)value) && (templateProxy = JSONUtils.deserializeJSON((Object)value, (boolean)true, (boolean)true, (boolean)true)) instanceof TemplateProxy) {
                return templateProxy;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean deserializeTemplateProxyNeeded(Map options) {
        if (options.containsKey("preserveCFC")) {
            return Cast._boolean(options.get("preserveCFC"));
        }
        return false;
    }
}

