/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.exceptions;

import coldfusion.cloud.aws.dynamodb.casesensitive.CFHandleCaseSensitiveReturn;
import java.util.Map;
import java.util.Set;

public class CFDynamoDbFieldValidationException
extends RuntimeException {
    private String exceptionMessage;
    private String exceptionCause;
    private String exceptionName;
    private String exceptionCode;
    private String serviceName;
    private String invalidKey;
    private Set<String> validKeys;
    private String apiName;
    private Map exceptionDetails;

    public CFDynamoDbFieldValidationException() {
    }

    public CFDynamoDbFieldValidationException(String invalidKey, Set<String> validKeys, String apiName) {
        this.apiName = apiName;
        this.invalidKey = invalidKey;
        this.validKeys = validKeys;
        this.serviceName = "DynamoDb";
        this.exceptionCause = "An Exception occured while performing " + apiName + " dynamo operation.";
        this.exceptionName = this.getClass().getSimpleName();
        this.exceptionCode = "FieldValidationException";
        this.exceptionMessage = "Unknown attribute \"" + this.invalidKey + "\" encountered in the dynamoDb request structure. Valid keys for " + this.apiName + " dynamo operation are: " + validKeys.toString();
        this.buildExceptionDetails();
    }

    @Override
    public String getMessage() {
        return this.exceptionMessage;
    }

    public Map getExceptionDetails() {
        return this.exceptionDetails;
    }

    private void buildExceptionDetails() {
        this.exceptionDetails = CFHandleCaseSensitiveReturn.getReturnObject();
        this.exceptionDetails.put("ExceptionMessage", this.exceptionMessage);
        this.exceptionDetails.put("ExceptionCause", this.exceptionCause);
        this.exceptionDetails.put("ExceptionName", this.exceptionName);
        this.exceptionDetails.put("ExceptionCode", this.exceptionCode);
        this.exceptionDetails.put("ServiceName", this.serviceName);
    }
}

