/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.jvm;

import com.zerog.util.jvm.Filter;
import com.zerog.util.jvm.Introspector;
import com.zerog.util.jvm.RunningVMIntrospector;
import com.zerog.util.jvm.Validator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class JVMInformationRetrieverServer {
    private Validator jvmValidator;
    private Introspector introspector;
    private static final int SUCCESS_EXIT_CODE = 0;
    private static final int ERROR_EXIT_CODE = -1;
    private static final int CHECK_FAIL_EXIT_CODE = 1;

    public JVMInformationRetrieverServer() {
        this(new Validator(), new RunningVMIntrospector());
    }

    public JVMInformationRetrieverServer(Validator validator, Introspector introspector) {
        this.jvmValidator = validator;
        this.introspector = introspector;
    }

    private void retrieveJavaHome(String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        bufferedWriter.write(this.introspector.getJavaHome());
        bufferedWriter.close();
    }

    private boolean checkVendor(String string) {
        return this.jvmValidator.checkVendor(this.getCurrentlyRunningVendor(), string);
    }

    private boolean checkFilters(String string, Vector vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (this.jvmValidator.checkFilter(this.getCurrentlyRunningVendor(), this.getCurrentlyRunningType(string), this.getCurrentlyRunningVersion(), (Filter)vector.get(i))) continue;
            bl = true;
            break;
        }
        return !bl;
    }

    private String getCurrentlyRunningVersion() {
        return this.introspector.getVersion();
    }

    private String getCurrentlyRunningType(String string) {
        return this.introspector.getType(string);
    }

    private String getCurrentlyRunningVendor() {
        return this.introspector.getVendor();
    }

    public int execute(String[] stringArray) {
        if (stringArray.length < 1) {
            return -1;
        }
        int n = Integer.parseInt(stringArray[0]);
        switch (n) {
            case 1: {
                if (stringArray.length < 2) {
                    return -1;
                }
                return this.checkVendor(stringArray[1]) ? 0 : 1;
            }
            case 2: {
                if (stringArray.length < 3) {
                    return -1;
                }
                String string = stringArray[1];
                Vector<Filter> vector = new Vector<Filter>();
                for (int i = 2; i < stringArray.length; ++i) {
                    String[] stringArray2 = stringArray[i].split(" ");
                    for (int j = 0; j < stringArray2.length; ++j) {
                        Filter filter = Filter.parse(stringArray2[j]);
                        if (filter == null) {
                            return 1;
                        }
                        vector.add(filter);
                    }
                }
                return this.checkFilters(string, vector) ? 0 : 1;
            }
            case 3: {
                if (stringArray.length < 2) {
                    return -1;
                }
                String string = stringArray[1];
                try {
                    this.retrieveJavaHome(string);
                }
                catch (IOException iOException) {
                    return -1;
                }
                return 0;
            }
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        System.exit(new JVMInformationRetrieverServer().execute(stringArray));
    }
}

