/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.project.file.base.jelly;

import com.zerog.ia.project.file.base.jelly.XMLIterator;
import com.zerog.xml.parser.ParseException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.jexl.JexlExpressionFactory;

public class JellyReader {
    private File templateFile;
    private JellyContext context;
    private ExpressionFactory jexlFactory = new JexlExpressionFactory();
    private Map<File, Flexeraax1> xmlCache = new HashMap<File, Flexeraax1>();

    public void readXML(File file, File file2, Map map) throws ParseException {
        this.templateFile = file;
        this.context = new JellyContext();
        this.context.setVariables(map);
        Flexeraax1 flexeraax1 = this.readXML(file);
        Flexeraax1 flexeraax12 = this.readXML(file2);
        this.parseElement(new XMLIterator(flexeraax1), new XMLIterator(flexeraax12));
        map.putAll(this.context.getVariables());
    }

    private Flexeraax1 readXML(String string) throws ParseException {
        return this.readXML(new File(string));
    }

    private Flexeraax1 readXML(File file) throws ParseException {
        if (this.xmlCache.containsKey(file)) {
            return this.xmlCache.get(file);
        }
        Flexeraax4 flexeraax4 = null;
        try {
            flexeraax4 = new Flexeraax4(file);
        }
        catch (IOException iOException) {
            throw new ParseException("Can not open file: " + file.getAbsolutePath());
        }
        Flexeraax1 flexeraax1 = flexeraax4.aa();
        this.xmlCache.put(file, flexeraax1);
        return flexeraax1;
    }

    private void parseElement(XMLIterator xMLIterator, XMLIterator xMLIterator2) throws ParseException {
        while (xMLIterator.hasNext()) {
            Flexeraax1 flexeraax1 = xMLIterator.next();
            Flexeraax1 flexeraax12 = null;
            if (this.isJellyElement(flexeraax1)) {
                this.parseJellyTag(xMLIterator, xMLIterator2);
                continue;
            }
            if (!xMLIterator2.hasNext()) continue;
            flexeraax12 = xMLIterator2.next();
            if (flexeraax1.aw(flexeraax12)) {
                this.parseAttributes(flexeraax1, flexeraax12);
                this.parseContent(flexeraax1, flexeraax12);
                continue;
            }
            throw new ParseException("Expecting to find element '" + flexeraax1 + "' but found '" + flexeraax12 + "'");
        }
    }

    private void parseAttributes(Flexeraax1 flexeraax1, Flexeraax1 flexeraax12) throws ParseException {
        String[] stringArray = flexeraax1.bb().ab();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = flexeraax1.bb().aa()[i];
            String string2 = flexeraax12.bb().ad(string);
            this.assignValue(stringArray[i], string2);
        }
    }

    private void parseContent(Flexeraax1 flexeraax1, Flexeraax1 flexeraax12) throws ParseException {
        if (!this.isEmpty(flexeraax1.a7())) {
            if (flexeraax12.a7() != null) {
                this.assignValue(flexeraax1.a7(), flexeraax12.a7());
            }
            if (flexeraax12.a9() != null) {
                this.assignValue(flexeraax1.a7(), flexeraax12.ba());
            }
        }
    }

    private void parseJellyTag(XMLIterator xMLIterator, XMLIterator xMLIterator2) throws ParseException {
        Flexeraax1 flexeraax1 = xMLIterator.current();
        if (!flexeraax1.au().equals("jelly") && !flexeraax1.au().equals("whitespace")) {
            if (flexeraax1.au().equals("if")) {
                if (flexeraax1.ax()) {
                    this.parseContent(flexeraax1, xMLIterator2.current());
                } else {
                    if (this.shouldParseContainerTag(flexeraax1, xMLIterator2)) {
                        this.parseContainerTag(flexeraax1, xMLIterator2);
                    }
                    xMLIterator.skipChildren();
                }
            } else if (flexeraax1.au().equals("forEach")) {
                if (xMLIterator.current().ax()) {
                    this.parseContent(flexeraax1, xMLIterator2.current());
                } else {
                    String string = flexeraax1.be("var");
                    String string2 = flexeraax1.be("items");
                    Object object = this.evaluateExpression(string2);
                    if (object instanceof Enumeration) {
                        Enumeration enumeration = (Enumeration)object;
                        while (this.shouldParseContainerTag(flexeraax1, xMLIterator2)) {
                            try {
                                this.context.setVariable(string, enumeration.nextElement());
                            }
                            catch (NullPointerException nullPointerException) {
                                nullPointerException.printStackTrace();
                            }
                            this.parseContainerTag(flexeraax1, xMLIterator2);
                        }
                    } else if (object instanceof Iterator) {
                        Iterator iterator = (Iterator)object;
                        while (this.shouldParseContainerTag(flexeraax1, xMLIterator2)) {
                            try {
                                this.context.setVariable(string, iterator.next());
                            }
                            catch (NullPointerException nullPointerException) {
                                nullPointerException.printStackTrace();
                            }
                            this.parseContainerTag(flexeraax1, xMLIterator2);
                        }
                    }
                    xMLIterator.skipChildren();
                }
            } else if (flexeraax1.au().equals("switch")) {
                for (Flexeraax1 flexeraax12 : flexeraax1.an()) {
                    if (!this.shouldParseContainerTag(flexeraax12, xMLIterator2)) continue;
                    this.parseContainerTag(flexeraax12, xMLIterator2);
                }
                xMLIterator.skipChildren();
            } else if (flexeraax1.au().equals("import")) {
                Flexeraax1 flexeraax13 = this.loadSubTemplate(flexeraax1.be("uri"));
                XMLIterator xMLIterator3 = new XMLIterator(xMLIterator2.next(), true);
                this.parseContainerTag(flexeraax13, xMLIterator3);
                xMLIterator2.skipChildren();
                xMLIterator.skipChildren();
            } else if (flexeraax1.au().equals("set")) {
                String string = flexeraax1.be("var");
                Object object = this.evaluateExpression(flexeraax1.be("value"));
                this.assignValue(string, object);
            } else if (flexeraax1.au().equals("expr")) {
                this.evaluateExpression(flexeraax1.be("value"));
            } else if (flexeraax1.au().equals("new")) {
                String string = flexeraax1.be("className");
                String string3 = flexeraax1.be("var");
                this.context.setVariable(string3, this.createInstance(string));
            } else {
                throw new ParseException("Unable to handle Jelly tag: " + flexeraax1.au());
            }
        }
    }

    private boolean shouldParseContainerTag(Flexeraax1 flexeraax1, XMLIterator xMLIterator) throws ParseException {
        return xMLIterator.peekNext() != null && this.tagContainsAsFirstSubElement(flexeraax1, xMLIterator.peekNext());
    }

    private void parseContainerTag(Flexeraax1 flexeraax1, XMLIterator xMLIterator) throws ParseException {
        XMLIterator xMLIterator2 = new XMLIterator(flexeraax1, false);
        this.parseElement(xMLIterator2, xMLIterator);
    }

    private Flexeraax1 loadSubTemplate(String string) throws ParseException {
        File file = new File(string);
        if (file.isAbsolute()) {
            return this.readXML(string);
        }
        return this.readXML(new File(this.templateFile.getParent(), string));
    }

    private boolean tagsAreTheSame(Flexeraax1 flexeraax1, Flexeraax1 flexeraax12) {
        if (flexeraax1.aw(flexeraax12)) {
            if (flexeraax12.an() != null && flexeraax1.an() == null) {
                return false;
            }
            List<String> list = Arrays.asList(flexeraax1.bb().aa());
            for (int i = 0; i < flexeraax12.bb().aa().length; ++i) {
                String string = flexeraax12.bb().aa()[i];
                String string2 = flexeraax12.be(string);
                String string3 = flexeraax1.be(string);
                if (!list.contains(string)) {
                    return false;
                }
                if (this.isExpression(string3) || string2.equals(string3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean tagContainsAsFirstSubElement(Flexeraax1 flexeraax1, Flexeraax1 flexeraax12) throws ParseException {
        block5: {
            if (flexeraax1.ax()) break block5;
            for (Flexeraax1 flexeraax13 : flexeraax1.an()) {
                block6: {
                    String string;
                    block8: {
                        block7: {
                            if (!this.isJellyElement(flexeraax13)) break block6;
                            string = flexeraax13.au();
                            if (string.equals("if")) break block7;
                            if (!string.equals("forEach")) break block8;
                        }
                        if (this.tagContainsAsFirstSubElement(flexeraax13, flexeraax12)) {
                            return true;
                        }
                    }
                    if (!string.equals("import")) continue;
                    Flexeraax1 flexeraax14 = this.loadSubTemplate(flexeraax13.be("uri"));
                    if (!this.tagContainsAsFirstSubElement(flexeraax14, flexeraax12)) continue;
                    return true;
                }
                return this.tagsAreTheSame(flexeraax13, flexeraax12);
            }
        }
        return false;
    }

    private Object createInstance(String string) throws ParseException {
        Object var2_2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var2_2 = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ParseException("Can not create instance of " + string);
        }
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignValue(String string, Object object) throws ParseException {
        if (this.isEmpty(string) || object == null) return;
        string = this.prepareExpression(string);
        if (string.indexOf(".") > -1) {
            try {
                String string2 = string.substring(0, string.indexOf("."));
                if (this.context.getVariable(string2) == null) return;
                Object object2 = this.context.getVariable(string2);
                BeanUtils.setProperty((Object)object2, (String)string.substring(string.indexOf(".") + 1), (Object)object);
                return;
            }
            catch (Exception exception) {
                throw new ParseException("Error assigning '" + object + "' to '" + string + "'");
            }
        } else {
            this.context.setVariable(string, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isJellyElement(Flexeraax1 flexeraax1) {
        String string = flexeraax1.ap();
        if (string == null) {
            return false;
        }
        if (string.equals("j")) return true;
        if (!string.equals("x")) return false;
        return true;
    }

    private boolean isExpression(String string) {
        int n = string.indexOf("${");
        int n2 = string.indexOf("}");
        return n >= 0 && n2 > n + 2;
    }

    private String prepareExpression(String string) throws ParseException {
        int n = string.indexOf("${");
        int n2 = string.indexOf("}");
        if (n >= 0 && n2 > n + 2) {
            return string.substring(n + 2, n2);
        }
        return string;
    }

    private Object evaluateExpression(String string) throws ParseException {
        if (this.isExpression(string)) {
            string = this.prepareExpression(string);
            try {
                return this.jexlFactory.createExpression(string).evaluate(this.context);
            }
            catch (Throwable throwable) {
                throw new ParseException("Expression is empty or malformed: " + string);
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEmpty(String string) {
        if (string == null) return true;
        if (!"".equals(string.trim())) return false;
        return true;
    }
}

