/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.rules;

import com.zerog.ia.installer.InstallPiece;
import com.zerog.ia.installer.Rule;
import com.zerog.ia.installer.util.ClassInfoManager;
import com.zerog.ia.platform.Sys;
import com.zerog.util.IAResourceBundle;
import com.zerog.util.ZGUtil;
import java.beans.Beans;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ArchitectureChk
extends Rule {
    public static final String X86 = ZGUtil.getZGArchitectureName(1, true);
    public static final String IA64 = ZGUtil.getZGArchitectureName(9, true);
    public static final String AMD64 = ZGUtil.getZGArchitectureName(10, true);
    public static final String MIPS = ZGUtil.getZGArchitectureName(4, true);
    public static final String PARISC = ZGUtil.getZGArchitectureName(7, true);
    public static final String SPARC = ZGUtil.getZGArchitectureName(6, true);
    public static final String PPC = ZGUtil.getZGArchitectureName(2, true);
    public static final String PPC64 = ZGUtil.getZGArchitectureName(12, true);
    public static final String ALPHA = ZGUtil.getZGArchitectureName(3, true);
    public static final String POWER = ZGUtil.getZGArchitectureName(8, true);
    public static final String A68K = ZGUtil.getZGArchitectureName(5, true);
    public static final String AS390 = ZGUtil.getZGArchitectureName(11, true);
    public static final String GENERIC_RULE_DISP_STRING = "CSA";
    private Vector ai = new Vector();
    private Vector aj = new Vector();

    public static String[] getSerializableProperties() {
        String[] stringArray = new String[4];
        stringArray[0] = "installOnList";
        stringArray[1] = "doNotInstallOnList";
        stringArray[2] = "ruleId";
        stringArray[3] = "expressionID";
        return stringArray;
    }

    public ArchitectureChk() {
        this.aj.addAll(ArchitectureChk.getAllArchitectures());
    }

    public static Vector getAllArchitectures() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(X86);
        vector.addElement(IA64);
        vector.addElement(AMD64);
        vector.addElement(MIPS);
        vector.addElement(PARISC);
        vector.addElement(SPARC);
        vector.addElement(PPC);
        vector.addElement(PPC64);
        vector.addElement(ALPHA);
        vector.addElement(POWER);
        vector.addElement(A68K);
        vector.addElement(AS390);
        vector.addElement("Unlisted architectures");
        return vector;
    }

    public static boolean isCompatibleWith(InstallPiece installPiece) {
        return true;
    }

    @Override
    public boolean checkSelf(Hashtable hashtable) {
        if (!Beans.isDesignTime()) {
            Enumeration enumeration = this.aj.elements();
            while (enumeration.hasMoreElements()) {
                if (!this.ad((String)enumeration.nextElement())) continue;
                return false;
            }
            enumeration = this.ai.elements();
            while (enumeration.hasMoreElements()) {
                if (!this.ad((String)enumeration.nextElement())) continue;
                return true;
            }
            return this.ai.contains("Unlisted architectures");
        }
        return true;
    }

    public static boolean canBeDisplayed() {
        return true;
    }

    @Override
    public boolean hasInstallPermissions() {
        return true;
    }

    public String aa() {
        return System.getProperty("os.arch");
    }

    public boolean ab(int n) {
        return ZGUtil.ARCHITECTURE == n;
    }

    private boolean ad(String string) {
        if (string.equals(X86)) {
            if (ZGUtil.WIN32 && !ZGUtil.getRunningPure()) {
                return Sys.getNativeArchitecture().equals("INTEL");
            }
            return this.ab(1);
        }
        if (string.equals(IA64)) {
            if (ZGUtil.WIN32 && !ZGUtil.getRunningPure()) {
                return Sys.getNativeArchitecture().equals("IA64");
            }
            return this.ab(9);
        }
        if (string.equals(AMD64)) {
            if (ZGUtil.WIN32 && !ZGUtil.getRunningPure()) {
                return Sys.getNativeArchitecture().equals("AMD64");
            }
            return this.ab(10);
        }
        if (string.equals(MIPS)) {
            return this.ab(4);
        }
        if (string.equals(PARISC)) {
            return this.ab(7);
        }
        if (string.equals(SPARC)) {
            return this.ab(6);
        }
        if (string.equals(PPC)) {
            return this.ab(2);
        }
        if (string.equals(PPC64)) {
            return this.ab(12);
        }
        if (string.equals(ALPHA)) {
            return this.ab(3);
        }
        if (string.equals(POWER)) {
            return this.ab(8);
        }
        if (string.equals(A68K)) {
            return this.ab(5);
        }
        if (string.equals(AS390)) {
            return this.ab(11);
        }
        return string.equals(this.aa());
    }

    public void setInstallOnList(Vector vector) {
        this.ai = vector;
    }

    public void setDoNotInstallOnList(Vector vector) {
        this.aj = vector;
    }

    public Vector getInstallOnList() {
        return this.ai;
    }

    public Vector getDoNotInstallOnList() {
        return this.aj;
    }

    public void addToDoNotInstallOnList(String string) {
        this.aj.addElement(string);
        if (!this.aj.contains(string)) {
            this.aj.addElement(string);
        }
        if (this.ai.contains(string)) {
            this.ai.removeElement(string);
        }
    }

    public void removeFromDoNotInstallOnList(String string) {
        this.aj.removeElement(string);
    }

    public void addToInstallOnList(String string) {
        if (!this.ai.contains(string)) {
            this.ai.addElement(string);
        }
        if (this.aj.contains(string)) {
            this.aj.removeElement(string);
        }
    }

    public void removeFromInstallOnList(String string) {
        this.ai.removeElement(string);
    }

    public Vector getUnusedArchitectures() {
        Vector vector = ArchitectureChk.getAllArchitectures();
        vector.removeAll(this.ai);
        vector.removeAll(this.aj);
        return vector;
    }

    @Override
    public String getGenericDisplayString() {
        return GENERIC_RULE_DISP_STRING;
    }

    static {
        ClassInfoManager.aa(ArchitectureChk.class, IAResourceBundle.getValue("Designer.Rule.ArchitectureChk.visualName"), null);
    }
}

