/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.iseries.service;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSTextFileOutputStream;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallShieldUniversal10AndOlderRegistry;
import com.zerog.ia.api.pub.InstallShieldUniversalRegistry;
import com.zerog.ia.api.pub.InstallShieldUniversalSoftwareObject;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.InstallerResources;
import com.zerog.ia.installer.iseries.service.i5OSServiceImpl;
import com.zerog.ia.installer.util.i5OSRegisteredApp;
import com.zerog.util.IAResourceBundle;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class IBMi5OSProductServiceImpl {
    public final String NOTSET = "$$unspecified$$";
    public static final int RAIR_ADD = 1;
    public static final int RAIR_REMOVE = 2;
    private String installerType_ = "InstallAnywhere (9.0)";
    private String ccsid_ = "37";
    private static final boolean NOISY = System.getProperty("debug.IBMi5OSProductServiceImpl") != null;
    private static final boolean DEBUG_REG = System.getProperty("debug.IBMi5OSProductServiceImplRAIR") != null;
    private static final String copyright = "(C) Copyright IBM Corporation 2007.";
    private String productName = null;
    private static String productURL = "/product.xml";
    private String presetUninstallerInstallLocation;
    private String tempUninstallerFolder;
    private Vector appsToRegister = new Vector();
    private Vector appsToUnregister = new Vector();
    private Vector appsToList = new Vector();
    private AS400 system400_ = null;
    private i5OSServiceImpl os = new i5OSServiceImpl();
    public String PRODUCT_ATTR = "ProductName=";
    public String FEATURE_ATTR = "FeatureName=";
    public String COMP_ATTR = "ComponentName=";
    public String INST_ATTR = "Instance=";
    public String VENDOR_ATTR = "ComponentVendor=";
    public String RELEASE_ATTR = "ComponentVersion=";
    public String INSTALLER_ATTR = "InstallerType=";
    public String PACKAGED_ATTR = "PackagedProduct=";
    public String CCSID_ATTR = "CCSID=";

    public int getSystemCompatibility() {
        return this.os.getSystemCompatibility();
    }

    public void preInstallProduct() {
        String string = IAResourceBundle.getValue("startmsg1");
        String string2 = IAResourceBundle.getValue("startmsg2");
        String string3 = "";
        try {
            AS400 aS400 = this.os.geti5();
            string3 = aS400.getUserId();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void postInstallProduct(InstallerProxy installerProxy) {
        String string = IAResourceBundle.getValue("endmsg1");
        String string2 = IAResourceBundle.getValue("endmsg2");
        try {
            this.performRegisterAction(1, installerProxy);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void performRegisterAction(int n, InstallerProxy installerProxy) {
        block20: {
            if (NOISY) {
                System.out.println("Performing register action : " + n);
            }
            if (installerProxy == null) {
                return;
            }
            if (!this.isRegistrationEnabled(installerProxy)) {
                // empty if block
            }
            if (!this.isRAIRAvailable()) {
                return;
            }
            InstallerResources installerResources = (InstallerResources)installerProxy.getService(InstallerResources.class);
            System.out.println("in performRegisterAction $PRODUCT_VERSION$ " + installerProxy.substitute("$PRODUCT_VERSION_NUMBER$") + " " + installerProxy.substitute("$PRODUCT_ID$"));
            System.out.println("in performRegisterAction $REG_COMPONENT$ " + installerProxy.substitute("$REG_COMPONENT_COUNT$") + " " + installerProxy.substitute("$REG_COMPONENT_VERSIONS$") + " " + installerProxy.substitute("$REG_COMPONENT_LOCATIONS$"));
            String string = null;
            String string2 = null;
            string = installerResources.getDefaultInstallSet();
            Vector vector = installerResources.getInstallSets();
            if (NOISY) {
                System.out.println("Features Length: " + vector.capacity());
            }
            for (int i = 0; i < vector.capacity(); ++i) {
                String string3 = (String)vector.elementAt(i);
                string2 = (String)vector.elementAt(i);
                if (NOISY) {
                    System.err.println("Feature Name: " + string2);
                }
                Vector vector2 = installerResources.getInstallBundles();
                for (int j = 0; j < vector2.capacity(); ++j) {
                    if (!NOISY) continue;
                    System.err.println("Components Name: " + vector2.elementAt(j));
                }
            }
            Vector vector3 = this.findComponents(installerProxy, string);
            for (int i = 0; i < vector3.capacity(); ++i) {
            }
            if (n == 1) {
                block19: {
                    try {
                        this.unregisterOldComponents();
                    }
                    catch (Exception exception) {
                        if (!NOISY) break block19;
                        System.out.println("RAIR001: An exception occurred unregistering older versions of components.");
                    }
                }
                try {
                    this.registerComponents();
                }
                catch (Exception exception) {
                    if (NOISY) {
                        System.out.println("RAIR002: An exception occurred registering the components.");
                    }
                    break block20;
                }
            }
            if (n == 2) {
                try {
                    this.unregisterComponents();
                }
                catch (Exception exception) {
                    if (!NOISY) break block20;
                    System.out.println("RAIR003: An exception occurred unregistering the components.");
                }
            }
        }
        if (NOISY) {
            System.out.println("Registration process completed.");
        }
    }

    private void processComponent(int n, String string, String string2, InstallerProxy installerProxy) {
        Object object;
        String string3;
        String string4;
        String string5;
        InstallShieldUniversalSoftwareObject installShieldUniversalSoftwareObject;
        Object object2;
        block28: {
            if (installerProxy == null) {
                return;
            }
            InstallShieldUniversalRegistry installShieldUniversalRegistry = (InstallShieldUniversalRegistry)installerProxy.getService(InstallShieldUniversalRegistry.class);
            InstallShieldUniversalRegistry installShieldUniversalRegistry2 = (InstallShieldUniversalRegistry)installerProxy.getService(InstallShieldUniversal10AndOlderRegistry.class);
            if (installShieldUniversalRegistry.isVpdAvailable()) {
                System.out.println("Component to process (VPD Available isuReg = true) : " + installShieldUniversalRegistry.getVpdLocation());
            } else {
                System.out.println("isuReg not available");
            }
            if (installShieldUniversalRegistry2.isVpdAvailable()) {
                System.out.println("Component to process (VPD Available isuVer10Reg = true) : " + installShieldUniversalRegistry2.getVpdLocation());
            } else {
                System.out.println("isuVer10Reg not available");
            }
            object2 = "0.0.0.0";
            installShieldUniversalSoftwareObject = installShieldUniversalRegistry.getSoftwareObject("00000000000000000000000000000002", (String)object2);
            InstallShieldUniversalSoftwareObject installShieldUniversalSoftwareObject2 = installShieldUniversalRegistry2.getSoftwareObject("00000000000000000000000000000002", (String)object2);
            string5 = installShieldUniversalSoftwareObject.getInstallLocation();
            string4 = installShieldUniversalSoftwareObject.getName();
            string3 = installShieldUniversalSoftwareObject.getVendorName();
            if (string5 != null) {
                string5 = this.os.normalizePathToi5(string5);
            }
            try {
                String string6;
                String string7;
                String string8;
                String string9;
                block36: {
                    block35: {
                        String string10;
                        block34: {
                            block33: {
                                block32: {
                                    block31: {
                                        block30: {
                                            block29: {
                                                System.out.println("in processComponent : InstallShieldUniversalSoftwareObject " + installShieldUniversalSoftwareObject.getDisplayName());
                                                object = installShieldUniversalSoftwareObject.getUUID();
                                                if (object == null || (string10 = installShieldUniversalSoftwareObject.getVersion()) == null) break block28;
                                                string9 = string10.substring(0, 1);
                                                if (string9 == null) break block29;
                                                if (!string9.trim().equals("")) break block30;
                                            }
                                            string9 = "0";
                                        }
                                        if ((string8 = string10.substring(2, 3)) == null) break block31;
                                        if (!string8.trim().equals("")) break block32;
                                    }
                                    string8 = "0";
                                }
                                if ((string7 = string10.substring(4, 5)) == null) break block33;
                                if (!string7.trim().equals("")) break block34;
                            }
                            string7 = "0";
                        }
                        if ((string6 = string10.substring(6, 7)) == null) break block35;
                        if (!string6.trim().equals("")) break block36;
                    }
                    string6 = "0";
                }
                object2 = string9 + "." + string8 + "." + string7 + "." + string6;
            }
            catch (Exception exception) {
                if (!NOISY) break block28;
                System.out.println("Release information was not valid.");
                exception.printStackTrace();
            }
        }
        if (installShieldUniversalSoftwareObject != null) {
            if (string != null) {
                string = installShieldUniversalSoftwareObject.getName();
                string = this.replaceXMLEntities(string);
            }
            if (string2 != null) {
                string2 = installShieldUniversalSoftwareObject.getUUID();
                string2 = this.replaceXMLEntities(string2);
            }
            if (string4 != null) {
                string4 = installShieldUniversalSoftwareObject.getDescription();
                string4 = this.replaceXMLEntities(string4);
            }
            if (string3 != null) {
                string3 = installShieldUniversalSoftwareObject.getVendorWebsite();
                string3 = this.replaceXMLEntities(string3);
            }
            if (object2 != null) {
                object2 = installShieldUniversalSoftwareObject.getCompatibleVersion();
                object2 = this.replaceXMLEntities((String)object2);
            }
            if (string5 != null) {
                string5 = installShieldUniversalSoftwareObject.getUUID();
                string5 = this.replaceXMLEntities(string5);
            }
        }
        object = new i5OSRegisteredApp();
        ((i5OSRegisteredApp)object).setProductName(string);
        ((i5OSRegisteredApp)object).setFeatureName(string2);
        ((i5OSRegisteredApp)object).setComponentName(string4);
        ((i5OSRegisteredApp)object).setVendor(string3);
        ((i5OSRegisteredApp)object).setRelease((String)object2);
        ((i5OSRegisteredApp)object).setInstance(string5);
        if (n == 1) {
            this.removeOldReleases((i5OSRegisteredApp)object);
        }
        this.addComponent((i5OSRegisteredApp)object, n);
    }

    private String replaceXMLEntities(String string) {
        Object object;
        block3: {
            object = "";
            try {
                for (int i = 0; i < string.length(); ++i) {
                    object = string.charAt(i) == '&' ? (String)object + "&amp;" : (string.charAt(i) == '<' ? (String)object + "&lt;" : (string.charAt(i) == '>' ? (String)object + "&gt;" : (string.charAt(i) == '\"' ? (String)object + "&quot;" : (string.charAt(i) == '\'' ? (String)object + "&apos;" : (String)object + string.charAt(i)))));
                }
            }
            catch (Exception exception) {
                if (!NOISY) break block3;
                System.out.println("An exception occurred parsing the string for XML.");
            }
        }
        return object;
    }

    private String createNewTempUninstallerFolder(InstallerProxy installerProxy) throws IOException {
        if (this.tempUninstallerFolder != null) {
            if (!this.tempUninstallerFolder.equals("")) {
                File file = new File(installerProxy.getTempDirectory().getAbsolutePath());
                file.delete();
            }
        }
        this.tempUninstallerFolder = installerProxy.getTempDirectory().getAbsolutePath();
        return this.tempUninstallerFolder;
    }

    private boolean isRegistrationEnabled(InstallerProxy installerProxy) {
        boolean bl = false;
        if (installerProxy == null) {
            return bl;
        }
        try {
            URL uRL = installerProxy.getResource(this.os.getPropertiesResourceName());
            Properties properties = new Properties();
            properties.load(uRL.openStream());
            String string = (String)properties.get("RAIR.Registration.Enabled");
            if (string.equalsIgnoreCase("true")) {
                bl = true;
                if (NOISY) {
                    System.out.println("Registration was enabled!!!");
                }
            } else if (NOISY) {
                System.out.println("Registration was not enabled!!!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public Object getSpecialProductBeanProperty(InstallerProxy installerProxy, String string) throws InstallException {
        if (string.equals("absoluteInstallLocation")) {
            String string2 = "test absoluteInstallLocation";
            System.out.println("In getSpecialBeanProperty returning " + this.os.normalizePathToi5(string2));
            return this.os.normalizePathToi5(string2);
        }
        return "test not absoluteInstallLocation";
    }

    private Vector findComponents(InstallerProxy installerProxy, String string) {
        Vector vector = new Vector();
        return vector;
    }

    private void init() throws InstallException {
        block4: {
            try {
                if (this.system400_ == null) {
                    this.system400_ = this.os.geti5();
                    if (this.system400_ == null) {
                        throw new Exception("Connection could not be established with system.");
                    }
                }
            }
            catch (Exception exception) {
                if (!NOISY) break block4;
                System.out.println("Exception occurred initializing i5/OS system: " + exception.getLocalizedMessage());
            }
        }
    }

    public void addComponent(i5OSRegisteredApp i5OSRegisteredApp2, int n) {
        if (n == 1) {
            this.appsToRegister.addElement(i5OSRegisteredApp2);
        } else if (n == 2) {
            this.appsToUnregister.addElement(i5OSRegisteredApp2);
        }
    }

    private void removeOldReleases(i5OSRegisteredApp i5OSRegisteredApp2) {
        if (i5OSRegisteredApp2 == null) {
            return;
        }
        if (NOISY) {
            System.out.println("Collecting old release entries of...");
            System.out.println("Product   : " + i5OSRegisteredApp2.getProductName());
            System.out.println("Feature   : " + i5OSRegisteredApp2.getFeatureName());
            System.out.println("Component : " + i5OSRegisteredApp2.getComponentName());
            System.out.println("Instance  : " + i5OSRegisteredApp2.getInstance());
            System.out.println("Vendor    : " + i5OSRegisteredApp2.getVendor());
        }
        i5OSRegisteredApp i5OSRegisteredApp3 = new i5OSRegisteredApp();
        i5OSRegisteredApp3.setProductName(i5OSRegisteredApp2.getProductName());
        i5OSRegisteredApp3.setFeatureName(i5OSRegisteredApp2.getFeatureName());
        i5OSRegisteredApp3.setComponentName(i5OSRegisteredApp2.getComponentName());
        i5OSRegisteredApp3.setInstance(i5OSRegisteredApp2.getInstance());
        i5OSRegisteredApp3.setVendor(i5OSRegisteredApp2.getVendor());
        i5OSRegisteredApp3.setRelease("$$unspecified$$");
        this.appsToList.addElement(i5OSRegisteredApp3);
    }

    public void registerComponents() throws InstallException {
        if (NOISY) {
            System.out.println("Registering components...");
        }
        if (this.appsToRegister.size() != 0) {
            this.invokeQSZUPDRA(1, null);
        }
    }

    public void unregisterComponents() throws InstallException {
        if (NOISY) {
            System.out.println("Unregistering components...");
        }
        if (this.appsToUnregister.size() != 0) {
            this.invokeQSZUPDRA(2, null);
        }
    }

    private void createXMLInputQSZUPDRA(int n, String string) throws InstallException {
        block16: {
            try {
                String string2 = "\"";
                IFSFile iFSFile = new IFSFile(this.system400_, string);
                if (iFSFile.exists()) {
                    iFSFile.delete();
                }
                IFSTextFileOutputStream iFSTextFileOutputStream = new IFSTextFileOutputStream(this.system400_, iFSFile, -4, false);
                iFSTextFileOutputStream.write("<?xml version=\"1.0\" encoding='ucs-2'?>");
                iFSTextFileOutputStream.write("<!DOCTYPE RegAppInfoRepository SYSTEM \"/QIBM/XML/DTD/QszRegAppInfoRepository.dtd\">");
                iFSTextFileOutputStream.write("<RegAppInfoRepository DTDVersion=\"1.0\">");
                Enumeration enumeration = null;
                if (n == 1) {
                    enumeration = this.appsToRegister.elements();
                } else if (n == 2) {
                    enumeration = this.appsToUnregister.elements();
                } else {
                    if (NOISY) {
                        System.out.println("createXMLInputQSZUPDRA:: function value not correct.");
                    }
                    return;
                }
                while (enumeration != null && enumeration.hasMoreElements()) {
                    i5OSRegisteredApp i5OSRegisteredApp2 = (i5OSRegisteredApp)enumeration.nextElement();
                    if (i5OSRegisteredApp2.getProductName() == null) continue;
                    if (i5OSRegisteredApp2.getProductName() == "$$unspecified$$" || i5OSRegisteredApp2.getFeatureName() == null) continue;
                    if (i5OSRegisteredApp2.getFeatureName() == "$$unspecified$$") continue;
                    Vector<Object> vector = new Vector<Object>();
                    vector.addElement("<Component ");
                    vector.addElement(this.PRODUCT_ATTR + string2 + i5OSRegisteredApp2.getProductName() + string2);
                    vector.addElement(this.COMP_ATTR + string2 + i5OSRegisteredApp2.getComponentName() + string2);
                    if (i5OSRegisteredApp2.getFeatureName() != "$$unspecified$$") {
                        vector.addElement(this.FEATURE_ATTR + string2 + i5OSRegisteredApp2.getFeatureName() + string2);
                    }
                    if (i5OSRegisteredApp2.getInstance() != "$$unspecified$$") {
                        vector.addElement(this.INST_ATTR + string2 + i5OSRegisteredApp2.getInstance() + string2);
                    }
                    if (i5OSRegisteredApp2.getVendor() != "$$unspecified$$") {
                        vector.addElement(this.VENDOR_ATTR + string2 + i5OSRegisteredApp2.getVendor() + string2);
                    }
                    if (i5OSRegisteredApp2.getRelease() != "$$unspecified$$") {
                        vector.addElement(this.RELEASE_ATTR + string2 + i5OSRegisteredApp2.getRelease() + string2);
                    }
                    vector.addElement(this.PACKAGED_ATTR + string2 + "0" + string2);
                    vector.addElement(">");
                    if (n == 1) {
                        vector.addElement("<ExtendedData ");
                        vector.addElement(this.INSTALLER_ATTR + string2 + this.installerType_ + string2);
                        vector.addElement(this.CCSID_ATTR + string2 + this.ccsid_ + string2);
                        vector.addElement(">");
                        vector.addElement("</ExtendedData>");
                    }
                    vector.addElement("</Component>");
                    for (int i = 0; i < vector.size(); ++i) {
                        String string3 = (String)vector.elementAt(i);
                        if (NOISY) {
                            System.out.println(string3);
                        }
                        iFSTextFileOutputStream.write(string3 + " \n");
                    }
                }
                iFSTextFileOutputStream.write("</RegAppInfoRepository> \n");
                iFSTextFileOutputStream.close();
            }
            catch (Exception exception) {
                if (!NOISY) break block16;
                System.out.println(exception.getLocalizedMessage());
            }
        }
    }

    private void initPCMLInputQSZUPDRA(ProgramCallDocument programCallDocument, String string) throws PcmlException {
        programCallDocument.setIntValue("qszupdra.appPath.CCSID", 0);
        programCallDocument.setValue("qszupdra.appPath.countryID", (Object)"0x0000");
        programCallDocument.setValue("qszupdra.appPath.languageID", (Object)"0x000000");
        programCallDocument.setValue("qszupdra.appPath.unused1", (Object)"0x000000");
        programCallDocument.setValue("qszupdra.appPath.unused2", (Object)"0x00000000000000000000");
        programCallDocument.setIntValue("qszupdra.appPath.pathLength", string.length());
        programCallDocument.setValue("qszupdra.appPath.appInfoPathName", (Object)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeQSZUPDRA(int n, String string) throws InstallException {
        ProgramCallDocument programCallDocument;
        this.init();
        String string2 = null;
        try {
            if (NOISY) {
                System.out.println("Initializing QSZUPDRA call...");
            }
            if (string == null) {
                string2 = this.os.createIFSTempFile().getAbsolutePath();
                this.createXMLInputQSZUPDRA(n, string2);
            } else {
                string2 = string;
            }
            programCallDocument = new ProgramCallDocument(this.system400_, "com.ibm.wizard.platform.as400.qszupdra");
            this.initPCMLInputQSZUPDRA(programCallDocument, string2);
            if (NOISY) {
                System.out.println("Invoking QSZUPDRA..., function: " + n);
            }
            programCallDocument.setIntValue("qszupdra.functionCode", n);
            boolean bl = programCallDocument.callProgram("qszupdra");
            if (NOISY) {
                System.out.println("Returned from QSZUPDRA...");
            }
            if (!bl) {
                AS400Message[] aS400MessageArray = programCallDocument.getMessageList("qszupdra");
                String string3 = "";
                String string4 = "";
                Object object = "";
                if (aS400MessageArray.length > 0) {
                    string3 = aS400MessageArray[0].getID();
                    string4 = aS400MessageArray[0].getText();
                    object = string3 + " - " + string4;
                    if (NOISY) {
                        System.out.println((String)object);
                    }
                }
                if (NOISY) {
                    for (int i = 1; i < aS400MessageArray.length; ++i) {
                        System.out.println(aS400MessageArray[i].getID() + " - " + aS400MessageArray[i].getText());
                    }
                }
                if (n == 2) {
                    if (string3.equals("CPF0CC7")) {
                        // empty if block
                    }
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (!DEBUG_REG) {
                    programCallDocument = new IFSFile(this.system400_, string2);
                    programCallDocument.delete();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean isRAIRAvailable() {
        if (NOISY) {
            System.out.println("Checking for RAIR availability...");
        }
        try {
            if (NOISY) {
                System.out.println("RAIR is available on the system.");
            }
            return true;
        }
        catch (Exception exception) {
            if (NOISY) {
                System.out.println("RAIR was not available on the system.");
            }
            return false;
        }
    }

    private void createXMLInputQSZLSTRA(IFSFile iFSFile) throws InstallException {
        block9: {
            try {
                String string = "\"";
                if (iFSFile.exists()) {
                    iFSFile.delete();
                }
                IFSTextFileOutputStream iFSTextFileOutputStream = new IFSTextFileOutputStream(this.system400_, iFSFile, -4, false);
                iFSTextFileOutputStream.write("<?xml version=\"1.0\" encoding='ucs-2'?>");
                iFSTextFileOutputStream.write("<!DOCTYPE RegAppInfoRepository SYSTEM \"/QIBM/XML/DTD/QszRegAppInfoRepository.dtd\">");
                iFSTextFileOutputStream.write("<RegAppInfoRepository DTDVersion=\"1.0\">");
                Enumeration enumeration = this.appsToList.elements();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    i5OSRegisteredApp i5OSRegisteredApp2 = (i5OSRegisteredApp)enumeration.nextElement();
                    if (i5OSRegisteredApp2.getProductName() == null) continue;
                    if (i5OSRegisteredApp2.getProductName() == "$$unspecified$$" || i5OSRegisteredApp2.getFeatureName() == null) continue;
                    if (i5OSRegisteredApp2.getFeatureName() == "$$unspecified$$") continue;
                    Vector<Object> vector = new Vector<Object>();
                    vector.addElement("<Component ");
                    vector.addElement(this.PRODUCT_ATTR + string + i5OSRegisteredApp2.getProductName() + string);
                    vector.addElement(this.COMP_ATTR + string + i5OSRegisteredApp2.getComponentName() + string);
                    if (i5OSRegisteredApp2.getFeatureName() != "$$unspecified$$") {
                        vector.addElement(this.FEATURE_ATTR + string + i5OSRegisteredApp2.getFeatureName() + string);
                    }
                    if (i5OSRegisteredApp2.getInstance() != "$$unspecified$$") {
                        vector.addElement(this.INST_ATTR + string + i5OSRegisteredApp2.getInstance() + string);
                    }
                    if (i5OSRegisteredApp2.getVendor() != "$$unspecified$$") {
                        vector.addElement(this.VENDOR_ATTR + string + i5OSRegisteredApp2.getVendor() + string);
                    }
                    vector.addElement(this.PACKAGED_ATTR + string + "0" + string);
                    vector.addElement(">");
                    vector.addElement("</Component>");
                    for (int i = 0; i < vector.size(); ++i) {
                        String string2 = (String)vector.elementAt(i);
                        if (NOISY) {
                            System.out.println(string2);
                        }
                        iFSTextFileOutputStream.write(string2 + " \n");
                    }
                }
                iFSTextFileOutputStream.write("</RegAppInfoRepository> \n");
                iFSTextFileOutputStream.close();
            }
            catch (Exception exception) {
                if (!NOISY) break block9;
                System.out.println(exception.getLocalizedMessage());
            }
        }
    }

    private void initPCMLInputQSZLSTRA(ProgramCallDocument programCallDocument, IFSFile iFSFile, IFSFile iFSFile2) throws PcmlException {
        programCallDocument.setIntValue("qszlstra.inputXML.CCSID", 37);
        programCallDocument.setIntValue("qszlstra.outputXML.CCSID", 37);
        programCallDocument.setIntValue("qszlstra.inputXML.countryID", 0);
        programCallDocument.setIntValue("qszlstra.outputXML.countryID", 0);
        programCallDocument.setIntValue("qszlstra.inputXML.languageID", 0);
        programCallDocument.setIntValue("qszlstra.outputXML.languageID", 0);
        programCallDocument.setIntValue("qszlstra.inputXML.unused1", 0);
        programCallDocument.setIntValue("qszlstra.outputXML.unused1", 0);
        programCallDocument.setIntValue("qszlstra.inputXML.unused2", 0);
        programCallDocument.setIntValue("qszlstra.outputXML.unused2", 0);
        programCallDocument.setIntValue("qszlstra.inputXML.pathLength", iFSFile.getAbsolutePath().length());
        programCallDocument.setIntValue("qszlstra.outputXML.pathLength", iFSFile2.getAbsolutePath().length());
        programCallDocument.setValue("qszlstra.inputXML.appInfoPathName", (Object)iFSFile.getAbsolutePath());
        programCallDocument.setValue("qszlstra.outputXML.appInfoPathName", (Object)iFSFile2.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterOldComponents() throws InstallException {
        if (NOISY) {
            System.out.println("Unregistering old components...");
        }
        this.init();
        IFSFile iFSFile = null;
        IFSFile iFSFile2 = null;
        try {
            iFSFile = this.os.createIFSTempFile();
            iFSFile2 = this.os.createIFSTempFile();
            if (DEBUG_REG) {
                System.out.println("XML input file for QSZLSTRA   : " + iFSFile.getAbsolutePath());
                System.out.println("XML output file from QSZLSTRA : " + iFSFile2.getAbsolutePath());
            }
            this.createXMLInputQSZLSTRA(iFSFile);
            IFSTextFileOutputStream iFSTextFileOutputStream = new IFSTextFileOutputStream(this.system400_, iFSFile2.getAbsolutePath(), -4, false);
            iFSTextFileOutputStream.close();
            ProgramCallDocument programCallDocument = new ProgramCallDocument(this.system400_, "com.zerog.ia.installer.iseries.util.qszlstra");
            this.initPCMLInputQSZLSTRA(programCallDocument, iFSFile, iFSFile2);
            if (NOISY) {
                System.out.println("Invoking QSZLSTRA...");
            }
            boolean bl = programCallDocument.callProgram("qszlstra");
            if (NOISY) {
                System.out.println("Returned from QSZLSTRA");
            }
            if (!bl) {
                AS400Message[] aS400MessageArray = programCallDocument.getMessageList("qszlstra");
                String string = "";
                String string2 = "";
                Object object = "";
                if (aS400MessageArray.length > 0) {
                    string = aS400MessageArray[0].getID();
                    string2 = aS400MessageArray[0].getText();
                    object = string + " - " + string2;
                    if (NOISY) {
                        System.out.println((String)object);
                    }
                }
                if (NOISY) {
                    for (int i = 1; i < aS400MessageArray.length; ++i) {
                        System.out.println(aS400MessageArray[i].getID() + " - " + aS400MessageArray[i].getText());
                    }
                }
            } else {
                if (DEBUG_REG) {
                    System.out.println("Unregistering old components: XML input file for RAIR removal..." + iFSFile2.getAbsolutePath());
                }
                this.invokeQSZUPDRA(2, iFSFile2.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            if (NOISY) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                if (!DEBUG_REG) {
                    iFSFile.delete();
                    iFSFile2.delete();
                }
            }
            catch (Exception exception) {}
        }
    }
}

